/* Classe RL para circuitos RL
*
*  em Maio 2001, por Marcos Portnoi
*
*
*  Atributos:    f = frequencia fonte
*                r = valor resistor
*                l = valor indutor
*               vt = tensao fonte
*               vl = tensao indutor (modulo)
*               vr = tensao resistor
*                z = impedncia (modulo)
*               xl = reatncia indutor
*               it = corrente fornecida fonte
*               il = corrente indutor (modulo)
*               ir = corrente resistor
*             type = tipo de rede (p=paralelo, s=serial)
*               PI = constante pi
*/

package Redes;

/**
 */
public class Rl
{
	private double f, r, l, vt, vl, vr, z, xl, it, il, ir;
	private char type;
	private double PI=3.1415;
		
	// Construtor
	public Rl (double vt, double r, double l, double f, char type)
	{
		this.vt = vt;
		this.r = r;
		this.l = l;
		this.f = f;
		this.type = type;
	}
	
	// Construtor nulo
	public Rl ()
	{
	}
	
	/* Mtodos para setar atributos independentemente */
	public void setVoltage (double vt)
	{
		this.vt = vt;
	}
	
	public void setResistor (double r)
	{
		this.r = r;
	}
	
	public void setIndutance (double l)
	{
		this.l = l;
	}
	
	public void setFrequency (double f)
	{
		this.f = f;
	}
	
	public void setNetType (char type) // tipo de rede, paralela ou srie
	{
		this.type = type;
	}
	
	//calcula os valores do circuito
	public void calcValues()
	{
		switch (type)
		{
		case 's':
			xl = 2*PI*f*l;
			z = Math.sqrt(r*r + xl*xl);
			it = vt/z;
			il = it;
			ir = it;
			vl = it*xl;
			vr = it*r;
			break;
		case 'p':
			xl = 2*PI*f*l;
			z = (xl*r)/Math.sqrt(r*r + xl*xl);
			it = vt/z;
			vr = vt;
			vl = vt;
			il = vl/xl;
			ir = vr/r;
			break;
		}
	}
	
	public void printValues()
	{
		System.out.print("\n\nCircuito tipo RL:  ");
		if (type=='s')
			System.out.println("serie\n\n");
		else
			System.out.println("paralelo\n\n");
		
		System.out.println("Fonte:  "+vt+"  Volt     Frequencia:  "+f+"  Hz");
		System.out.println("Resistor:  "+r+"  Ohm");
		System.out.println("Indutor:  "+l+"  Henry\n");
		System.out.println("it = "+it+" A");
		System.out.println("xl = "+xl+" Ohm\nvl = "+vl+" V\nil = "+il+" A");
		System.out.println("z  = "+z+" Ohm\nvr = "+vr+" V\nir = "+ir+" A");
	}
}
