/* Classe RC para circuitos RC
*
*  em Maio 2001, por Marcos Portnoi
*
*
*  Atributos:    f = frequencia fonte
*                r = valor resistor
*                c = valor capacitor
*               vt = tensao fonte
*               vc = tensao capacitor (modulo)
*               vr = tensao resistor
*                z = impedncia (modulo)
*               xc = reatncia capacitor
*               it = corrente fornecida fonte
*               ir = corrente resistor
*               ic = corrente capacitor (modulo)
*             type = tipo de rede (p=paralelo, s=serial)
*               PI = constante pi
*/

package Redes;

/**
 */
public class Rc
{
	private double f, r, c, vt, vc, vr, z, xc, it, ic, ir;
	private char type;
	private double PI=3.1415;
		
	// Construtor
	public Rc (double vt, double r, double c, double f, char type)
	{
		this.vt = vt;
		this.r = r;
		this.c = c;
		this.f = f;
		this.type = type;
	}
	
	// Construtor nulo
	public Rc ()
	{
	}
	
	/* Mtodos para setar atributos independentemente */
	public void setVoltage (double vt)
	{
		this.vt = vt;
	}
	
	public void setResistor (double r)
	{
		this.r = r;
	}
	
	public void setCapacitor (double c)
	{
		this.c = c;
	}
	
	public void setFrequency (double f)
	{
		this.f = f;
	}
	
	public void setNetType (char type)  // tipo de rede, paralela ou srie
	{
		this.type = type;
	}
	
	//calcula os valores do circuito
	public void calcValues()
	{
		switch (type)
		{
		case 's':
			xc = 1/(2*PI*f*c);
			z = Math.sqrt(r*r + xc*xc);
			it = vt/z;
			ic = it;
			ir = it;
			vc = it*xc;
			vr = it*r;
			break;
		case 'p':
			xc = 1/(2*PI*f*c);
			z = (xc*r)/Math.sqrt(r*r + xc*xc);
			it = vt/z;
			vr = vt;
			vc = vt;
			ic = vc/xc;
			ir = vr/r;
			break;
		}
	}
	
	public void printValues()
	{
		System.out.print("\n\nCircuito tipo RC:  ");
		if (type=='s')
			System.out.println("serie\n\n");
		else
			System.out.println("paralelo\n\n");
		
		System.out.println("Fonte:  "+vt+"  Volt     Frequencia:  "+f+"  Hz");
		System.out.println("Resistor:  "+r+"  Ohm");
		System.out.println("Capacitor:  "+c+"  Farad\n");
		System.out.println("it = "+it+" A");
		System.out.println("xc = "+xc+" Ohm\nvc = "+vc+" V\nic = "+ic+" A");
		System.out.println("z  = "+z+" Ohm\nvr = "+vr+" V\nir = "+ir+" A");
	}
}
