/* Classe Principal para Programa Circuitos
*
*  Objetivo:  efetuar clculos das correntes, tenses, impedncia e reatncias
*             em circuitos RL, RC e RLC paralelo ou srie.
*
*  em Maio 2001, por Marcos Portnoi
*
*
*
*
*  Ordem de entrada de argumentos pela linha de comando:
*
*  Circuitos (rc|rl|rlc) (s|p) vt f r l c
*
*  onde  rc, rl e rlc so os tipos de circuito (1 tipo)
*         s:  serie ou
*         p:  paralelo
*        vt:  tenso fonte
*         f:  valor da frequencia da fonte
*         r:  valor do resistor
*         l:  valor do indutor (s fornecer para RL e RLC)
*         c:  valor do capacitor (s fornecer para RC e RLC)
*
*  Ex:
*     RC serie, R=10, C=0.01, VT=10, F=60
*        Circuitos rc s 10 60 10 .01
*
*     RL paralelo, R=10, L=15, VT=10, F=60
*        Circuitos rl p 10 60 10 15
*
*     RLC serie, R=10, C=0.01, L=20, VT=10, F=60
*        Circuitos rlc s 10 60 10 20 .01
*
*/

package Redes;
//import Redes.*;

/**
 */
public class Circuitos
{
	private static void badArgs()
	{
		System.out.println("\n\nErro:  uso incorreto\n");
		System.out.println("   >Circuitos (rc|rl|rlc) (s|p) vt f r l c\n");
		System.out.println("    onde  rc, rl e rlc sao os tipos de circuito (1 tipo)");
		System.out.println("          s:  serie ou");
		System.out.println("          p:  paralelo");
		System.out.println("         vt:  tensao fonte");
		System.out.println("          f:  valor da frequencia da fonte");
		System.out.println("          r:  valor do resistor");
		System.out.println("          l:  valor do indutor (so fornecer para RL e RLC)");
		System.out.println("          c:  valor do capacitor (so fornecer para RC e RLC)");
		System.out.println("\n    Somente valores nao-nulos e positivos sao admitidos");
	}
	
	
	public static void main(String[] args)
	{
		double f, r, l, c, vt;
		char type;
		
		if (args.length==2 && args[0].equals("Locksmith"))  // Ovo de Pscoa :)
		{
			easterEgg(args[1].charAt(0));
			return;
		}
		
		//teste de consistncia dos argumentos
		if (args.length<6 || (args[0].equalsIgnoreCase("rlc") && args.length!=7) || ((args[0].equalsIgnoreCase("rc") || args[0].equalsIgnoreCase("rl")) && args.length!=6) || (!args[0].equalsIgnoreCase("rc") && !args[0].equalsIgnoreCase("rl") && !args[0].equalsIgnoreCase("rlc")) || (!args[1].equalsIgnoreCase("s") && !args[1].equalsIgnoreCase("p"))) 
		{
			badArgs(); //argumentos ruins:  erro e sair
			return;
		}
		for (int i=2; i<=args.length-1; i++)
		{
			if (Double.valueOf(args[i]).doubleValue()<=0)
			{
				badArgs();  //argumentos ruins:  erro e sair
				return;
			}
		}
		//fim de teste de consistncia
		
		//setar atributos independentes do tipo de circuito
		type = args[1].charAt(0);
		vt = Double.valueOf(args[2]).doubleValue();
		f = Double.valueOf(args[3]).doubleValue();
		r = Double.valueOf(args[4]).doubleValue();
		
		//setar atributos dependentes do tipo de circuito e criar objetos
		if (args[0].equalsIgnoreCase("rc"))
		{
			c = Double.valueOf(args[5]).doubleValue();
			Rc rcobj = new Rc (vt, r, c, f, type);
			rcobj.calcValues();
			rcobj.printValues();
		}
		
		if (args[0].equalsIgnoreCase("rl"))
		{
			l = Double.valueOf(args[5]).doubleValue();
			Rl rlobj = new Rl (vt, r, l, f, type);
			rlobj.calcValues();
			rlobj.printValues();
		}
		
		if (args[0].equalsIgnoreCase("rlc"))
		{
			l = Double.valueOf(args[5]).doubleValue();
			c = Double.valueOf(args[6]).doubleValue();
			Rlc rlcobj = new Rlc (vt, r, l, c, f, type);
			rlcobj.calcValues();
			rlcobj.printValues();
		}
		
	}
	
	// What is this with programmers and Easter Eggs? :))
	private static void easterEgg(char choice)
	{
		char egg = choice;
		System.out.println("\n\nCircuitos (c) 2001 by Marcos Portnoi");
		System.out.println("\nThe menu for today is:");
		switch (egg)
		{
		case '0':
			System.out.println("Big Mac, McChicken Supreme and large fries + Diet Coke");
			break;
		case '1':
			System.out.println("Large SuperSupreme pan pizza @ Pizza Hut.");
			break;
		case '2':
			System.out.println("Filet Parmeggiana with lots of cheese.");
			break;
		case '3':
			System.out.println("Rodizio de Churrasco (bbq), because meat we need. :)");
			break;
		case '4':
			System.out.println("2 large salads @ Subway.");
			break;
		case '5':
			System.out.println("Movies and popcorn.");
			break;
		case '6':
			System.out.println("A bag of chips and melted cheese.");
			break;
		case '7':
			System.out.println("Microwave lasagna bolognese by Sadia.");
			break;
		case '8':
			System.out.println("Just a chocolate bar.");
			break;
		case '9':
			System.out.println("Not hungry?  Fine.");
			break;
		default:
			System.out.println("Sorry, kitchen closed today.");
		}
	}
	

}
