/* Classe RLC para circuitos RLC
*
*  em Maio 2001, por Marcos Portnoi
*
*
*  Atributos:    f = frequencia fonte
*                r = valor resistor
*                l = valor indutor
*                c = valor capacitor
*               vt = tensao fonte
*               vl = tensao indutor (modulo)
*               vc = tensao capacitor (modulo)
*               vr = tensao resistor
*                z = impedncia (modulo)
*               xl = reatncia indutor
*               xc = reatncia capacitor
*               it = corrente fornecida fonte
*               il = corrente indutor (modulo)
*               ir = corrente resistor
*               ic = corrente capacitor (modulo)
*             type = tipo de rede (p=paralelo, s=serial)
*               PI = constante pi
*
*/

package Redes;

/**
 */
public class Rlc
{
	private double f, r, l, c, vt, vl, vc, vr, z, xl, xc, it, il, ir, ic;
	private char type;
	private double PI=3.1415;
		
	// Construtor
	public Rlc (double vt, double r, double l, double c, double f, char type)
	{
		this.vt = vt;
		this.r = r;
		this.l = l;
		this.c = c;
		this.f = f;
		this.type = type;
	}
	
	// Construtor nulo
	public Rlc ()
	{
	}
	
	/* Mtodos para setar atributos independentemente */
	public void setVoltage (double vt)
	{
		this.vt = vt;
	}
	
	public void setResistor (double r)
	{
		this.r = r;
	}
	
	public void setCapacitor (double c)
	{
		this.c = c;
	}
	
	public void setIndutance (double l)
	{
		this.l = l;
	}
	
	public void setFrequency (double f)
	{
		this.f = f;
	}
	
	public void setNetType (char type) // tipo de rede, paralela ou srie
	{
		this.type = type;
	}
	
	//calcula os valores do circuito
	public void calcValues()
	{
		switch (type)
		{
		case 's':
			xl = 2*PI*f*l;
			xc = 1/(2*PI*f*c);
			z = Math.sqrt(r*r + (xl-xc)*(xl-xc));
			it = vt/z;
			il = it;
			ir = it;
			ic = it;
			vl = it*xl;
			vr = it*r;
			vc = it*xc;
			break;
		case 'p':
			xl = 2*PI*f*l;
			xc = 1/(2*PI*f*c);
			z = 1/Math.sqrt(1/(r*r) + Math.pow((1/xc)-(1/xl), 2));
			it = vt/z;
			vr = vt;
			vl = vt;
			vc = vt;
			il = vl/xl;
			ir = vr/r;
			ic = vc/xc;
			break;
		}
	}
	
	public void printValues()
	{
		System.out.print("\n\nCircuito tipo RLC:  ");
		if (type=='s')
			System.out.println("serie\n\n");
		else
			System.out.println("paralelo\n\n");
		
		System.out.println("Fonte:  "+vt+"  Volt     Frequencia:  "+f+"  Hz");
		System.out.println("Resistor:  "+r+"  Ohm");
		System.out.println("Indutor:  "+l+"  Henry");
		System.out.println("Capacitor:  "+c+"  Farad\n");
		System.out.println("it = "+it+" A");
		System.out.println("xl = "+xl+" Ohm\nvl = "+vl+" V\nil = "+il+" A");
		System.out.println("xc = "+xc+" Ohm\nvc = "+vc+" V\nic = "+ic+" A");
		System.out.println("z  = "+z+" Ohm\nvr = "+vr+" V\nir = "+ir+" A");
	}
}

