/*
 * Decompiled with CFR 0.152.
 */
package symtable;

import ast.node.MethodDecl;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.LinkedList;
import symtable.NamedScopeSTE;
import symtable.STE;
import symtable.Signature;
import symtable.VarSTE;

public class MethodSTE
extends NamedScopeSTE {
    private Signature mSignature;
    private MethodDecl mNode;
    private String mMunged;
    private int mVarNumBytes = 0;

    public MethodSTE(String string, Signature signature, MethodDecl methodDecl, String string2) {
        super(string);
        this.mSignature = signature;
        this.mNode = methodDecl;
        this.mMunged = string2;
    }

    public Signature getSignature() {
        return this.mSignature;
    }

    public MethodDecl getASTNode() {
        return this.mNode;
    }

    public String getMunged() {
        return this.mMunged;
    }

    public LinkedList<VarSTE> getParamList() {
        LinkedList<VarSTE> linkedList = new LinkedList<VarSTE>();
        Iterator<String> iterator = this.mScope.getDeclOrder().iterator();
        while (iterator.hasNext()) {
            STE sTE = this.mScope.lookup(iterator.next());
            if (!(sTE instanceof VarSTE) || !((VarSTE)sTE).isParam()) continue;
            linkedList.add((VarSTE)sTE);
        }
        return linkedList;
    }

    public LinkedList<VarSTE> getLocalList() {
        LinkedList<VarSTE> linkedList = new LinkedList<VarSTE>();
        Iterator<String> iterator = this.mScope.getDeclOrder().iterator();
        while (iterator.hasNext()) {
            STE sTE = this.mScope.lookup(iterator.next());
            if (!(sTE instanceof VarSTE) || !((VarSTE)sTE).isLocal()) continue;
            linkedList.add((VarSTE)sTE);
        }
        return linkedList;
    }

    public void setVarNumBytes(int n) {
        this.mVarNumBytes = n;
    }

    public int getVarNumBytes() {
        return this.mVarNumBytes;
    }

    @Override
    public int outputDot(PrintStream printStream, int n) {
        int n2 = n;
        String string = this.mSignature == null ? "null" : this.mSignature.toString();
        String string2 = "\t" + n2 + " [label=\" <f0> MethodSTE " + "| <f1> mName = " + this.mName + "| <f2> mSignature = " + string + "| <f3> mScope \"];";
        printStream.println(string2);
        printStream.println("\t" + n2 + ":<f3> -> " + ++n + ":<f0>;");
        return this.mScope.outputDot(printStream, n);
    }
}

