/*
 * Decompiled with CFR 0.152.
 */
package ast.node;

import ast.node.IExp;
import ast.node.Node;
import ast.node.Token;
import ast.visitor.Visitor;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

public final class CallExp
extends IExp {
    private IExp _exp_;
    private Token _id_;
    private final LinkedList<IExp> _args_ = new LinkedList();

    public CallExp() {
    }

    public CallExp(IExp iExp, Token token, List<IExp> list) {
        this.setExp(iExp);
        this.setId(token);
        this.setArgs(list);
    }

    @Override
    public Object clone() {
        return new CallExp(this.cloneNode(this._exp_), this.cloneNode(this._id_), this.cloneList(this._args_));
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visitCallExp(this);
    }

    public IExp getExp() {
        return this._exp_;
    }

    public void setExp(IExp iExp) {
        if (this._exp_ != null) {
            this._exp_.parent(null);
        }
        if (iExp != null) {
            if (iExp.parent() != null) {
                iExp.parent().removeChild(iExp);
            }
            iExp.parent(this);
        }
        this._exp_ = iExp;
    }

    public Token getId() {
        return this._id_;
    }

    public void setId(Token token) {
        if (this._id_ != null) {
            this._id_.parent(null);
        }
        if (token != null) {
            if (token.parent() != null) {
                token.parent().removeChild(token);
            }
            token.parent(this);
        }
        this._id_ = token;
    }

    public LinkedList<IExp> getArgs() {
        return this._args_;
    }

    public void setArgs(List<IExp> list) {
        this._args_.clear();
        this._args_.addAll(list);
        for (IExp iExp : list) {
            if (iExp.parent() != null) {
                iExp.parent().removeChild(iExp);
            }
            iExp.parent(this);
        }
    }

    @Override
    void removeChild(Node node) {
        if (this._exp_ == node) {
            this._exp_ = null;
            return;
        }
        if (this._id_ == node) {
            this._id_ = null;
            return;
        }
        if (this._args_.remove(node)) {
            return;
        }
        throw new RuntimeException("Not a child.");
    }

    @Override
    void replaceChild(Node node, Node node2) {
        if (this._exp_ == node) {
            this.setExp((IExp)node2);
            return;
        }
        if (this._id_ == node) {
            this.setId((Token)node2);
            return;
        }
        ListIterator<IExp> listIterator = this._args_.listIterator();
        while (listIterator.hasNext()) {
            if (listIterator.next() != node) continue;
            if (node2 != null) {
                listIterator.set((IExp)node2);
                node2.parent(this);
                node.parent(null);
                return;
            }
            listIterator.remove();
            node.parent(null);
            return;
        }
        throw new RuntimeException("Not a child.");
    }
}

