/*
 * Decompiled with CFR 0.152.
 */
package ast.node;

import ast.node.IStatement;
import ast.node.Node;
import ast.visitor.Visitor;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

public final class BlockStatement
extends IStatement {
    private final LinkedList<IStatement> _statements_ = new LinkedList();

    public BlockStatement() {
    }

    public BlockStatement(List<IStatement> list) {
        this.setStatements(list);
    }

    @Override
    public Object clone() {
        return new BlockStatement(this.cloneList(this._statements_));
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visitBlockStatement(this);
    }

    public LinkedList<IStatement> getStatements() {
        return this._statements_;
    }

    public void setStatements(List<IStatement> list) {
        this._statements_.clear();
        this._statements_.addAll(list);
        for (IStatement iStatement : list) {
            if (iStatement.parent() != null) {
                iStatement.parent().removeChild(iStatement);
            }
            iStatement.parent(this);
        }
    }

    @Override
    void removeChild(Node node) {
        if (this._statements_.remove(node)) {
            return;
        }
        throw new RuntimeException("Not a child.");
    }

    @Override
    void replaceChild(Node node, Node node2) {
        ListIterator<IStatement> listIterator = this._statements_.listIterator();
        while (listIterator.hasNext()) {
            if (listIterator.next() != node) continue;
            if (node2 != null) {
                listIterator.set((IStatement)node2);
                node2.parent(this);
                node.parent(null);
                return;
            }
            listIterator.remove();
            node.parent(null);
            return;
        }
        throw new RuntimeException("Not a child.");
    }
}

