/*
 * Decompiled with CFR 0.152.
 */
package ast_visitors;

import ast.node.Node;
import ast.node.Token;
import ast.visitor.DepthFirstVisitor;
import java.io.PrintWriter;
import java.util.Stack;

public class DotVisitor
extends DepthFirstVisitor {
    private int nodeCount = 0;
    private PrintWriter out;
    private Stack<Integer> nodeStack;

    public DotVisitor(PrintWriter printWriter) {
        this.out = printWriter;
        this.nodeStack = new Stack();
    }

    @Override
    public void defaultIn(Node node) {
        if (this.nodeStack.empty()) {
            this.out.println("digraph ASTGraph {");
        }
        this.nodeDotOutput(node);
        this.nodeStack.push(this.nodeCount - 1);
    }

    @Override
    public void defaultOut(Node node) {
        this.nodeStack.pop();
        if (this.nodeStack.empty()) {
            this.out.println("}");
        }
        this.out.flush();
    }

    private void nodeDotOutput(Node node) {
        this.out.print(this.nodeCount);
        this.out.print(" [ label=\"");
        this.printNodeName(node);
        if (node instanceof Token) {
            this.out.print("\\n");
            this.out.print(((Token)node).getText());
        }
        this.out.println("\" ];");
        if (!this.nodeStack.empty()) {
            this.out.print(this.nodeStack.peek());
            this.out.print(" -> ");
            this.out.println(this.nodeCount);
        }
        ++this.nodeCount;
    }

    private void printNodeName(Node node) {
        String string = node.getClass().getName();
        String string2 = string.substring(string.lastIndexOf(46) + 1);
        this.out.print(string2);
    }
}

