/*
 * Decompiled with CFR 0.152.
 */
package ast_visitors;

import ast.node.Node;
import ast.node.Token;
import ast.visitor.DepthFirstVisitor;
import java.io.PrintWriter;
import java.util.Stack;
import lines.Lines;

public class DotLinesVisitor
extends DepthFirstVisitor {
    private int nodeCount = 0;
    private PrintWriter out;
    private Stack<Integer> nodeStack;
    private Lines mLines;

    public DotLinesVisitor(PrintWriter printWriter, Lines lines) {
        this.out = printWriter;
        this.nodeStack = new Stack();
        this.mLines = lines;
    }

    public void defaultCase(Node node) {
        this.nodeDotOutput(node);
    }

    @Override
    public void defaultIn(Node node) {
        if (this.nodeStack.empty()) {
            this.out.println("digraph ParseGraph {");
        }
        this.nodeDotOutput(node);
        this.nodeStack.push(this.nodeCount - 1);
    }

    @Override
    public void defaultOut(Node node) {
        this.nodeStack.pop();
        if (this.nodeStack.empty()) {
            this.out.println("}");
        }
        this.out.flush();
    }

    private void nodeDotOutput(Node node) {
        this.out.print(this.nodeCount);
        this.out.print(" [ label=\"");
        this.printNodeName(node);
        if (node instanceof Token) {
            this.out.print("\\n");
            this.out.print(((Token)node).getText());
        }
        this.out.print("\\nline = ");
        this.out.print(this.mLines.getLine(node));
        this.out.print("\\npos = ");
        this.out.print(this.mLines.getPos(node));
        this.out.println("\" ];");
        if (!this.nodeStack.empty()) {
            this.out.print(this.nodeStack.peek());
            this.out.print(" -> ");
            this.out.println(this.nodeCount);
        }
        ++this.nodeCount;
    }

    private void printNodeName(Node node) {
        String string = node.getClass().getName();
        String string2 = string.substring(string.lastIndexOf(46) + 1);
        this.out.print(string2);
    }
}

