/*
 * Decompiled with CFR 0.152.
 */
package ast_visitors;

import ast.node.AndExp;
import ast.node.ArrayAssignStatement;
import ast.node.ArrayExp;
import ast.node.AssignStatement;
import ast.node.BlockStatement;
import ast.node.BoolType;
import ast.node.ButtonExp;
import ast.node.ByteCast;
import ast.node.ByteType;
import ast.node.CallExp;
import ast.node.CallStatement;
import ast.node.ChildClassDecl;
import ast.node.ClassType;
import ast.node.ColorArrayType;
import ast.node.ColorExp;
import ast.node.ColorType;
import ast.node.EqualExp;
import ast.node.FalseExp;
import ast.node.Formal;
import ast.node.IExp;
import ast.node.IdExp;
import ast.node.IfStatement;
import ast.node.IntArrayType;
import ast.node.IntType;
import ast.node.IntegerExp;
import ast.node.LengthExp;
import ast.node.LtExp;
import ast.node.MainClass;
import ast.node.MeggyCheckButton;
import ast.node.MeggyDelay;
import ast.node.MeggyGetPixel;
import ast.node.MeggySetAuxLEDs;
import ast.node.MeggySetPixel;
import ast.node.MeggyToneStart;
import ast.node.MethodDecl;
import ast.node.MinusExp;
import ast.node.MulExp;
import ast.node.NewArrayExp;
import ast.node.NewExp;
import ast.node.Node;
import ast.node.NotExp;
import ast.node.PlusExp;
import ast.node.Program;
import ast.node.ThisExp;
import ast.node.Token;
import ast.node.ToneExp;
import ast.node.ToneType;
import ast.node.TopClassDecl;
import ast.node.TrueExp;
import ast.node.VarDecl;
import ast.node.VoidExp;
import ast.node.VoidType;
import ast.node.WhileStatement;
import ast.visitor.DepthFirstVisitor;
import exceptions.InternalException;
import exceptions.SemanticException;
import java.util.LinkedList;
import lines.Lines;
import symtable.ClassSTE;
import symtable.MethodSTE;
import symtable.STE;
import symtable.Signature;
import symtable.SymTable;
import symtable.Type;
import symtable.VarSTE;

public class CheckTypes
extends DepthFirstVisitor {
    private SymTable mCurrentST;
    private final Lines mLines;
    private ClassSTE mCurrentClass;

    public CheckTypes(SymTable symTable, Lines lines) {
        if (symTable == null || lines == null) {
            throw new InternalException("unexpected null argument");
        }
        this.mCurrentST = symTable;
        this.mLines = lines;
    }

    @Override
    public void defaultOut(Node node) {
        System.err.println("Node not implemented in CheckTypes, " + node.getClass());
    }

    @Override
    public void outAndExp(AndExp andExp) {
        if (this.mCurrentST.getExpType(andExp.getLExp()) != Type.BOOL) {
            throw new SemanticException("Invalid left operand type for operator &&", this.mLines.getLine(andExp.getLExp()), this.mLines.getPos(andExp.getLExp()));
        }
        if (this.mCurrentST.getExpType(andExp.getRExp()) != Type.BOOL) {
            throw new SemanticException("Invalid right operand type for operator &&", this.mLines.getLine(andExp.getRExp()), this.mLines.getPos(andExp.getRExp()));
        }
        this.mCurrentST.setExpType(andExp, Type.BOOL);
    }

    @Override
    public void outArrayAssignStatement(ArrayAssignStatement arrayAssignStatement) {
        STE sTE = this.mCurrentST.lookup(((IdExp)arrayAssignStatement.getRef()).getId().getText());
        this.mCurrentST.setNodeSTE(((IdExp)arrayAssignStatement.getRef()).getId(), sTE);
        if (sTE == null || !(sTE instanceof VarSTE)) {
            throw new SemanticException("Undeclared variable " + ((IdExp)arrayAssignStatement.getRef()).getId().getText(), ((IdExp)arrayAssignStatement.getRef()).getId().getLine(), ((IdExp)arrayAssignStatement.getRef()).getId().getPos());
        }
        VarSTE varSTE = (VarSTE)sTE;
        Type type = this.mCurrentST.getExpType(arrayAssignStatement.getExp());
        if (varSTE.getType() != Type.COLOR_ARRAY && varSTE.getType() != Type.INT_ARRAY) {
            throw new SemanticException("Array reference to non-array type", this.mLines.getLine(arrayAssignStatement.getExp()), this.mLines.getPos(arrayAssignStatement.getExp()));
        }
        if (this.mCurrentST.getExpType(arrayAssignStatement.getIndex()) != Type.BYTE) {
            throw new SemanticException("Index expression type for array reference must be BYTE", this.mLines.getLine(arrayAssignStatement.getIndex()), this.mLines.getPos(arrayAssignStatement.getIndex()));
        }
        if (varSTE.getType() == Type.INT_ARRAY && type != Type.INT || varSTE.getType() == Type.COLOR_ARRAY && type != Type.COLOR) {
            throw new SemanticException("Invalid expression type assigned to variable " + ((IdExp)arrayAssignStatement.getRef()).getId().getText(), this.mLines.getLine(arrayAssignStatement.getExp()), this.mLines.getPos(arrayAssignStatement.getExp()));
        }
    }

    @Override
    public void outArrayExp(ArrayExp arrayExp) {
        if (this.mCurrentST.getExpType(arrayExp.getExp()) != Type.COLOR_ARRAY && this.mCurrentST.getExpType(arrayExp.getExp()) != Type.INT_ARRAY) {
            throw new SemanticException("Array reference to non-array type", this.mLines.getLine(arrayExp.getExp()), this.mLines.getPos(arrayExp.getExp()));
        }
        if (this.mCurrentST.getExpType(arrayExp.getIndex()) != Type.BYTE) {
            throw new SemanticException("Index expression type for array reference must be BYTE", this.mLines.getLine(arrayExp.getIndex()), this.mLines.getPos(arrayExp.getIndex()));
        }
        if (this.mCurrentST.getExpType(arrayExp.getExp()) == Type.COLOR_ARRAY) {
            this.mCurrentST.setExpType(arrayExp, Type.COLOR);
        } else {
            this.mCurrentST.setExpType(arrayExp, Type.INT);
        }
    }

    @Override
    public void outAssignStatement(AssignStatement assignStatement) {
        Type type;
        STE sTE = this.mCurrentST.lookup(assignStatement.getId().getText());
        this.mCurrentST.setNodeSTE(assignStatement.getId(), sTE);
        if (sTE == null || !(sTE instanceof VarSTE)) {
            throw new SemanticException("Undeclared variable " + assignStatement.getId().getText(), assignStatement.getId().getLine(), assignStatement.getId().getPos());
        }
        VarSTE varSTE = (VarSTE)sTE;
        Type type2 = varSTE.getType();
        if (type2 != (type = this.mCurrentST.getExpType(assignStatement.getExp()))) {
            throw new SemanticException("Invalid expression type assigned to variable " + assignStatement.getId().getText(), this.mLines.getLine(assignStatement.getExp()), this.mLines.getPos(assignStatement.getExp()));
        }
    }

    @Override
    public void outBlockStatement(BlockStatement blockStatement) {
    }

    @Override
    public void outBoolType(BoolType boolType) {
    }

    @Override
    public void outButtonExp(ButtonExp buttonExp) {
        this.mCurrentST.setExpType(buttonExp, Type.BUTTON);
    }

    @Override
    public void outByteCast(ByteCast byteCast) {
        Type type = this.mCurrentST.getExpType(byteCast.getExp());
        if (type == null || type != Type.INT && type != Type.BYTE) {
            throw new SemanticException("Can only cast a byte or int into a byte type, " + type, this.mLines.getLine(byteCast.getExp()), this.mLines.getPos(byteCast.getExp()));
        }
        this.mCurrentST.setExpType(byteCast, Type.BYTE);
    }

    @Override
    public void outByteType(ByteType byteType) {
    }

    private Type typeCheckCall(IExp iExp, Token token, LinkedList<IExp> linkedList) {
        Type type = this.mCurrentST.getExpType(iExp);
        if (type == null || !type.isReference()) {
            throw new SemanticException("Receiver of method call must be a class type", token.getLine(), token.getPos());
        }
        ClassSTE classSTE = this.mCurrentST.lookupClass(type.getClassName());
        MethodSTE methodSTE = (MethodSTE)classSTE.getScope().lookup(token.getText());
        this.mCurrentST.setNodeSTE(token, methodSTE);
        if (methodSTE == null) {
            throw new SemanticException("Method " + token.getText() + " does not exist in class type " + classSTE.getName(), token.getLine(), token.getPos());
        }
        Signature signature = methodSTE.getSignature();
        int n = linkedList.size();
        if (n != signature.formalCount()) {
            throw new SemanticException("Method " + token.getText() + " requires exactly " + signature.formalCount() + " arguments", token.getLine(), token.getPos());
        }
        IExp[] iExpArray = new IExp[n];
        iExpArray = linkedList.toArray(iExpArray);
        for (int i = 0; i < iExpArray.length; ++i) {
            Type type2 = this.mCurrentST.getExpType(iExpArray[i]);
            Type type3 = signature.formalType(i);
            if (type3 == type2) continue;
            throw new SemanticException("Invalid argument type for method " + token.getText(), this.mLines.getLine(iExpArray[i]), this.mLines.getPos(iExpArray[i]));
        }
        return signature.getReturnType();
    }

    @Override
    public void outCallExp(CallExp callExp) {
        Type type = this.typeCheckCall(callExp.getExp(), callExp.getId(), callExp.getArgs());
        this.mCurrentST.setExpType(callExp, type);
    }

    @Override
    public void outCallStatement(CallStatement callStatement) {
        this.typeCheckCall(callStatement.getExp(), callStatement.getId(), callStatement.getArgs());
    }

    @Override
    public void inChildClassDecl(ChildClassDecl childClassDecl) {
        this.mCurrentClass = (ClassSTE)this.mCurrentST.lookup(childClassDecl.getName().getText());
        this.mCurrentST.setNodeSTE(childClassDecl.getName(), this.mCurrentClass);
        this.mCurrentST.pushScope(childClassDecl.getName().getText());
    }

    @Override
    public void outChildClassDecl(ChildClassDecl childClassDecl) {
        if (this.mCurrentST.lookup(childClassDecl.getParent().getText()) == null) {
            throw new SemanticException("Class " + childClassDecl.getName().getText() + " does not exist", childClassDecl.getName().getLine(), childClassDecl.getName().getPos());
        }
        this.mCurrentST.popScope();
    }

    @Override
    public void outClassType(ClassType classType) {
    }

    @Override
    public void outColorExp(ColorExp colorExp) {
        this.mCurrentST.setExpType(colorExp, Type.COLOR);
    }

    @Override
    public void outColorArrayType(ColorArrayType colorArrayType) {
    }

    @Override
    public void outColorType(ColorType colorType) {
    }

    @Override
    public void outEqualExp(EqualExp equalExp) {
        Type type;
        Type type2 = this.mCurrentST.getExpType(equalExp.getLExp());
        if (type2 != (type = this.mCurrentST.getExpType(equalExp.getRExp()))) {
            throw new SemanticException("Operands to == operator must be of same type", this.mLines.getLine(equalExp.getLExp()), this.mLines.getPos(equalExp.getLExp()));
        }
        this.mCurrentST.setExpType(equalExp, Type.BOOL);
    }

    @Override
    public void outFormal(Formal formal) {
    }

    @Override
    public void outFalseExp(FalseExp falseExp) {
        this.mCurrentST.setExpType(falseExp, Type.BOOL);
    }

    @Override
    public void outIdExp(IdExp idExp) {
        STE sTE = this.mCurrentST.lookup(idExp.getId().getText());
        this.mCurrentST.setNodeSTE(idExp.getId(), sTE);
        if (sTE == null) {
            throw new SemanticException("Undeclared variable " + idExp.getId().getText(), idExp.getId().getLine(), idExp.getId().getPos());
        }
        if (sTE instanceof VarSTE) {
            VarSTE varSTE = (VarSTE)sTE;
            this.mCurrentST.setExpType(idExp, varSTE.getType());
        }
    }

    @Override
    public void outIfStatement(IfStatement ifStatement) {
        if (this.mCurrentST.getExpType(ifStatement.getExp()) != Type.BOOL) {
            throw new SemanticException("Invalid condition type for if statement", this.mLines.getLine(ifStatement.getExp()), this.mLines.getPos(ifStatement.getExp()));
        }
    }

    @Override
    public void outIntArrayType(IntArrayType intArrayType) {
    }

    @Override
    public void outIntType(IntType intType) {
    }

    @Override
    public void outIntegerExp(IntegerExp integerExp) {
        this.mCurrentST.setExpType(integerExp, Type.INT);
    }

    @Override
    public void outLengthExp(LengthExp lengthExp) {
        if (this.mCurrentST.getExpType(lengthExp.getExp()) != Type.COLOR_ARRAY && this.mCurrentST.getExpType(lengthExp.getExp()) != Type.INT_ARRAY) {
            throw new SemanticException("Operator length called on non-array type", this.mLines.getLine(lengthExp.getExp()), this.mLines.getPos(lengthExp.getExp()));
        }
        this.mCurrentST.setExpType(lengthExp, Type.INT);
    }

    @Override
    public void outLtExp(LtExp ltExp) {
        Type type;
        Type type2 = this.mCurrentST.getExpType(ltExp.getLExp());
        if (type2 != (type = this.mCurrentST.getExpType(ltExp.getRExp()))) {
            throw new SemanticException("Operands to < operator must be of same type", this.mLines.getLine(ltExp.getLExp()), this.mLines.getPos(ltExp.getLExp()));
        }
        if (type2 != Type.INT && type2 != Type.BYTE) {
            throw new SemanticException("Operands to < operator must be INT or BOOL", this.mLines.getLine(ltExp.getLExp()), this.mLines.getPos(ltExp.getLExp()));
        }
        this.mCurrentST.setExpType(ltExp, Type.BOOL);
    }

    @Override
    public void outMainClass(MainClass mainClass) {
    }

    @Override
    public void outMeggyCheckButton(MeggyCheckButton meggyCheckButton) {
        if (this.mCurrentST.getExpType(meggyCheckButton.getExp()) != Type.BUTTON) {
            throw new SemanticException("Invalid argument type for method MeggyCheckButton", this.mLines.getLine(meggyCheckButton.getExp()), this.mLines.getPos(meggyCheckButton.getExp()));
        }
        this.mCurrentST.setExpType(meggyCheckButton, Type.BOOL);
    }

    @Override
    public void outMeggyDelay(MeggyDelay meggyDelay) {
        if (this.mCurrentST.getExpType(meggyDelay.getExp()) != Type.INT) {
            throw new SemanticException("Invalid argument type for method MeggyDelay", this.mLines.getLine(meggyDelay.getExp()), this.mLines.getPos(meggyDelay.getExp()));
        }
    }

    @Override
    public void outMeggyGetPixel(MeggyGetPixel meggyGetPixel) {
        if (this.mCurrentST.getExpType(meggyGetPixel.getXExp()) != Type.BYTE) {
            throw new SemanticException("Invalid argument type for method MeggyGetPixel", this.mLines.getLine(meggyGetPixel.getXExp()), this.mLines.getPos(meggyGetPixel.getXExp()));
        }
        if (this.mCurrentST.getExpType(meggyGetPixel.getYExp()) != Type.BYTE) {
            throw new SemanticException("Invalid argument type for method MeggyGetPixel", this.mLines.getLine(meggyGetPixel.getYExp()), this.mLines.getPos(meggyGetPixel.getYExp()));
        }
        this.mCurrentST.setExpType(meggyGetPixel, Type.COLOR);
    }

    @Override
    public void outMeggySetAuxLEDs(MeggySetAuxLEDs meggySetAuxLEDs) {
        if (this.mCurrentST.getExpType(meggySetAuxLEDs.getExp()) != Type.INT) {
            throw new SemanticException("Invalid argument type for method MeggySetAuxLEDs", this.mLines.getLine(meggySetAuxLEDs.getExp()), this.mLines.getPos(meggySetAuxLEDs.getExp()));
        }
    }

    @Override
    public void outMeggySetPixel(MeggySetPixel meggySetPixel) {
        if (this.mCurrentST.getExpType(meggySetPixel.getXExp()) != Type.BYTE) {
            throw new SemanticException("Invalid argument type for method MeggySetPixel", this.mLines.getLine(meggySetPixel.getXExp()), this.mLines.getPos(meggySetPixel.getXExp()));
        }
        if (this.mCurrentST.getExpType(meggySetPixel.getYExp()) != Type.BYTE) {
            throw new SemanticException("Invalid argument type for method MeggySetPixel", this.mLines.getLine(meggySetPixel.getYExp()), this.mLines.getPos(meggySetPixel.getYExp()));
        }
        if (this.mCurrentST.getExpType(meggySetPixel.getColor()) != Type.COLOR) {
            throw new SemanticException("Invalid argument type for method MeggySetPixel", this.mLines.getLine(meggySetPixel.getColor()), this.mLines.getPos(meggySetPixel.getColor()));
        }
    }

    @Override
    public void outMeggyToneStart(MeggyToneStart meggyToneStart) {
        if (this.mCurrentST.getExpType(meggyToneStart.getDurationExp()) != Type.INT) {
            throw new SemanticException("Invalid argument type for method MeggyToneStart", this.mLines.getLine(meggyToneStart.getDurationExp()), this.mLines.getPos(meggyToneStart.getDurationExp()));
        }
        if (this.mCurrentST.getExpType(meggyToneStart.getToneExp()) != Type.TONE) {
            throw new SemanticException("Invalid argument type for method MeggyToneStart", this.mLines.getLine(meggyToneStart.getToneExp()), this.mLines.getPos(meggyToneStart.getToneExp()));
        }
    }

    @Override
    public void inMethodDecl(MethodDecl methodDecl) {
        this.mCurrentST.pushScope(methodDecl.getName().getText());
    }

    @Override
    public void outMethodDecl(MethodDecl methodDecl) {
        this.mCurrentST.popScope();
        MethodSTE methodSTE = (MethodSTE)this.mCurrentST.lookup(methodDecl.getName().getText());
        this.mCurrentST.setNodeSTE(methodDecl.getName(), methodSTE);
        Type type = methodSTE.getSignature().getReturnType();
        Type type2 = this.mCurrentST.getExpType(methodDecl.getExp());
        if (type != type2) {
            throw new SemanticException("Invalid type returned from method " + methodDecl.getName().getText(), this.mLines.getLine(methodDecl.getExp()), this.mLines.getPos(methodDecl.getExp()));
        }
    }

    @Override
    public void outMinusExp(MinusExp minusExp) {
        Type type;
        Type type2 = this.mCurrentST.getExpType(minusExp.getLExp());
        if (type2 != (type = this.mCurrentST.getExpType(minusExp.getRExp()))) {
            throw new SemanticException("Operands to - operator must be of same type", this.mLines.getLine(minusExp.getLExp()), this.mLines.getPos(minusExp.getLExp()));
        }
        if (type2 != Type.INT && type2 != Type.BYTE) {
            throw new SemanticException("Operands to - operator must be INT or BYTE", this.mLines.getLine(minusExp.getLExp()), this.mLines.getPos(minusExp.getLExp()));
        }
        this.mCurrentST.setExpType(minusExp, Type.INT);
    }

    @Override
    public void outMulExp(MulExp mulExp) {
        if (this.mCurrentST.getExpType(mulExp.getLExp()) != Type.BYTE) {
            throw new SemanticException("Invalid left operand type for operator *", this.mLines.getLine(mulExp.getLExp()), this.mLines.getPos(mulExp.getLExp()));
        }
        if (this.mCurrentST.getExpType(mulExp.getRExp()) != Type.BYTE) {
            throw new SemanticException("Invalid right operand type for operator *", this.mLines.getLine(mulExp.getRExp()), this.mLines.getPos(mulExp.getRExp()));
        }
        this.mCurrentST.setExpType(mulExp, Type.INT);
    }

    @Override
    public void outNewArrayExp(NewArrayExp newArrayExp) {
        if (this.mCurrentST.getExpType(newArrayExp.getExp()) != Type.BYTE) {
            throw new SemanticException("Invalid operand type for new array operator", this.mLines.getLine(newArrayExp.getExp()), this.mLines.getPos(newArrayExp.getExp()));
        }
        if (newArrayExp.getType() instanceof ColorType) {
            this.mCurrentST.setExpType(newArrayExp, Type.COLOR_ARRAY);
        } else if (newArrayExp.getType() instanceof IntType) {
            this.mCurrentST.setExpType(newArrayExp, Type.INT_ARRAY);
        } else {
            throw new SemanticException("Invalid array type for new array operator", this.mLines.getLine(newArrayExp.getExp()), this.mLines.getPos(newArrayExp.getExp()));
        }
    }

    @Override
    public void outNewExp(NewExp newExp) {
        STE sTE = this.mCurrentST.lookup(newExp.getId().getText());
        this.mCurrentST.setNodeSTE(newExp.getId(), sTE);
        if (sTE == null) {
            throw new SemanticException("Undeclared class type in new operator", newExp.getId().getLine(), newExp.getId().getPos());
        }
        this.mCurrentST.setExpType(newExp, Type.getClassType(newExp.getId().getText()));
    }

    @Override
    public void outNotExp(NotExp notExp) {
        if (this.mCurrentST.getExpType(notExp.getExp()) != Type.BOOL) {
            throw new SemanticException("Invalid operand type for operator !", this.mLines.getLine(notExp.getExp()), this.mLines.getPos(notExp.getExp()));
        }
        this.mCurrentST.setExpType(notExp, Type.BOOL);
    }

    @Override
    public void outProgram(Program program) {
    }

    @Override
    public void outPlusExp(PlusExp plusExp) {
        Type type;
        Type type2 = this.mCurrentST.getExpType(plusExp.getLExp());
        if (type2 != (type = this.mCurrentST.getExpType(plusExp.getRExp()))) {
            throw new SemanticException("Operands to + operator must be of same type", this.mLines.getLine(plusExp.getLExp()), this.mLines.getPos(plusExp.getLExp()));
        }
        if (type2 != Type.INT && type2 != Type.BYTE) {
            throw new SemanticException("Operands to + operator must be INT or BYTE", this.mLines.getLine(plusExp.getLExp()), this.mLines.getPos(plusExp.getLExp()));
        }
        this.mCurrentST.setExpType(plusExp, Type.INT);
    }

    @Override
    public void outThisExp(ThisExp thisExp) {
        if (this.mCurrentClass == null) {
            throw new InternalException("outThisExp: mCurrentClass==null");
        }
        VarSTE varSTE = (VarSTE)this.mCurrentST.lookup("this");
        this.mCurrentST.setNodeSTE(thisExp, varSTE);
        this.mCurrentST.setExpType(thisExp, Type.getClassType(this.mCurrentClass.getName()));
    }

    @Override
    public void outToken(Token token) {
    }

    @Override
    public void outToneExp(ToneExp toneExp) {
        this.mCurrentST.setExpType(toneExp, Type.TONE);
    }

    @Override
    public void outToneType(ToneType toneType) {
    }

    @Override
    public void inTopClassDecl(TopClassDecl topClassDecl) {
        this.mCurrentClass = (ClassSTE)this.mCurrentST.lookup(topClassDecl.getName().getText());
        this.mCurrentST.setNodeSTE(topClassDecl.getName(), this.mCurrentClass);
        this.mCurrentST.pushScope(topClassDecl.getName().getText());
    }

    @Override
    public void outTopClassDecl(TopClassDecl topClassDecl) {
        this.mCurrentST.popScope();
    }

    @Override
    public void outTrueExp(TrueExp trueExp) {
        this.mCurrentST.setExpType(trueExp, Type.BOOL);
    }

    @Override
    public void outVarDecl(VarDecl varDecl) {
        ClassSTE classSTE;
        VarSTE varSTE = (VarSTE)this.mCurrentST.lookup(varDecl.getName().getText());
        this.mCurrentST.setNodeSTE(varDecl.getName(), varSTE);
        if (varSTE.getType() == Type.VOID) {
            throw new SemanticException("Cannot declare a variable as type void", varDecl.getName().getLine(), varDecl.getName().getPos());
        }
        if (varSTE.getType().isReference() && (classSTE = (ClassSTE)this.mCurrentST.lookup(varSTE.getType().getClassName())) == null) {
            throw new SemanticException("Class " + varSTE.getType().getClassName() + " does not exist", varDecl.getName().getLine(), varDecl.getName().getPos());
        }
    }

    @Override
    public void outVoidExp(VoidExp voidExp) {
        this.mCurrentST.setExpType(voidExp, Type.VOID);
    }

    @Override
    public void outVoidType(VoidType voidType) {
    }

    @Override
    public void outWhileStatement(WhileStatement whileStatement) {
        if (this.mCurrentST.getExpType(whileStatement.getExp()) != Type.BOOL) {
            throw new SemanticException("Invalid condition type for while statement", this.mLines.getLine(whileStatement.getExp()), this.mLines.getPos(whileStatement.getExp()));
        }
    }
}

