/*
 * Decompiled with CFR 0.152.
 */
package ast.node;

import ast.node.Formal;
import ast.node.IExp;
import ast.node.IStatement;
import ast.node.IType;
import ast.node.Node;
import ast.node.Token;
import ast.node.VarDecl;
import ast.visitor.Visitor;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

public final class MethodDecl
extends Node {
    private IType _type_;
    private Token _name_;
    private final LinkedList<Formal> _formals_ = new LinkedList();
    private final LinkedList<VarDecl> _varDecls_ = new LinkedList();
    private final LinkedList<IStatement> _statements_ = new LinkedList();
    private IExp _exp_;

    public MethodDecl() {
    }

    public MethodDecl(IType iType, Token token, List<Formal> list, List<VarDecl> list2, List<IStatement> list3, IExp iExp) {
        this.setType(iType);
        this.setName(token);
        this.setFormals(list);
        this.setVarDecls(list2);
        this.setStatements(list3);
        this.setExp(iExp);
    }

    public MethodDecl(IType iType, Token token, List<Formal> list, List<VarDecl> list2, List<IStatement> list3) {
        this.setType(iType);
        this.setName(token);
        this.setFormals(list);
        this.setVarDecls(list2);
        this.setStatements(list3);
        this.setExp(null);
    }

    @Override
    public Object clone() {
        if (this._exp_ != null) {
            return new MethodDecl(this.cloneNode(this._type_), this.cloneNode(this._name_), this.cloneList(this._formals_), this.cloneList(this._varDecls_), this.cloneList(this._statements_), this.cloneNode(this._exp_));
        }
        return new MethodDecl(this.cloneNode(this._type_), this.cloneNode(this._name_), this.cloneList(this._formals_), this.cloneList(this._varDecls_), this.cloneList(this._statements_));
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visitMethodDecl(this);
    }

    public IType getType() {
        return this._type_;
    }

    public void setType(IType iType) {
        if (this._type_ != null) {
            this._type_.parent(null);
        }
        if (iType != null) {
            if (iType.parent() != null) {
                iType.parent().removeChild(iType);
            }
            iType.parent(this);
        }
        this._type_ = iType;
    }

    public Token getName() {
        return this._name_;
    }

    public void setName(Token token) {
        if (this._name_ != null) {
            this._name_.parent(null);
        }
        if (token != null) {
            if (token.parent() != null) {
                token.parent().removeChild(token);
            }
            token.parent(this);
        }
        this._name_ = token;
    }

    public LinkedList<Formal> getFormals() {
        return this._formals_;
    }

    public void setFormals(List<Formal> list) {
        this._formals_.clear();
        this._formals_.addAll(list);
        for (Formal formal : list) {
            if (formal.parent() != null) {
                formal.parent().removeChild(formal);
            }
            formal.parent(this);
        }
    }

    public LinkedList<VarDecl> getVarDecls() {
        return this._varDecls_;
    }

    public void setVarDecls(List<VarDecl> list) {
        this._varDecls_.clear();
        this._varDecls_.addAll(list);
        for (VarDecl varDecl : list) {
            if (varDecl.parent() != null) {
                varDecl.parent().removeChild(varDecl);
            }
            varDecl.parent(this);
        }
    }

    public LinkedList<IStatement> getStatements() {
        return this._statements_;
    }

    public void setStatements(List<IStatement> list) {
        this._statements_.clear();
        this._statements_.addAll(list);
        for (IStatement iStatement : list) {
            if (iStatement.parent() != null) {
                iStatement.parent().removeChild(iStatement);
            }
            iStatement.parent(this);
        }
    }

    public IExp getExp() {
        return this._exp_;
    }

    public void setExp(IExp iExp) {
        if (this._exp_ != null) {
            this._exp_.parent(null);
        }
        if (iExp != null) {
            if (iExp.parent() != null) {
                iExp.parent().removeChild(iExp);
            }
            iExp.parent(this);
        }
        this._exp_ = iExp;
    }

    @Override
    void removeChild(Node node) {
        if (this._type_ == node) {
            this._type_ = null;
            return;
        }
        if (this._name_ == node) {
            this._name_ = null;
            return;
        }
        if (this._formals_.remove(node)) {
            return;
        }
        if (this._varDecls_.remove(node)) {
            return;
        }
        if (this._statements_.remove(node)) {
            return;
        }
        if (this._exp_ == node) {
            this._exp_ = null;
            return;
        }
        throw new RuntimeException("Not a child.");
    }

    @Override
    void replaceChild(Node node, Node node2) {
        if (this._type_ == node) {
            this.setType((IType)node2);
            return;
        }
        if (this._name_ == node) {
            this.setName((Token)node2);
            return;
        }
        ListIterator<Node> listIterator = this._formals_.listIterator();
        while (listIterator.hasNext()) {
            if (listIterator.next() != node) continue;
            if (node2 != null) {
                listIterator.set((Formal)node2);
                node2.parent(this);
                node.parent(null);
                return;
            }
            listIterator.remove();
            node.parent(null);
            return;
        }
        listIterator = this._varDecls_.listIterator();
        while (listIterator.hasNext()) {
            if (listIterator.next() != node) continue;
            if (node2 != null) {
                listIterator.set((VarDecl)node2);
                node2.parent(this);
                node.parent(null);
                return;
            }
            listIterator.remove();
            node.parent(null);
            return;
        }
        listIterator = this._statements_.listIterator();
        while (listIterator.hasNext()) {
            if (listIterator.next() != node) continue;
            if (node2 != null) {
                listIterator.set((IStatement)node2);
                node2.parent(this);
                node.parent(null);
                return;
            }
            listIterator.remove();
            node.parent(null);
            return;
        }
        if (this._exp_ == node) {
            this.setExp((IExp)node2);
            return;
        }
        throw new RuntimeException("Not a child.");
    }
}

