/*
 * Decompiled with CFR 0.152.
 */
package symtable;

import java.io.PrintStream;
import symtable.STE;
import symtable.Scope;
import symtable.Type;

public class ValueSTE
extends STE {
    private int mIntValue;
    private boolean mBoolValue;
    private Scope mObjValue;
    private int[] mArrayValue;
    private Type mType;

    public ValueSTE(String string, int n) {
        this.mName = string;
        this.mType = Type.INT;
        this.mIntValue = n;
    }

    public ValueSTE(String string, boolean bl) {
        this.mName = string;
        this.mType = Type.BOOL;
        this.mBoolValue = bl;
    }

    public ValueSTE(String string, String string2, Scope scope) {
        this.mName = string;
        this.mType = Type.getClassType(string2);
        this.mObjValue = scope;
    }

    public ValueSTE(String string, int[] nArray) {
        this.mName = string;
        this.mType = Type.INT_ARRAY;
        this.mArrayValue = nArray;
    }

    public Type getType() {
        return this.mType;
    }

    public int getIntVal() {
        return this.mIntValue;
    }

    public boolean getBoolVal() {
        return this.mBoolValue;
    }

    public int[] getArrayRefVal() {
        return this.mArrayValue;
    }

    public Scope getObjSimVal() {
        return this.mObjValue;
    }

    @Override
    public int outputDot(PrintStream printStream, int n) {
        int n2 = n;
        String string = "\t" + n2 + " [label=\" <f0> ValueSTE " + "| <f1> mName = " + this.mName + "| <f2> mType = " + this.mType.toString() + "| <f3> mIntValue = " + this.mIntValue + "| <f4> mBoolValue = " + this.mBoolValue + "| <f5> mArrayValue = " + this.mArrayValue.toString() + "| <f6> mObjSimValue = " + "\"];";
        printStream.println(string);
        printStream.println("\t" + n2 + ":<f6> -> " + n++ + ":<f0>;");
        this.mObjValue.outputDot(printStream, n++);
        return n++;
    }
}

