/*
 * Decompiled with CFR 0.152.
 */
package symtable;

import ast.node.Node;
import exceptions.InternalException;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Stack;
import symtable.ClassSTE;
import symtable.NamedScopeSTE;
import symtable.STE;
import symtable.Scope;
import symtable.Type;

public class SymTable {
    private final Stack<Scope> mScopeStack = new Stack();
    private final Scope mGlobalScope;
    private final HashMap<Node, Type> mExpType = new HashMap();
    private final HashMap<Node, Integer> mExpReg = new HashMap();

    public SymTable() {
        this.mGlobalScope = new Scope(null);
        this.mScopeStack.push(this.mGlobalScope);
    }

    public STE lookup(String string) {
        Scope scope = this.mScopeStack.peek();
        return scope.lookup(string);
    }

    public ClassSTE lookupClass(String string) {
        Scope scope = this.mScopeStack.peek();
        return scope.lookupClass(string);
    }

    public STE lookupInnermost(String string) {
        Scope scope = this.mScopeStack.peek();
        return scope.lookupInnermost(string);
    }

    public void insert(STE sTE) {
        Scope scope = this.mScopeStack.peek();
        scope.insert(sTE);
    }

    public void pushScope(String string) {
        STE sTE = this.lookup(string);
        if (!(sTE instanceof NamedScopeSTE)) {
            throw new InternalException("named scope not found in pushScope");
        }
        NamedScopeSTE namedScopeSTE = (NamedScopeSTE)sTE;
        this.mScopeStack.push(namedScopeSTE.getScope());
    }

    public void insertAndPushScope(NamedScopeSTE namedScopeSTE) {
        this.insert(namedScopeSTE);
        namedScopeSTE.setScope(new Scope(this.mScopeStack.peek()));
        this.mScopeStack.push(namedScopeSTE.getScope());
    }

    public void popScope() {
        this.mScopeStack.pop();
    }

    public void setExpType(Node node, Type type) {
        this.mExpType.put(node, type);
    }

    public Type getExpType(Node node) {
        return this.mExpType.get(node);
    }

    public void setExpReg(Node node, Integer n) {
        this.mExpReg.put(node, n);
    }

    public Integer getExpReg(Node node) {
        return this.mExpReg.get(node);
    }

    public void outputDot(PrintStream printStream) {
        printStream.println("digraph SymTable {");
        printStream.println("\tgraph [rankdir=\"LR\"];");
        printStream.println("\tnode [shape=record];");
        this.mGlobalScope.outputDot(printStream, 0);
        printStream.println("}");
    }
}

