/*
 * Decompiled with CFR 0.152.
 */
package symtable;

import exceptions.InternalException;
import java.io.PrintStream;
import symtable.NamedScopeSTE;

public class ClassSTE
extends NamedScopeSTE {
    private final boolean mMain;
    private final String mSuperClass;
    private int mOffset = 0;
    private int mNumMembers = 0;

    public ClassSTE(String string, boolean bl, String string2) {
        super(string);
        this.mMain = bl;
        this.mSuperClass = string2;
    }

    public int allocMember(int n) {
        int n2 = this.mOffset;
        this.mOffset += n;
        ++this.mNumMembers;
        return n2;
    }

    public int getNumMembers() {
        return this.mNumMembers;
    }

    public boolean isSameOrExtends(ClassSTE classSTE) {
        if (this.mName == classSTE.mName) {
            return true;
        }
        if (this.mSuperClass == null) {
            return false;
        }
        ClassSTE classSTE2 = (ClassSTE)this.mScope.lookup(this.mSuperClass);
        if (classSTE2 == null) {
            throw new InternalException("unexpected null ClassSTE");
        }
        return classSTE2.isSameOrExtends(classSTE);
    }

    @Override
    public int outputDot(PrintStream printStream, int n) {
        int n2 = n++;
        String string = "\t" + n2 + " [label=\" <f0> ClassSTE " + "| <f1> mName = " + this.mName + "| <f2> mMain = " + this.mMain + "| <f3> mSuperClass = " + this.mSuperClass + "| <f4> mScope \"];";
        printStream.println(string);
        printStream.println("\t" + n2 + ":<f4> -> " + n + ":<f0>;");
        return this.mScope.outputDot(printStream, n);
    }
}

