/*
 * Decompiled with CFR 0.152.
 */
package ast.node;

import ast.node.IExp;
import ast.node.IType;
import ast.node.Node;
import ast.visitor.Visitor;

public final class NewArrayExp
extends IExp {
    private IType _type_;
    private IExp _exp_;

    public NewArrayExp(int n, int n2, IType iType, IExp iExp) {
        super(n, n2);
        this.setType(iType);
        this.setExp(iExp);
    }

    @Override
    public int getNumExpChildren() {
        return 1;
    }

    @Override
    public Object clone() {
        return new NewArrayExp(this.getLine(), this.getPos(), this.cloneNode(this._type_), this.cloneNode(this._exp_));
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visitNewArrayExp(this);
    }

    public IType getType() {
        return this._type_;
    }

    public IExp getExp() {
        return this._exp_;
    }

    public void setExp(IExp iExp) {
        if (this._exp_ != null) {
            this._exp_.parent(null);
        }
        if (iExp != null) {
            if (iExp.parent() != null) {
                iExp.parent().removeChild(iExp);
            }
            iExp.parent(this);
        }
        this._exp_ = iExp;
    }

    public void setType(IType iType) {
        if (this._type_ != null) {
            this._type_.parent(null);
        }
        if (iType != null) {
            if (iType.parent() != null) {
                iType.parent().removeChild(iType);
            }
            iType.parent(this);
        }
        this._type_ = iType;
    }

    @Override
    void removeChild(Node node) {
        if (this._type_ == node) {
            this._type_ = null;
            return;
        }
        if (this._exp_ == node) {
            this._exp_ = null;
            return;
        }
        throw new RuntimeException("Not a child.");
    }

    @Override
    void replaceChild(Node node, Node node2) {
        if (this._type_ == node) {
            this.setType((IType)node2);
            return;
        }
        if (this._exp_ == node) {
            this.setExp((IExp)node2);
            return;
        }
        throw new RuntimeException("Not a child.");
    }
}

