/*
 * Decompiled with CFR 0.152.
 */
package ast.node;

import ast.node.IClassDecl;
import ast.node.MainClass;
import ast.node.Node;
import ast.visitor.Visitor;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

public final class Program
extends Node {
    private MainClass _mainClass_;
    private final LinkedList<IClassDecl> _classDecls_ = new LinkedList();

    public Program(int n, int n2, MainClass mainClass, List<IClassDecl> list) {
        super(n, n2);
        this.setMainClass(mainClass);
        this.setClassDecls(list);
    }

    @Override
    public int getNumExpChildren() {
        return 0;
    }

    @Override
    public Object clone() {
        return new Program(this.getLine(), this.getPos(), this.cloneNode(this._mainClass_), this.cloneList(this._classDecls_));
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visitProgram(this);
    }

    public MainClass getMainClass() {
        return this._mainClass_;
    }

    public void setMainClass(MainClass mainClass) {
        if (this._mainClass_ != null) {
            this._mainClass_.parent(null);
        }
        if (mainClass != null) {
            if (mainClass.parent() != null) {
                mainClass.parent().removeChild(mainClass);
            }
            mainClass.parent(this);
        }
        this._mainClass_ = mainClass;
    }

    public LinkedList<IClassDecl> getClassDecls() {
        return this._classDecls_;
    }

    public void setClassDecls(List<IClassDecl> list) {
        this._classDecls_.clear();
        this._classDecls_.addAll(list);
        for (IClassDecl iClassDecl : list) {
            if (iClassDecl.parent() != null) {
                iClassDecl.parent().removeChild(iClassDecl);
            }
            iClassDecl.parent(this);
        }
    }

    @Override
    void removeChild(Node node) {
        if (this._mainClass_ == node) {
            this._mainClass_ = null;
            return;
        }
        if (this._classDecls_.remove(node)) {
            return;
        }
        throw new RuntimeException("Not a child.");
    }

    @Override
    void replaceChild(Node node, Node node2) {
        if (this._mainClass_ == node) {
            this.setMainClass((MainClass)node2);
            return;
        }
        ListIterator<IClassDecl> listIterator = this._classDecls_.listIterator();
        while (listIterator.hasNext()) {
            if (listIterator.next() != node) continue;
            if (node2 != null) {
                listIterator.set((IClassDecl)node2);
                node2.parent(this);
                node.parent(null);
                return;
            }
            listIterator.remove();
            node.parent(null);
            return;
        }
        throw new RuntimeException("Not a child.");
    }
}

