/*
 * Decompiled with CFR 0.152.
 */
package ast.node;

import ast.node.IClassDecl;
import ast.node.MethodDecl;
import ast.node.Node;
import ast.node.VarDecl;
import ast.visitor.Visitor;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

public final class ChildClassDecl
extends IClassDecl {
    private String _name_;
    private String _parent_;
    private final LinkedList<VarDecl> _varDecls_ = new LinkedList();
    private final LinkedList<MethodDecl> _methodDecls_ = new LinkedList();

    public ChildClassDecl(int n, int n2, String string, String string2, List<VarDecl> list, List<MethodDecl> list2) {
        super(n, n2);
        this.setName(string);
        this.setParent(string2);
        this.setVarDecls(list);
        this.setMethodDecls(list2);
    }

    @Override
    public int getNumExpChildren() {
        return 0;
    }

    @Override
    public Object clone() {
        return new ChildClassDecl(this.getLine(), this.getPos(), this._name_, this._parent_, this.cloneList(this._varDecls_), this.cloneList(this._methodDecls_));
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visitChildClassDecl(this);
    }

    public String getName() {
        return this._name_;
    }

    public void setName(String string) {
        this._name_ = string;
    }

    public String getParent() {
        return this._parent_;
    }

    public void setParent(String string) {
        this._parent_ = string;
    }

    public LinkedList<VarDecl> getVarDecls() {
        return this._varDecls_;
    }

    public void setVarDecls(List<VarDecl> list) {
        this._varDecls_.clear();
        this._varDecls_.addAll(list);
        for (VarDecl varDecl : list) {
            if (varDecl.parent() != null) {
                varDecl.parent().removeChild(varDecl);
            }
            varDecl.parent(this);
        }
    }

    public LinkedList<MethodDecl> getMethodDecls() {
        return this._methodDecls_;
    }

    public void setMethodDecls(List<MethodDecl> list) {
        this._methodDecls_.clear();
        this._methodDecls_.addAll(list);
        for (MethodDecl methodDecl : list) {
            if (methodDecl.parent() != null) {
                methodDecl.parent().removeChild(methodDecl);
            }
            methodDecl.parent(this);
        }
    }

    @Override
    void removeChild(Node node) {
        if (this._varDecls_.remove(node)) {
            return;
        }
        if (this._methodDecls_.remove(node)) {
            return;
        }
        throw new RuntimeException("Not a child.");
    }

    @Override
    void replaceChild(Node node, Node node2) {
        ListIterator<Node> listIterator = this._varDecls_.listIterator();
        while (listIterator.hasNext()) {
            if (listIterator.next() != node) continue;
            if (node2 != null) {
                listIterator.set((VarDecl)node2);
                node2.parent(this);
                node.parent(null);
                return;
            }
            listIterator.remove();
            node.parent(null);
            return;
        }
        listIterator = this._methodDecls_.listIterator();
        while (listIterator.hasNext()) {
            if (listIterator.next() != node) continue;
            if (node2 != null) {
                listIterator.set((MethodDecl)node2);
                node2.parent(this);
                node.parent(null);
                return;
            }
            listIterator.remove();
            node.parent(null);
            return;
        }
        throw new RuntimeException("Not a child.");
    }
}

