/*
 * Decompiled with CFR 0.152.
 */
package symtable;

import java.util.LinkedList;
import java.util.List;
import symtable.Type;

public class Signature {
    private final Type returnType;
    private final List<Type> formalTypes;

    public Signature(Type type, List<Type> list) {
        this.returnType = type;
        if (list == null) {
            list = new LinkedList<Type>();
        }
        this.formalTypes = list;
    }

    public int formalCount() {
        return this.formalTypes.size();
    }

    public Type formalType(int n) {
        return this.formalTypes.get(n);
    }

    public Type getReturnType() {
        return this.returnType;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(");
        for (int i = 0; i < this.formalCount(); ++i) {
            if (i > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(this.formalType(i));
        }
        stringBuffer.append(") returns ");
        stringBuffer.append(this.returnType);
        return stringBuffer.toString();
    }
}

