/*
 * Decompiled with CFR 0.152.
 */
package ast_visitors;

import ast.node.BoolType;
import ast.node.ButtonType;
import ast.node.ByteType;
import ast.node.ClassType;
import ast.node.ColorArrayType;
import ast.node.ColorType;
import ast.node.Formal;
import ast.node.IType;
import ast.node.IntArrayType;
import ast.node.IntType;
import ast.node.MethodDecl;
import ast.node.Program;
import ast.node.ToneType;
import ast.node.TopClassDecl;
import ast.node.VarDecl;
import ast.node.VoidType;
import ast.visitor.DepthFirstVisitor;
import exceptions.InternalException;
import exceptions.SemanticException;
import java.util.Iterator;
import java.util.LinkedList;
import symtable.ClassSTE;
import symtable.MethodSTE;
import symtable.NamedScopeSTE;
import symtable.STE;
import symtable.Signature;
import symtable.SymTable;
import symtable.Type;
import symtable.VarSTE;

public class BuildSymTable
extends DepthFirstVisitor {
    private SymTable mCurrentST = new SymTable();
    private ClassSTE mCurrentClass;
    private boolean mError = false;
    private boolean mInMethod = false;
    private int dupcount = 0;

    public SymTable getSymTable() {
        return this.mCurrentST;
    }

    private boolean checkForConflict(String string, int n, int n2) {
        if (this.mCurrentST.lookupInnermost(string) != null) {
            this.mError = true;
            System.err.println("[" + n + "," + n2 + "] Redefined symbol " + string);
            return true;
        }
        return false;
    }

    private Type getType(IType iType) {
        if (iType == null) {
            throw new InternalException("unexpected null argument");
        }
        Type type = Type.INT;
        if (iType instanceof IntArrayType) {
            type = Type.INT_ARRAY;
        }
        if (iType instanceof ColorArrayType) {
            type = Type.COLOR_ARRAY;
        }
        if (iType instanceof BoolType) {
            type = Type.BOOL;
        }
        if (iType instanceof ByteType) {
            type = Type.BYTE;
        }
        if (iType instanceof ColorType) {
            type = Type.COLOR;
        }
        if (iType instanceof ButtonType) {
            type = Type.BUTTON;
        }
        if (iType instanceof ToneType) {
            type = Type.TONE;
        }
        if (iType instanceof IntType) {
            type = Type.INT;
        }
        if (iType instanceof VoidType) {
            type = Type.VOID;
        }
        if (iType instanceof ClassType) {
            type = Type.getClassType(((ClassType)iType).getName());
        }
        return type;
    }

    @Override
    public void outProgram(Program program) {
        if (this.mError) {
            throw new SemanticException("Errors found while building symbol table");
        }
    }

    @Override
    public void outVarDecl(VarDecl varDecl) {
        if (!this.checkForConflict(varDecl.getName(), varDecl.getLine(), varDecl.getPos())) {
            VarSTE varSTE;
            if (this.mInMethod) {
                boolean bl = false;
                boolean bl2 = false;
                varSTE = new VarSTE(varDecl.getName(), this.getType(varDecl.getType()), bl, bl2);
            } else {
                boolean bl = true;
                boolean bl3 = false;
                varSTE = new VarSTE(varDecl.getName(), this.getType(varDecl.getType()), bl, bl3);
            }
            this.mCurrentST.insert(varSTE);
        }
    }

    @Override
    public void inMethodDecl(MethodDecl methodDecl) {
        STE sTE;
        Object object;
        this.mInMethod = true;
        Iterator iterator = methodDecl.getFormals().iterator();
        LinkedList<Type> linkedList = new LinkedList<Type>();
        while (iterator.hasNext()) {
            object = (Formal)iterator.next();
            linkedList.add(this.getType(((Formal)object).getType()));
        }
        object = new Signature(this.getType(methodDecl.getType()), linkedList);
        if (!this.checkForConflict(methodDecl.getName(), methodDecl.getLine(), methodDecl.getPos())) {
            sTE = new MethodSTE(methodDecl.getName(), (Signature)object, methodDecl, this.mCurrentClass.getName() + methodDecl.getName());
            this.mCurrentST.insertAndPushScope((NamedScopeSTE)sTE);
        } else {
            sTE = new MethodSTE(methodDecl.getName() + "bogus" + this.dupcount++, (Signature)object, methodDecl, this.mCurrentClass.getName() + methodDecl.getName());
            this.mCurrentST.insertAndPushScope((NamedScopeSTE)sTE);
        }
        boolean bl = false;
        boolean bl2 = true;
        sTE = new VarSTE("this", Type.getClassType(this.mCurrentClass.getName()), bl, bl2);
        this.mCurrentST.insert(sTE);
        for (Formal formal : methodDecl.getFormals()) {
            if (this.checkForConflict(formal.getName(), formal.getLine(), formal.getPos())) continue;
            bl = false;
            bl2 = true;
            sTE = new VarSTE(formal.getName(), this.getType(formal.getType()), bl, bl2);
            this.mCurrentST.insert(sTE);
        }
    }

    @Override
    public void outMethodDecl(MethodDecl methodDecl) {
        this.mCurrentST.popScope();
        this.mInMethod = false;
    }

    @Override
    public void inTopClassDecl(TopClassDecl topClassDecl) {
        ClassSTE classSTE = !this.checkForConflict(topClassDecl.getName(), topClassDecl.getLine(), topClassDecl.getPos()) ? new ClassSTE(topClassDecl.getName(), false, null) : new ClassSTE(topClassDecl.getName() + "bogus" + this.dupcount++, false, null);
        this.mCurrentClass = classSTE;
        this.mCurrentST.insertAndPushScope(classSTE);
    }

    @Override
    public void outTopClassDecl(TopClassDecl topClassDecl) {
        this.mCurrentST.popScope();
    }
}

