/*
 * Decompiled with CFR 0.152.
 */
package ast_visitors;

import ast.node.AndExp;
import ast.node.CallExp;
import ast.node.CallStatement;
import ast.node.Formal;
import ast.node.IExp;
import ast.node.IStatement;
import ast.node.IfStatement;
import ast.node.MethodDecl;
import ast.node.Node;
import ast.node.TopClassDecl;
import ast.node.VarDecl;
import ast.node.WhileStatement;
import ast.visitor.DepthFirstVisitor;
import exceptions.InternalException;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import symtable.ClassSTE;
import symtable.MethodSTE;
import symtable.SymTable;
import symtable.Type;
import symtable.VarSTE;

public class AVRregAlloc
extends DepthFirstVisitor {
    private final SymTable mCurrentST;
    private boolean debug = false;
    private int mMethod_offset = 1;
    private int mClass_offset = 0;
    private HashMap<Node, Integer> mNodeToTempID = new HashMap();
    private HashMap<Integer, Integer> mTempIDtoReg = new HashMap();
    private HashSet<Integer> mUsedRegs;
    private HashSet<Integer> mCalleeSavedRegs;
    private int tempCount = 0;
    private boolean mFirstPass = true;

    public AVRregAlloc(SymTable symTable) {
        this.mCurrentST = symTable;
    }

    public HashMap<Node, String> getTempMap() {
        HashMap<Node, String> hashMap = new HashMap<Node, String>();
        for (Node node : this.mNodeToTempID.keySet()) {
            hashMap.put(node, this.mNodeToTempID.get(node).toString());
        }
        return hashMap;
    }

    @Override
    public void defaultOut(Node node) {
        if (this.mFirstPass) {
            this.tempCount -= node.getNumExpChildren();
            if (node instanceof IExp) {
                this.mNodeToTempID.put(node, this.tempCount);
                ++this.tempCount;
            }
        } else if (node instanceof IExp) {
            this.mCurrentST.setExpReg(node, this.mTempIDtoReg.get(this.mNodeToTempID.get(node)));
        }
    }

    @Override
    public void visitAndExp(AndExp andExp) {
        if (andExp.getLExp() != null) {
            andExp.getLExp().accept(this);
        }
        if (this.mFirstPass) {
            --this.tempCount;
            if (andExp.getRExp() != null) {
                andExp.getRExp().accept(this);
            }
            --this.tempCount;
            this.mNodeToTempID.put(andExp, this.tempCount);
            ++this.tempCount;
        } else {
            if (andExp.getRExp() != null) {
                andExp.getRExp().accept(this);
            }
            this.mCurrentST.setExpReg(andExp, this.mTempIDtoReg.get(this.mNodeToTempID.get(andExp)));
        }
    }

    @Override
    public void visitIfStatement(IfStatement ifStatement) {
        if (ifStatement.getExp() != null) {
            ifStatement.getExp().accept(this);
        }
        if (this.mFirstPass) {
            --this.tempCount;
        }
        if (ifStatement.getThenStatement() != null) {
            ifStatement.getThenStatement().accept(this);
        }
        if (ifStatement.getElseStatement() != null) {
            ifStatement.getElseStatement().accept(this);
        }
    }

    private void handleMethodCall(Node node, IExp iExp, String string) {
        this.defaultOut(node);
        Type type = this.mCurrentST.getExpType(iExp);
        ClassSTE classSTE = this.mCurrentST.lookupClass(type.getClassName());
        MethodSTE methodSTE = (MethodSTE)classSTE.getScope().lookup(string);
        if (this.mFirstPass) {
            for (int i = 16; i >= 24 - methodSTE.getParamList().size() * 2; i -= 2) {
                this.usingReg(i);
            }
        }
    }

    @Override
    public void outCallExp(CallExp callExp) {
        this.handleMethodCall(callExp, callExp.getExp(), callExp.getId());
    }

    @Override
    public void outCallStatement(CallStatement callStatement) {
        this.handleMethodCall(callStatement, callStatement.getExp(), callStatement.getId());
    }

    private void resetRegisters() {
        this.mUsedRegs = new HashSet();
        this.mCalleeSavedRegs = new HashSet();
        for (int i = 2; i <= 16; i += 2) {
            this.mCalleeSavedRegs.add(i);
        }
    }

    private Integer getReg() {
        Integer n = -1;
        Iterator<Integer> iterator = this.mCalleeSavedRegs.iterator();
        if (iterator.hasNext()) {
            n = iterator.next();
            this.mCalleeSavedRegs.remove(n);
            this.mUsedRegs.add(n);
        }
        return n;
    }

    private boolean usingReg(Integer n) {
        boolean bl = false;
        if (this.mCalleeSavedRegs != null && this.mUsedRegs != null && !this.mUsedRegs.contains(n)) {
            this.mCalleeSavedRegs.remove(n);
            this.mUsedRegs.add(n);
            bl = true;
        }
        return bl;
    }

    private void visitMethodBody(MethodDecl methodDecl) {
        ArrayList<IStatement> arrayList = new ArrayList<IStatement>(methodDecl.getStatements());
        for (IStatement iStatement : arrayList) {
            iStatement.accept(this);
        }
        if (methodDecl.getExp() != null) {
            methodDecl.getExp().accept(this);
        }
    }

    @Override
    public void visitMethodDecl(MethodDecl methodDecl) {
        Object object;
        this.mFirstPass = true;
        String string = methodDecl.getName();
        this.mCurrentST.pushScope(string);
        this.resetRegisters();
        this.visitMethodBody(methodDecl);
        VarSTE varSTE = (VarSTE)this.mCurrentST.lookup("this");
        varSTE.setLocation("Y", this.mMethod_offset);
        this.mMethod_offset += varSTE.getType().getAVRTypeSize();
        int n = methodDecl.getFormals().size();
        Object object2 = new ArrayList<Formal>(methodDecl.getFormals());
        for (int i = n - 1; i >= 0; --i) {
            object = ((ArrayList)object2).get(i);
            VarSTE varSTE2 = (VarSTE)this.mCurrentST.lookup(((Formal)object).getName());
            int n2 = i + 1;
            Integer n3 = n2 >= 4 ? (this.usingReg(24 - 2 * n2) ? Integer.valueOf(24 - 2 * n2) : Integer.valueOf(-1)) : this.getReg();
            if (n3 != -1) {
                if (this.debug) {
                    System.out.println("Mapping " + varSTE2.getName() + " to register " + n3);
                }
                varSTE2.setReg(n3);
                continue;
            }
            if (this.debug) {
                System.out.println("Unable to map " + varSTE2.getName() + " to a register");
            }
            varSTE2.setLocation("Y", this.mMethod_offset);
            this.mMethod_offset += varSTE2.getType().getAVRTypeSize();
        }
        AbstractCollection abstractCollection = new ArrayList<VarDecl>(methodDecl.getVarDecls());
        for (VarDecl varDecl : abstractCollection) {
            varDecl.accept(this);
        }
        abstractCollection = new HashSet();
        for (Integer n4 : this.mNodeToTempID.values()) {
            ((HashSet)abstractCollection).add(n4);
        }
        for (Integer n5 : abstractCollection) {
            object = this.getReg();
            if ((Integer)object != -1) {
                if (this.debug) {
                    System.out.println("Mapping temp " + n5 + " to register " + object);
                }
                this.mTempIDtoReg.put(n5, (Integer)object);
                continue;
            }
            if (!this.debug) continue;
            System.out.println("Unable to map temp " + n5 + " to a register");
        }
        this.defaultOut(methodDecl);
        this.mFirstPass = false;
        this.visitMethodBody(methodDecl);
        this.mTempIDtoReg.clear();
        this.mCurrentST.popScope();
        object2 = (MethodSTE)this.mCurrentST.lookup(string);
        ((MethodSTE)object2).setUsedRegs(this.mUsedRegs);
        ((MethodSTE)object2).setVarNumBytes(this.mMethod_offset - 1);
        this.mMethod_offset = 1;
    }

    @Override
    public void inTopClassDecl(TopClassDecl topClassDecl) {
        this.mCurrentST.pushScope(topClassDecl.getName());
    }

    @Override
    public void outTopClassDecl(TopClassDecl topClassDecl) {
        this.mCurrentST.popScope();
        Type type = Type.getClassType(topClassDecl.getName());
        type.setClassInstanceSize(this.mClass_offset);
        this.mClass_offset = 0;
    }

    @Override
    public void outVarDecl(VarDecl varDecl) {
        VarSTE varSTE = (VarSTE)this.mCurrentST.lookup(varDecl.getName());
        if (varSTE.isMember()) {
            varSTE.setLocation("Z", this.mClass_offset);
            this.mClass_offset += varSTE.getType().getAVRTypeSize();
        } else {
            if (!varSTE.isLocal()) {
                throw new InternalException("Expecting local var");
            }
            Integer n = this.getReg();
            if (n != -1) {
                if (this.debug) {
                    System.out.println("Mapping " + varSTE.getName() + " to register " + n);
                }
                varSTE.setReg(n);
            } else {
                if (this.debug) {
                    System.out.println("Unable to map " + varSTE.getName() + " to a register");
                }
                varSTE.setLocation("Y", this.mMethod_offset);
                this.mMethod_offset += varSTE.getType().getAVRTypeSize();
            }
        }
    }

    @Override
    public void visitWhileStatement(WhileStatement whileStatement) {
        if (whileStatement.getExp() != null) {
            whileStatement.getExp().accept(this);
        }
        if (this.mFirstPass) {
            --this.tempCount;
        }
        if (whileStatement.getStatement() != null) {
            whileStatement.getStatement().accept(this);
        }
    }
}

