/*
 * Decompiled with CFR 0.152.
 */
package ast_visitors;

import ast.node.Formal;
import ast.node.MethodDecl;
import ast.node.TopClassDecl;
import ast.node.VarDecl;
import ast.visitor.DepthFirstVisitor;
import exceptions.InternalException;
import symtable.MethodSTE;
import symtable.SymTable;
import symtable.Type;
import symtable.VarSTE;

public class AVRallocVars
extends DepthFirstVisitor {
    private final SymTable mCurrentST;
    private int mMethod_offset = 1;
    private int mClass_offset = 0;

    public AVRallocVars(SymTable symTable) {
        this.mCurrentST = symTable;
    }

    @Override
    public void outFormal(Formal formal) {
        VarSTE varSTE = (VarSTE)this.mCurrentST.lookup(formal.getName());
        varSTE.setLocation("Y", this.mMethod_offset);
        this.mMethod_offset += varSTE.getType().getAVRTypeSize();
    }

    @Override
    public void inMethodDecl(MethodDecl methodDecl) {
        String string = methodDecl.getName();
        this.mCurrentST.pushScope(string);
        VarSTE varSTE = (VarSTE)this.mCurrentST.lookup("this");
        varSTE.setLocation("Y", this.mMethod_offset);
        this.mMethod_offset += varSTE.getType().getAVRTypeSize();
    }

    @Override
    public void outMethodDecl(MethodDecl methodDecl) {
        this.mCurrentST.popScope();
        String string = methodDecl.getName();
        MethodSTE methodSTE = (MethodSTE)this.mCurrentST.lookup(string);
        methodSTE.setVarNumBytes(this.mMethod_offset - 1);
        this.mMethod_offset = 1;
    }

    @Override
    public void inTopClassDecl(TopClassDecl topClassDecl) {
        this.mCurrentST.pushScope(topClassDecl.getName());
    }

    @Override
    public void outTopClassDecl(TopClassDecl topClassDecl) {
        this.mCurrentST.popScope();
        Type type = Type.getClassType(topClassDecl.getName());
        type.setClassInstanceSize(this.mClass_offset);
        this.mClass_offset = 0;
    }

    @Override
    public void outVarDecl(VarDecl varDecl) {
        VarSTE varSTE = (VarSTE)this.mCurrentST.lookup(varDecl.getName());
        if (varSTE.isMember()) {
            varSTE.setLocation("Z", this.mClass_offset);
            this.mClass_offset += varSTE.getType().getAVRTypeSize();
        } else {
            if (!varSTE.isLocal()) {
                throw new InternalException("Expecting local var");
            }
            varSTE.setLocation("Y", this.mMethod_offset);
            this.mMethod_offset += varSTE.getType().getAVRTypeSize();
        }
    }
}

