/*
 * Decompiled with CFR 0.152.
 */
import ast.node.Node;
import ast_visitors.AVRallocVars;
import ast_visitors.AVRregAlloc;
import ast_visitors.BuildSymTable;
import ast_visitors.CheckTypes;
import ast_visitors.DotVisitor;
import ast_visitors.DotVisitorWithMap;
import exceptions.SemanticException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.PrintStream;
import java.io.PrintWriter;
import mjparser.Yylex;
import mjparser.mj_ast;
import symtable.SymTable;

public class MJDriver {
    private static void usage() {
        System.err.println("MJ: Specify input file in program arguments");
    }

    public static void main(String[] stringArray) {
        if (stringArray.length < 1) {
            MJDriver.usage();
            System.exit(1);
        }
        String string = stringArray[stringArray.length - 1];
        try {
            Yylex yylex = new Yylex(new FileReader(string));
            mj_ast mj_ast2 = new mj_ast(yylex);
            int n = string.lastIndexOf(47);
            mj_ast2.programName = string.substring(n + 1);
            Node node = (Node)mj_ast2.parse().value;
            PrintStream printStream = new PrintStream(new FileOutputStream(string + ".ast.dot"));
            node.accept(new DotVisitor(new PrintWriter(printStream)));
            System.out.println("Printing AST to " + string + ".ast.dot");
            BuildSymTable buildSymTable = new BuildSymTable();
            node.accept(buildSymTable);
            SymTable symTable = buildSymTable.getSymTable();
            PrintStream printStream2 = new PrintStream(new FileOutputStream(string + ".ST.dot"));
            System.out.println("Printing symbol table to " + string + ".ST.dot");
            symTable.outputDot(printStream2);
            node.accept(new CheckTypes(symTable));
            if (stringArray.length == 2 && stringArray[0].equals("--regalloc")) {
                AVRregAlloc aVRregAlloc = new AVRregAlloc(symTable);
                node.accept(aVRregAlloc);
                PrintStream printStream3 = new PrintStream(new FileOutputStream(string + ".ast.temp.dot"));
                node.accept(new DotVisitorWithMap(new PrintWriter(printStream3), aVRregAlloc.getTempMap()));
                System.out.println("Printing AST to " + string + ".ast.temp.dot");
            } else {
                node.accept(new AVRallocVars(symTable));
            }
        }
        catch (SemanticException semanticException) {
            System.err.println(semanticException.getMessage());
            System.exit(1);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
    }
}

