/*
 * Decompiled with CFR 0.152.
 */
package ast.visitor;

import ast.node.AndExp;
import ast.node.ArrayAssignStatement;
import ast.node.ArrayExp;
import ast.node.AssignStatement;
import ast.node.BlockStatement;
import ast.node.BoolType;
import ast.node.ButtonLiteral;
import ast.node.ButtonType;
import ast.node.ByteCast;
import ast.node.ByteType;
import ast.node.CallExp;
import ast.node.CallStatement;
import ast.node.ChildClassDecl;
import ast.node.ClassType;
import ast.node.ColorArrayType;
import ast.node.ColorLiteral;
import ast.node.ColorType;
import ast.node.EqualExp;
import ast.node.FalseLiteral;
import ast.node.Formal;
import ast.node.IClassDecl;
import ast.node.IExp;
import ast.node.IStatement;
import ast.node.IdLiteral;
import ast.node.IfStatement;
import ast.node.IntArrayType;
import ast.node.IntLiteral;
import ast.node.IntType;
import ast.node.LengthExp;
import ast.node.LtExp;
import ast.node.MainClass;
import ast.node.MeggyCheckButton;
import ast.node.MeggyDelay;
import ast.node.MeggyGetPixel;
import ast.node.MeggySetAuxLEDs;
import ast.node.MeggySetPixel;
import ast.node.MeggyToneStart;
import ast.node.MethodDecl;
import ast.node.MinusExp;
import ast.node.MulExp;
import ast.node.NegExp;
import ast.node.NewArrayExp;
import ast.node.NewExp;
import ast.node.Node;
import ast.node.NotExp;
import ast.node.PlusExp;
import ast.node.Program;
import ast.node.ThisLiteral;
import ast.node.ToneLiteral;
import ast.node.ToneType;
import ast.node.TopClassDecl;
import ast.node.TrueLiteral;
import ast.node.VarDecl;
import ast.node.VoidType;
import ast.node.WhileStatement;
import ast.visitor.Visitor;
import java.util.ArrayList;

public class DepthFirstVisitor
extends Visitor {
    public void defaultIn(Node node) {
    }

    public void defaultOut(Node node) {
    }

    public void inAndExp(AndExp andExp) {
        this.defaultIn(andExp);
    }

    public void outAndExp(AndExp andExp) {
        this.defaultOut(andExp);
    }

    @Override
    public void visitAndExp(AndExp andExp) {
        this.inAndExp(andExp);
        if (andExp.getLExp() != null) {
            andExp.getLExp().accept(this);
        }
        if (andExp.getRExp() != null) {
            andExp.getRExp().accept(this);
        }
        this.outAndExp(andExp);
    }

    public void inArrayAssignStatement(ArrayAssignStatement arrayAssignStatement) {
        this.defaultIn(arrayAssignStatement);
    }

    public void outArrayAssignStatement(ArrayAssignStatement arrayAssignStatement) {
        this.defaultOut(arrayAssignStatement);
    }

    @Override
    public void visitArrayAssignStatement(ArrayAssignStatement arrayAssignStatement) {
        this.inArrayAssignStatement(arrayAssignStatement);
        if (arrayAssignStatement.getIdLit() != null) {
            arrayAssignStatement.getIdLit().accept(this);
        }
        if (arrayAssignStatement.getIndex() != null) {
            arrayAssignStatement.getIndex().accept(this);
        }
        if (arrayAssignStatement.getExp() != null) {
            arrayAssignStatement.getExp().accept(this);
        }
        this.outArrayAssignStatement(arrayAssignStatement);
    }

    public void inArrayExp(ArrayExp arrayExp) {
        this.defaultIn(arrayExp);
    }

    public void outArrayExp(ArrayExp arrayExp) {
        this.defaultOut(arrayExp);
    }

    @Override
    public void visitArrayExp(ArrayExp arrayExp) {
        this.inArrayExp(arrayExp);
        if (arrayExp.getExp() != null) {
            arrayExp.getExp().accept(this);
        }
        if (arrayExp.getIndex() != null) {
            arrayExp.getIndex().accept(this);
        }
        this.outArrayExp(arrayExp);
    }

    public void inAssignStatement(AssignStatement assignStatement) {
        this.defaultIn(assignStatement);
    }

    public void outAssignStatement(AssignStatement assignStatement) {
        this.defaultOut(assignStatement);
    }

    @Override
    public void visitAssignStatement(AssignStatement assignStatement) {
        this.inAssignStatement(assignStatement);
        if (assignStatement.getExp() != null) {
            assignStatement.getExp().accept(this);
        }
        this.outAssignStatement(assignStatement);
    }

    public void inBlockStatement(BlockStatement blockStatement) {
        this.defaultIn(blockStatement);
    }

    public void outBlockStatement(BlockStatement blockStatement) {
        this.defaultOut(blockStatement);
    }

    @Override
    public void visitBlockStatement(BlockStatement blockStatement) {
        this.inBlockStatement(blockStatement);
        ArrayList<IStatement> arrayList = new ArrayList<IStatement>(blockStatement.getStatements());
        for (IStatement iStatement : arrayList) {
            iStatement.accept(this);
        }
        this.outBlockStatement(blockStatement);
    }

    public void inBoolType(BoolType boolType) {
        this.defaultIn(boolType);
    }

    public void outBoolType(BoolType boolType) {
        this.defaultOut(boolType);
    }

    @Override
    public void visitBoolType(BoolType boolType) {
        this.inBoolType(boolType);
        this.outBoolType(boolType);
    }

    public void inButtonExp(ButtonLiteral buttonLiteral) {
        this.defaultIn(buttonLiteral);
    }

    public void outButtonExp(ButtonLiteral buttonLiteral) {
        this.defaultOut(buttonLiteral);
    }

    @Override
    public void visitButtonLiteral(ButtonLiteral buttonLiteral) {
        this.inButtonExp(buttonLiteral);
        this.outButtonExp(buttonLiteral);
    }

    public void inButtonType(ButtonType buttonType) {
        this.defaultIn(buttonType);
    }

    public void outButtonType(ButtonType buttonType) {
        this.defaultOut(buttonType);
    }

    @Override
    public void visitButtonType(ButtonType buttonType) {
        this.inButtonType(buttonType);
        this.outButtonType(buttonType);
    }

    public void inByteCast(ByteCast byteCast) {
        this.defaultIn(byteCast);
    }

    public void outByteCast(ByteCast byteCast) {
        this.defaultOut(byteCast);
    }

    @Override
    public void visitByteCast(ByteCast byteCast) {
        this.inByteCast(byteCast);
        if (byteCast.getExp() != null) {
            byteCast.getExp().accept(this);
        }
        this.outByteCast(byteCast);
    }

    public void inByteType(ByteType byteType) {
        this.defaultIn(byteType);
    }

    public void outByteType(ByteType byteType) {
        this.defaultOut(byteType);
    }

    @Override
    public void visitByteType(ByteType byteType) {
        this.inByteType(byteType);
        this.outByteType(byteType);
    }

    public void inCallExp(CallExp callExp) {
        this.defaultIn(callExp);
    }

    public void outCallExp(CallExp callExp) {
        this.defaultOut(callExp);
    }

    @Override
    public void visitCallExp(CallExp callExp) {
        this.inCallExp(callExp);
        if (callExp.getExp() != null) {
            callExp.getExp().accept(this);
        }
        ArrayList<IExp> arrayList = new ArrayList<IExp>(callExp.getArgs());
        for (IExp iExp : arrayList) {
            iExp.accept(this);
        }
        this.outCallExp(callExp);
    }

    public void inCallStatement(CallStatement callStatement) {
        this.defaultIn(callStatement);
    }

    public void outCallStatement(CallStatement callStatement) {
        this.defaultOut(callStatement);
    }

    @Override
    public void visitCallStatement(CallStatement callStatement) {
        this.inCallStatement(callStatement);
        if (callStatement.getExp() != null) {
            callStatement.getExp().accept(this);
        }
        ArrayList<IExp> arrayList = new ArrayList<IExp>(callStatement.getArgs());
        for (IExp iExp : arrayList) {
            iExp.accept(this);
        }
        this.outCallStatement(callStatement);
    }

    public void inChildClassDecl(ChildClassDecl childClassDecl) {
        this.defaultIn(childClassDecl);
    }

    public void outChildClassDecl(ChildClassDecl childClassDecl) {
        this.defaultOut(childClassDecl);
    }

    @Override
    public void visitChildClassDecl(ChildClassDecl childClassDecl) {
        this.inChildClassDecl(childClassDecl);
        ArrayList<Node> arrayList = new ArrayList<VarDecl>(childClassDecl.getVarDecls());
        for (Node node : arrayList) {
            ((VarDecl)node).accept(this);
        }
        arrayList = new ArrayList<MethodDecl>(childClassDecl.getMethodDecls());
        for (Node node : arrayList) {
            ((MethodDecl)node).accept(this);
        }
        this.outChildClassDecl(childClassDecl);
    }

    public void inClassType(ClassType classType) {
        this.defaultIn(classType);
    }

    public void outClassType(ClassType classType) {
        this.defaultOut(classType);
    }

    @Override
    public void visitClassType(ClassType classType) {
        this.inClassType(classType);
        this.outClassType(classType);
    }

    public void inColorExp(ColorLiteral colorLiteral) {
        this.defaultIn(colorLiteral);
    }

    public void outColorExp(ColorLiteral colorLiteral) {
        this.defaultOut(colorLiteral);
    }

    @Override
    public void visitColorLiteral(ColorLiteral colorLiteral) {
        this.inColorExp(colorLiteral);
        this.outColorExp(colorLiteral);
    }

    public void inColorArrayType(ColorArrayType colorArrayType) {
        this.defaultIn(colorArrayType);
    }

    public void outColorArrayType(ColorArrayType colorArrayType) {
        this.defaultOut(colorArrayType);
    }

    @Override
    public void visitColorArrayType(ColorArrayType colorArrayType) {
        this.inColorArrayType(colorArrayType);
        this.outColorArrayType(colorArrayType);
    }

    public void inColorType(ColorType colorType) {
        this.defaultIn(colorType);
    }

    public void outColorType(ColorType colorType) {
        this.defaultOut(colorType);
    }

    @Override
    public void visitColorType(ColorType colorType) {
        this.inColorType(colorType);
        this.outColorType(colorType);
    }

    public void inEqualExp(EqualExp equalExp) {
        this.defaultIn(equalExp);
    }

    public void outEqualExp(EqualExp equalExp) {
        this.defaultOut(equalExp);
    }

    @Override
    public void visitEqualExp(EqualExp equalExp) {
        this.inEqualExp(equalExp);
        if (equalExp.getLExp() != null) {
            equalExp.getLExp().accept(this);
        }
        if (equalExp.getRExp() != null) {
            equalExp.getRExp().accept(this);
        }
        this.outEqualExp(equalExp);
    }

    public void inFalseExp(FalseLiteral falseLiteral) {
        this.defaultIn(falseLiteral);
    }

    public void outFalseExp(FalseLiteral falseLiteral) {
        this.defaultOut(falseLiteral);
    }

    @Override
    public void visitFalseLiteral(FalseLiteral falseLiteral) {
        this.inFalseExp(falseLiteral);
        this.outFalseExp(falseLiteral);
    }

    public void inFormal(Formal formal) {
        this.defaultIn(formal);
    }

    public void outFormal(Formal formal) {
        this.defaultOut(formal);
    }

    @Override
    public void visitFormal(Formal formal) {
        this.inFormal(formal);
        if (formal.getType() != null) {
            formal.getType().accept(this);
        }
        this.outFormal(formal);
    }

    public void inIdLiteral(IdLiteral idLiteral) {
        this.defaultIn(idLiteral);
    }

    public void outIdLiteral(IdLiteral idLiteral) {
        this.defaultOut(idLiteral);
    }

    @Override
    public void visitIdLiteral(IdLiteral idLiteral) {
        this.inIdLiteral(idLiteral);
        this.outIdLiteral(idLiteral);
    }

    public void inIfStatement(IfStatement ifStatement) {
        this.defaultIn(ifStatement);
    }

    public void outIfStatement(IfStatement ifStatement) {
        this.defaultOut(ifStatement);
    }

    @Override
    public void visitIfStatement(IfStatement ifStatement) {
        this.inIfStatement(ifStatement);
        if (ifStatement.getExp() != null) {
            ifStatement.getExp().accept(this);
        }
        if (ifStatement.getThenStatement() != null) {
            ifStatement.getThenStatement().accept(this);
        }
        if (ifStatement.getElseStatement() != null) {
            ifStatement.getElseStatement().accept(this);
        }
        this.outIfStatement(ifStatement);
    }

    public void inIntArrayType(IntArrayType intArrayType) {
        this.defaultIn(intArrayType);
    }

    public void outIntArrayType(IntArrayType intArrayType) {
        this.defaultOut(intArrayType);
    }

    @Override
    public void visitIntArrayType(IntArrayType intArrayType) {
        this.inIntArrayType(intArrayType);
        this.outIntArrayType(intArrayType);
    }

    public void inIntegerExp(IntLiteral intLiteral) {
        this.defaultIn(intLiteral);
    }

    public void outIntegerExp(IntLiteral intLiteral) {
        this.defaultOut(intLiteral);
    }

    @Override
    public void visitIntLiteral(IntLiteral intLiteral) {
        this.inIntegerExp(intLiteral);
        this.outIntegerExp(intLiteral);
    }

    public void inIntType(IntType intType) {
        this.defaultIn(intType);
    }

    public void outIntType(IntType intType) {
        this.defaultOut(intType);
    }

    @Override
    public void visitIntType(IntType intType) {
        this.inIntType(intType);
        this.outIntType(intType);
    }

    public void inLengthExp(LengthExp lengthExp) {
        this.defaultIn(lengthExp);
    }

    public void outLengthExp(LengthExp lengthExp) {
        this.defaultOut(lengthExp);
    }

    @Override
    public void visitLengthExp(LengthExp lengthExp) {
        this.inLengthExp(lengthExp);
        if (lengthExp.getExp() != null) {
            lengthExp.getExp().accept(this);
        }
        this.outLengthExp(lengthExp);
    }

    public void inLtExp(LtExp ltExp) {
        this.defaultIn(ltExp);
    }

    public void outLtExp(LtExp ltExp) {
        this.defaultOut(ltExp);
    }

    @Override
    public void visitLtExp(LtExp ltExp) {
        this.inLtExp(ltExp);
        if (ltExp.getLExp() != null) {
            ltExp.getLExp().accept(this);
        }
        if (ltExp.getRExp() != null) {
            ltExp.getRExp().accept(this);
        }
        this.outLtExp(ltExp);
    }

    public void inMainClass(MainClass mainClass) {
        this.defaultIn(mainClass);
    }

    public void outMainClass(MainClass mainClass) {
        this.defaultOut(mainClass);
    }

    @Override
    public void visitMainClass(MainClass mainClass) {
        this.inMainClass(mainClass);
        if (mainClass.getStatement() != null) {
            mainClass.getStatement().accept(this);
        }
        this.outMainClass(mainClass);
    }

    public void inMeggyCheckButton(MeggyCheckButton meggyCheckButton) {
        this.defaultIn(meggyCheckButton);
    }

    public void outMeggyCheckButton(MeggyCheckButton meggyCheckButton) {
        this.defaultOut(meggyCheckButton);
    }

    @Override
    public void visitMeggyCheckButton(MeggyCheckButton meggyCheckButton) {
        this.inMeggyCheckButton(meggyCheckButton);
        if (meggyCheckButton.getExp() != null) {
            meggyCheckButton.getExp().accept(this);
        }
        this.outMeggyCheckButton(meggyCheckButton);
    }

    public void inMeggyDelay(MeggyDelay meggyDelay) {
        this.defaultIn(meggyDelay);
    }

    public void outMeggyDelay(MeggyDelay meggyDelay) {
        this.defaultOut(meggyDelay);
    }

    @Override
    public void visitMeggyDelay(MeggyDelay meggyDelay) {
        this.inMeggyDelay(meggyDelay);
        if (meggyDelay.getExp() != null) {
            meggyDelay.getExp().accept(this);
        }
        this.outMeggyDelay(meggyDelay);
    }

    public void inMeggyGetPixel(MeggyGetPixel meggyGetPixel) {
        this.defaultIn(meggyGetPixel);
    }

    public void outMeggyGetPixel(MeggyGetPixel meggyGetPixel) {
        this.defaultOut(meggyGetPixel);
    }

    @Override
    public void visitMeggyGetPixel(MeggyGetPixel meggyGetPixel) {
        this.inMeggyGetPixel(meggyGetPixel);
        if (meggyGetPixel.getXExp() != null) {
            meggyGetPixel.getXExp().accept(this);
        }
        if (meggyGetPixel.getYExp() != null) {
            meggyGetPixel.getYExp().accept(this);
        }
        this.outMeggyGetPixel(meggyGetPixel);
    }

    public void inMeggySetAuxLEDs(MeggySetAuxLEDs meggySetAuxLEDs) {
        this.defaultIn(meggySetAuxLEDs);
    }

    public void outMeggySetAuxLEDs(MeggySetAuxLEDs meggySetAuxLEDs) {
        this.defaultOut(meggySetAuxLEDs);
    }

    @Override
    public void visitMeggySetAuxLEDs(MeggySetAuxLEDs meggySetAuxLEDs) {
        this.inMeggySetAuxLEDs(meggySetAuxLEDs);
        if (meggySetAuxLEDs.getExp() != null) {
            meggySetAuxLEDs.getExp().accept(this);
        }
        this.outMeggySetAuxLEDs(meggySetAuxLEDs);
    }

    public void inMeggySetPixel(MeggySetPixel meggySetPixel) {
        this.defaultIn(meggySetPixel);
    }

    public void outMeggySetPixel(MeggySetPixel meggySetPixel) {
        this.defaultOut(meggySetPixel);
    }

    @Override
    public void visitMeggySetPixel(MeggySetPixel meggySetPixel) {
        this.inMeggySetPixel(meggySetPixel);
        if (meggySetPixel.getXExp() != null) {
            meggySetPixel.getXExp().accept(this);
        }
        if (meggySetPixel.getYExp() != null) {
            meggySetPixel.getYExp().accept(this);
        }
        if (meggySetPixel.getColor() != null) {
            meggySetPixel.getColor().accept(this);
        }
        this.outMeggySetPixel(meggySetPixel);
    }

    public void inMeggyToneStart(MeggyToneStart meggyToneStart) {
        this.defaultIn(meggyToneStart);
    }

    public void outMeggyToneStart(MeggyToneStart meggyToneStart) {
        this.defaultOut(meggyToneStart);
    }

    @Override
    public void visitMeggyToneStart(MeggyToneStart meggyToneStart) {
        this.inMeggyToneStart(meggyToneStart);
        if (meggyToneStart.getToneExp() != null) {
            meggyToneStart.getToneExp().accept(this);
        }
        if (meggyToneStart.getDurationExp() != null) {
            meggyToneStart.getDurationExp().accept(this);
        }
        this.outMeggyToneStart(meggyToneStart);
    }

    public void inMethodDecl(MethodDecl methodDecl) {
        this.defaultIn(methodDecl);
    }

    public void outMethodDecl(MethodDecl methodDecl) {
        this.defaultOut(methodDecl);
    }

    @Override
    public void visitMethodDecl(MethodDecl methodDecl) {
        this.inMethodDecl(methodDecl);
        if (methodDecl.getType() != null) {
            methodDecl.getType().accept(this);
        }
        ArrayList<Node> arrayList = new ArrayList<Formal>(methodDecl.getFormals());
        for (Node node : arrayList) {
            ((Formal)node).accept(this);
        }
        arrayList = new ArrayList<VarDecl>(methodDecl.getVarDecls());
        for (Node node : arrayList) {
            ((VarDecl)node).accept(this);
        }
        arrayList = new ArrayList<IStatement>(methodDecl.getStatements());
        for (Node node : arrayList) {
            node.accept(this);
        }
        if (methodDecl.getExp() != null) {
            methodDecl.getExp().accept(this);
        }
        this.outMethodDecl(methodDecl);
    }

    public void inMinusExp(MinusExp minusExp) {
        this.defaultIn(minusExp);
    }

    public void outMinusExp(MinusExp minusExp) {
        this.defaultOut(minusExp);
    }

    @Override
    public void visitMinusExp(MinusExp minusExp) {
        this.inMinusExp(minusExp);
        if (minusExp.getLExp() != null) {
            minusExp.getLExp().accept(this);
        }
        if (minusExp.getRExp() != null) {
            minusExp.getRExp().accept(this);
        }
        this.outMinusExp(minusExp);
    }

    public void inMulExp(MulExp mulExp) {
        this.defaultIn(mulExp);
    }

    public void outMulExp(MulExp mulExp) {
        this.defaultOut(mulExp);
    }

    @Override
    public void visitMulExp(MulExp mulExp) {
        this.inMulExp(mulExp);
        if (mulExp.getLExp() != null) {
            mulExp.getLExp().accept(this);
        }
        if (mulExp.getRExp() != null) {
            mulExp.getRExp().accept(this);
        }
        this.outMulExp(mulExp);
    }

    public void inNewArrayExp(NewArrayExp newArrayExp) {
        this.defaultIn(newArrayExp);
    }

    public void outNewArrayExp(NewArrayExp newArrayExp) {
        this.defaultOut(newArrayExp);
    }

    @Override
    public void visitNewArrayExp(NewArrayExp newArrayExp) {
        this.inNewArrayExp(newArrayExp);
        if (newArrayExp.getType() != null) {
            newArrayExp.getType().accept(this);
        }
        if (newArrayExp.getExp() != null) {
            newArrayExp.getExp().accept(this);
        }
        this.outNewArrayExp(newArrayExp);
    }

    public void inNewExp(NewExp newExp) {
        this.defaultIn(newExp);
    }

    public void outNewExp(NewExp newExp) {
        this.defaultOut(newExp);
    }

    @Override
    public void visitNewExp(NewExp newExp) {
        this.inNewExp(newExp);
        this.outNewExp(newExp);
    }

    public void inNegExp(NegExp negExp) {
        this.defaultIn(negExp);
    }

    public void outNegExp(NegExp negExp) {
        this.defaultOut(negExp);
    }

    @Override
    public void visitNegExp(NegExp negExp) {
        this.inNegExp(negExp);
        if (negExp.getExp() != null) {
            negExp.getExp().accept(this);
        }
        this.outNegExp(negExp);
    }

    public void inNotExp(NotExp notExp) {
        this.defaultIn(notExp);
    }

    public void outNotExp(NotExp notExp) {
        this.defaultOut(notExp);
    }

    @Override
    public void visitNotExp(NotExp notExp) {
        this.inNotExp(notExp);
        if (notExp.getExp() != null) {
            notExp.getExp().accept(this);
        }
        this.outNotExp(notExp);
    }

    public void inPlusExp(PlusExp plusExp) {
        this.defaultIn(plusExp);
    }

    public void outPlusExp(PlusExp plusExp) {
        this.defaultOut(plusExp);
    }

    @Override
    public void visitPlusExp(PlusExp plusExp) {
        this.inPlusExp(plusExp);
        if (plusExp.getLExp() != null) {
            plusExp.getLExp().accept(this);
        }
        if (plusExp.getRExp() != null) {
            plusExp.getRExp().accept(this);
        }
        this.outPlusExp(plusExp);
    }

    public void inProgram(Program program) {
        this.defaultIn(program);
    }

    public void outProgram(Program program) {
        this.defaultOut(program);
    }

    @Override
    public void visitProgram(Program program) {
        this.inProgram(program);
        if (program.getMainClass() != null) {
            program.getMainClass().accept(this);
        }
        ArrayList<IClassDecl> arrayList = new ArrayList<IClassDecl>(program.getClassDecls());
        for (IClassDecl iClassDecl : arrayList) {
            iClassDecl.accept(this);
        }
        this.outProgram(program);
    }

    public void inThisExp(ThisLiteral thisLiteral) {
        this.defaultIn(thisLiteral);
    }

    public void outThisExp(ThisLiteral thisLiteral) {
        this.defaultOut(thisLiteral);
    }

    @Override
    public void visitThisLiteral(ThisLiteral thisLiteral) {
        this.inThisExp(thisLiteral);
        this.outThisExp(thisLiteral);
    }

    public void inToneExp(ToneLiteral toneLiteral) {
        this.defaultIn(toneLiteral);
    }

    public void outToneExp(ToneLiteral toneLiteral) {
        this.defaultOut(toneLiteral);
    }

    @Override
    public void visitToneLiteral(ToneLiteral toneLiteral) {
        this.inToneExp(toneLiteral);
        this.outToneExp(toneLiteral);
    }

    public void inToneType(ToneType toneType) {
        this.defaultIn(toneType);
    }

    public void outToneType(ToneType toneType) {
        this.defaultOut(toneType);
    }

    @Override
    public void visitToneType(ToneType toneType) {
        this.inToneType(toneType);
        this.outToneType(toneType);
    }

    public void inTopClassDecl(TopClassDecl topClassDecl) {
        this.defaultIn(topClassDecl);
    }

    public void outTopClassDecl(TopClassDecl topClassDecl) {
        this.defaultOut(topClassDecl);
    }

    @Override
    public void visitTopClassDecl(TopClassDecl topClassDecl) {
        this.inTopClassDecl(topClassDecl);
        ArrayList<Node> arrayList = new ArrayList<VarDecl>(topClassDecl.getVarDecls());
        for (Node node : arrayList) {
            ((VarDecl)node).accept(this);
        }
        arrayList = new ArrayList<MethodDecl>(topClassDecl.getMethodDecls());
        for (Node node : arrayList) {
            ((MethodDecl)node).accept(this);
        }
        this.outTopClassDecl(topClassDecl);
    }

    public void inTrueExp(TrueLiteral trueLiteral) {
        this.defaultIn(trueLiteral);
    }

    public void outTrueExp(TrueLiteral trueLiteral) {
        this.defaultOut(trueLiteral);
    }

    @Override
    public void visitTrueLiteral(TrueLiteral trueLiteral) {
        this.inTrueExp(trueLiteral);
        this.outTrueExp(trueLiteral);
    }

    public void inVarDecl(VarDecl varDecl) {
        this.defaultIn(varDecl);
    }

    public void outVarDecl(VarDecl varDecl) {
        this.defaultOut(varDecl);
    }

    @Override
    public void visitVarDecl(VarDecl varDecl) {
        this.inVarDecl(varDecl);
        if (varDecl.getType() != null) {
            varDecl.getType().accept(this);
        }
        this.outVarDecl(varDecl);
    }

    public void inVoidType(VoidType voidType) {
        this.defaultIn(voidType);
    }

    public void outVoidType(VoidType voidType) {
        this.defaultOut(voidType);
    }

    @Override
    public void visitVoidType(VoidType voidType) {
        this.inVoidType(voidType);
        this.outVoidType(voidType);
    }

    public void inWhileStatement(WhileStatement whileStatement) {
        this.defaultIn(whileStatement);
    }

    public void outWhileStatement(WhileStatement whileStatement) {
        this.defaultOut(whileStatement);
    }

    @Override
    public void visitWhileStatement(WhileStatement whileStatement) {
        this.inWhileStatement(whileStatement);
        if (whileStatement.getExp() != null) {
            whileStatement.getExp().accept(this);
        }
        if (whileStatement.getStatement() != null) {
            whileStatement.getStatement().accept(this);
        }
        this.outWhileStatement(whileStatement);
    }
}

