/*
 * Decompiled with CFR 0.152.
 */
package symtable;

import exceptions.InternalException;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import symtable.ClassSTE;
import symtable.STE;
import symtable.ValueSTE;

public class Scope {
    private final HashMap<String, STE> mDict = new HashMap();
    private final Scope mEnclosing;
    private final List<String> mDeclOrder = new LinkedList<String>();

    public Scope(Scope scope) {
        this.mEnclosing = scope;
    }

    public STE lookup(String string) {
        if (this.mDict.containsKey(string)) {
            return this.mDict.get(string);
        }
        if (this.mEnclosing != null) {
            return this.mEnclosing.lookup(string);
        }
        return null;
    }

    public ClassSTE lookupClass(String string) {
        if (this.mDict.containsKey(string) && this.mDict.get(string) instanceof ClassSTE) {
            return (ClassSTE)this.mDict.get(string);
        }
        if (this.mEnclosing != null) {
            return this.mEnclosing.lookupClass(string);
        }
        return null;
    }

    public STE lookupInnermost(String string) {
        if (this.mDict.containsKey(string)) {
            return this.mDict.get(string);
        }
        return null;
    }

    public void insert(STE sTE) {
        if (!(sTE instanceof ValueSTE) && this.mDict.containsKey(sTE.getName())) {
            throw new InternalException("Redefined symbol " + sTE.getName());
        }
        this.mDict.put(sTE.getName(), sTE);
        this.mDeclOrder.add(sTE.getName());
    }

    public List<String> getDeclOrder() {
        return this.mDeclOrder;
    }

    public int outputDot(PrintStream printStream, int n) {
        String string;
        int n2 = n;
        String string2 = "\t" + n2 + " [label=\" <f0> Scope ";
        Iterator<String> iterator = this.mDeclOrder.iterator();
        int n3 = 1;
        while (iterator.hasNext()) {
            string = iterator.next();
            string2 = string2 + "| <f" + n3 + "> " + "mDict\\[" + string + "\\] ";
            ++n3;
        }
        string2 = string2 + "\"];";
        printStream.println(string2);
        iterator = this.mDeclOrder.iterator();
        n3 = 1;
        while (iterator.hasNext()) {
            string = iterator.next();
            STE sTE = this.mDict.get(string);
            printStream.println("\t" + n2 + ":<f" + n3 + "> -> " + ++n + ":<f0>;");
            n = sTE.outputDot(printStream, n);
            ++n3;
        }
        return n;
    }
}

