/*
 * Decompiled with CFR 0.152.
 */
package ast_visitors;

import ast.node.AndExp;
import ast.node.ArrayAssignStatement;
import ast.node.ArrayExp;
import ast.node.AssignStatement;
import ast.node.BlockStatement;
import ast.node.BoolType;
import ast.node.ButtonLiteral;
import ast.node.ByteCast;
import ast.node.ByteType;
import ast.node.CallExp;
import ast.node.CallStatement;
import ast.node.ClassType;
import ast.node.ColorArrayType;
import ast.node.ColorLiteral;
import ast.node.ColorType;
import ast.node.EqualExp;
import ast.node.FalseLiteral;
import ast.node.Formal;
import ast.node.IExp;
import ast.node.IdLiteral;
import ast.node.IfStatement;
import ast.node.IntArrayType;
import ast.node.IntLiteral;
import ast.node.IntType;
import ast.node.LengthExp;
import ast.node.LtExp;
import ast.node.MainClass;
import ast.node.MeggyCheckButton;
import ast.node.MeggyDelay;
import ast.node.MeggyGetPixel;
import ast.node.MeggySetAuxLEDs;
import ast.node.MeggySetPixel;
import ast.node.MeggyToneStart;
import ast.node.MethodDecl;
import ast.node.MinusExp;
import ast.node.MulExp;
import ast.node.NegExp;
import ast.node.NewArrayExp;
import ast.node.NewExp;
import ast.node.Node;
import ast.node.NotExp;
import ast.node.PlusExp;
import ast.node.Program;
import ast.node.ThisLiteral;
import ast.node.ToneLiteral;
import ast.node.ToneType;
import ast.node.TopClassDecl;
import ast.node.TrueLiteral;
import ast.node.VarDecl;
import ast.node.VoidType;
import ast.node.WhileStatement;
import ast.visitor.DepthFirstVisitor;
import exceptions.InternalException;
import exceptions.SemanticException;
import java.util.LinkedList;
import symtable.ClassSTE;
import symtable.MethodSTE;
import symtable.STE;
import symtable.Signature;
import symtable.SymTable;
import symtable.Type;
import symtable.VarSTE;

public class CheckTypes
extends DepthFirstVisitor {
    private SymTable mCurrentST;
    private ClassSTE mCurrentClass;

    public CheckTypes(SymTable symTable) {
        if (symTable == null) {
            throw new InternalException("unexpected null argument");
        }
        this.mCurrentST = symTable;
    }

    @Override
    public void defaultOut(Node node) {
        System.err.println("Node not implemented in CheckTypes, " + node.getClass());
    }

    @Override
    public void outAndExp(AndExp andExp) {
        if (this.mCurrentST.getExpType(andExp.getLExp()) != Type.BOOL) {
            throw new SemanticException("Invalid left operand type for operator &&", andExp.getLExp().getLine(), andExp.getLExp().getPos());
        }
        if (this.mCurrentST.getExpType(andExp.getRExp()) != Type.BOOL) {
            throw new SemanticException("Invalid right operand type for operator &&", andExp.getRExp().getLine(), andExp.getRExp().getPos());
        }
        this.mCurrentST.setExpType(andExp, Type.BOOL);
    }

    @Override
    public void outArrayAssignStatement(ArrayAssignStatement arrayAssignStatement) {
        STE sTE = this.mCurrentST.lookup(arrayAssignStatement.getIdLit().getLexeme());
        if (sTE == null || !(sTE instanceof VarSTE)) {
            throw new SemanticException("Undeclared variable " + arrayAssignStatement.getIdLit().getLexeme(), arrayAssignStatement.getIdLit().getLine(), arrayAssignStatement.getIdLit().getPos());
        }
        VarSTE varSTE = (VarSTE)sTE;
        Type type = this.mCurrentST.getExpType(arrayAssignStatement.getExp());
        if (varSTE.getType() != Type.COLOR_ARRAY && varSTE.getType() != Type.INT_ARRAY) {
            throw new SemanticException("Array reference to non-array type", arrayAssignStatement.getExp().getLine(), arrayAssignStatement.getExp().getPos());
        }
        if (this.mCurrentST.getExpType(arrayAssignStatement.getIndex()) != Type.INT && this.mCurrentST.getExpType(arrayAssignStatement.getIndex()) != Type.BYTE) {
            throw new SemanticException("Index expression type for array reference must be INT or BYTE", arrayAssignStatement.getIndex().getLine(), arrayAssignStatement.getIndex().getPos());
        }
        if (varSTE.getType() == Type.INT_ARRAY && type != Type.INT && type != Type.BYTE || varSTE.getType() == Type.COLOR_ARRAY && type != Type.COLOR) {
            throw new SemanticException("Invalid expression type assigned to variable " + arrayAssignStatement.getIdLit(), arrayAssignStatement.getExp().getLine(), arrayAssignStatement.getExp().getPos());
        }
    }

    @Override
    public void outArrayExp(ArrayExp arrayExp) {
        if (this.mCurrentST.getExpType(arrayExp.getExp()) != Type.COLOR_ARRAY && this.mCurrentST.getExpType(arrayExp.getExp()) != Type.INT_ARRAY) {
            throw new SemanticException("Array reference to non-array type", arrayExp.getExp().getLine(), arrayExp.getExp().getPos());
        }
        if (this.mCurrentST.getExpType(arrayExp.getIndex()) != Type.INT && this.mCurrentST.getExpType(arrayExp.getIndex()) != Type.BYTE) {
            throw new SemanticException("Index expression type for array reference must be INT or BYTE", arrayExp.getIndex().getLine(), arrayExp.getIndex().getPos());
        }
        if (this.mCurrentST.getExpType(arrayExp.getExp()) == Type.COLOR_ARRAY) {
            this.mCurrentST.setExpType(arrayExp, Type.COLOR);
        } else {
            this.mCurrentST.setExpType(arrayExp, Type.INT);
        }
    }

    @Override
    public void outAssignStatement(AssignStatement assignStatement) {
        Type type;
        STE sTE = this.mCurrentST.lookup(assignStatement.getId());
        if (sTE == null || !(sTE instanceof VarSTE)) {
            throw new SemanticException("Undeclared variable " + assignStatement.getId(), assignStatement.getLine(), assignStatement.getPos());
        }
        VarSTE varSTE = (VarSTE)sTE;
        Type type2 = varSTE.getType();
        if (type2 != (type = this.mCurrentST.getExpType(assignStatement.getExp())) && (type2 != Type.INT || type != Type.BYTE)) {
            throw new SemanticException("Invalid expression type assigned to variable " + assignStatement.getId(), assignStatement.getExp().getLine(), assignStatement.getExp().getPos());
        }
    }

    @Override
    public void outBlockStatement(BlockStatement blockStatement) {
    }

    @Override
    public void outBoolType(BoolType boolType) {
    }

    @Override
    public void outButtonExp(ButtonLiteral buttonLiteral) {
        this.mCurrentST.setExpType(buttonLiteral, Type.BUTTON);
    }

    @Override
    public void outByteCast(ByteCast byteCast) {
        Type type = this.mCurrentST.getExpType(byteCast.getExp());
        if (type == null || type != Type.INT && type != Type.BYTE) {
            throw new SemanticException("Can only cast a byte or int into a byte type, " + type, byteCast.getExp().getLine(), byteCast.getExp().getPos());
        }
        this.mCurrentST.setExpType(byteCast, Type.BYTE);
    }

    @Override
    public void outByteType(ByteType byteType) {
    }

    private Type typeCheckCall(IExp iExp, String string, int n, int n2, LinkedList<IExp> linkedList) {
        Type type = this.mCurrentST.getExpType(iExp);
        if (type == null || !type.isReference()) {
            throw new SemanticException("Receiver of method call must be a class type", n, n2);
        }
        ClassSTE classSTE = this.mCurrentST.lookupClass(type.getClassName());
        MethodSTE methodSTE = (MethodSTE)classSTE.getScope().lookup(string);
        if (methodSTE == null) {
            throw new SemanticException("Method " + string + " does not exist in class type " + classSTE.getName(), n, n2);
        }
        Signature signature = methodSTE.getSignature();
        int n3 = linkedList.size();
        if (n3 != signature.formalCount()) {
            throw new SemanticException("Method " + string + " requires exactly " + signature.formalCount() + " arguments", n, n2);
        }
        IExp[] iExpArray = new IExp[n3];
        iExpArray = linkedList.toArray(iExpArray);
        for (int i = 0; i < iExpArray.length; ++i) {
            Type type2 = this.mCurrentST.getExpType(iExpArray[i]);
            Type type3 = signature.formalType(i);
            if (type3 == type2 || type3 == Type.INT && type2 == Type.BYTE) continue;
            throw new SemanticException("Invalid argument type for method " + string, iExpArray[i].getLine(), iExpArray[i].getPos());
        }
        return signature.getReturnType();
    }

    @Override
    public void outCallExp(CallExp callExp) {
        Type type = this.typeCheckCall(callExp.getExp(), callExp.getId(), callExp.getLine(), callExp.getPos(), callExp.getArgs());
        this.mCurrentST.setExpType(callExp, type);
    }

    @Override
    public void outCallStatement(CallStatement callStatement) {
        this.typeCheckCall(callStatement.getExp(), callStatement.getId(), callStatement.getLine(), callStatement.getPos(), callStatement.getArgs());
    }

    @Override
    public void outClassType(ClassType classType) {
    }

    @Override
    public void outColorExp(ColorLiteral colorLiteral) {
        this.mCurrentST.setExpType(colorLiteral, Type.COLOR);
    }

    @Override
    public void outColorArrayType(ColorArrayType colorArrayType) {
    }

    @Override
    public void outColorType(ColorType colorType) {
    }

    @Override
    public void outEqualExp(EqualExp equalExp) {
        Type type = this.mCurrentST.getExpType(equalExp.getLExp());
        Type type2 = this.mCurrentST.getExpType(equalExp.getRExp());
        if (type == Type.BUTTON) {
            throw new SemanticException("Invalid operand type for operator ==", equalExp.getRExp().getLine(), equalExp.getRExp().getPos());
        }
        if (type != type2 && (type != Type.INT && type != Type.BYTE || type2 != Type.INT && type2 != Type.BYTE)) {
            throw new SemanticException("Mixed operands to == operator must be of numeric types", equalExp.getLExp().getLine(), equalExp.getLExp().getPos());
        }
        this.mCurrentST.setExpType(equalExp, Type.BOOL);
    }

    @Override
    public void outFormal(Formal formal) {
    }

    @Override
    public void outFalseExp(FalseLiteral falseLiteral) {
        this.mCurrentST.setExpType(falseLiteral, Type.BOOL);
    }

    @Override
    public void outIdLiteral(IdLiteral idLiteral) {
        STE sTE = this.mCurrentST.lookup(idLiteral.getLexeme());
        if (sTE == null) {
            throw new SemanticException("Undeclared variable " + idLiteral.getLexeme(), idLiteral.getLine(), idLiteral.getPos());
        }
        if (sTE instanceof VarSTE) {
            VarSTE varSTE = (VarSTE)sTE;
            this.mCurrentST.setExpType(idLiteral, varSTE.getType());
        }
    }

    @Override
    public void outIfStatement(IfStatement ifStatement) {
        if (this.mCurrentST.getExpType(ifStatement.getExp()) != Type.BOOL) {
            throw new SemanticException("Invalid condition type for if statement", ifStatement.getExp().getLine(), ifStatement.getExp().getPos());
        }
    }

    @Override
    public void outIntArrayType(IntArrayType intArrayType) {
    }

    @Override
    public void outIntType(IntType intType) {
    }

    @Override
    public void outIntegerExp(IntLiteral intLiteral) {
        this.mCurrentST.setExpType(intLiteral, Type.INT);
    }

    @Override
    public void outLengthExp(LengthExp lengthExp) {
        if (this.mCurrentST.getExpType(lengthExp.getExp()) != Type.COLOR_ARRAY && this.mCurrentST.getExpType(lengthExp.getExp()) != Type.INT_ARRAY) {
            throw new SemanticException("Operator length called on non-array type", lengthExp.getExp().getLine(), lengthExp.getExp().getPos());
        }
        this.mCurrentST.setExpType(lengthExp, Type.INT);
    }

    @Override
    public void outLtExp(LtExp ltExp) {
        Type type = this.mCurrentST.getExpType(ltExp.getLExp());
        Type type2 = this.mCurrentST.getExpType(ltExp.getRExp());
        if (type != Type.INT && type != Type.BYTE || type2 != Type.INT && type2 != Type.BYTE) {
            throw new SemanticException("Operands to < operator must be of numeric types", ltExp.getLExp().getLine(), ltExp.getLExp().getPos());
        }
        this.mCurrentST.setExpType(ltExp, Type.BOOL);
    }

    @Override
    public void outMainClass(MainClass mainClass) {
    }

    @Override
    public void outMeggyCheckButton(MeggyCheckButton meggyCheckButton) {
        if (this.mCurrentST.getExpType(meggyCheckButton.getExp()) != Type.BUTTON) {
            throw new SemanticException("Invalid argument type for method MeggyCheckButton", meggyCheckButton.getExp().getLine(), meggyCheckButton.getExp().getPos());
        }
        this.mCurrentST.setExpType(meggyCheckButton, Type.BOOL);
    }

    @Override
    public void outMeggyDelay(MeggyDelay meggyDelay) {
        if (this.mCurrentST.getExpType(meggyDelay.getExp()) != Type.INT) {
            throw new SemanticException("Invalid argument type for method MeggyDelay", meggyDelay.getExp().getLine(), meggyDelay.getExp().getPos());
        }
    }

    @Override
    public void outMeggyGetPixel(MeggyGetPixel meggyGetPixel) {
        if (this.mCurrentST.getExpType(meggyGetPixel.getXExp()) != Type.BYTE) {
            throw new SemanticException("Invalid argument type for method MeggyGetPixel", meggyGetPixel.getXExp().getLine(), meggyGetPixel.getXExp().getPos());
        }
        if (this.mCurrentST.getExpType(meggyGetPixel.getYExp()) != Type.BYTE) {
            throw new SemanticException("Invalid argument type for method MeggyGetPixel", meggyGetPixel.getYExp().getLine(), meggyGetPixel.getYExp().getPos());
        }
        this.mCurrentST.setExpType(meggyGetPixel, Type.COLOR);
    }

    @Override
    public void outMeggySetAuxLEDs(MeggySetAuxLEDs meggySetAuxLEDs) {
        if (this.mCurrentST.getExpType(meggySetAuxLEDs.getExp()) != Type.INT) {
            throw new SemanticException("Invalid argument type for method MeggySetAuxLEDs", meggySetAuxLEDs.getExp().getLine(), meggySetAuxLEDs.getExp().getPos());
        }
    }

    @Override
    public void outMeggySetPixel(MeggySetPixel meggySetPixel) {
        if (this.mCurrentST.getExpType(meggySetPixel.getXExp()) != Type.BYTE) {
            throw new SemanticException("Invalid argument type for method MeggySetPixel", meggySetPixel.getXExp().getLine(), meggySetPixel.getXExp().getPos());
        }
        if (this.mCurrentST.getExpType(meggySetPixel.getYExp()) != Type.BYTE) {
            throw new SemanticException("Invalid argument type for method MeggySetPixel", meggySetPixel.getYExp().getLine(), meggySetPixel.getYExp().getPos());
        }
        if (this.mCurrentST.getExpType(meggySetPixel.getColor()) != Type.COLOR) {
            throw new SemanticException("Invalid argument type for method MeggySetPixel", meggySetPixel.getColor().getLine(), meggySetPixel.getColor().getPos());
        }
    }

    @Override
    public void outMeggyToneStart(MeggyToneStart meggyToneStart) {
        if (this.mCurrentST.getExpType(meggyToneStart.getDurationExp()) != Type.INT) {
            throw new SemanticException("Invalid argument type for method MeggyToneStart", meggyToneStart.getDurationExp().getLine(), meggyToneStart.getDurationExp().getPos());
        }
        if (this.mCurrentST.getExpType(meggyToneStart.getToneExp()) != Type.TONE) {
            throw new SemanticException("Invalid argument type for method MeggyToneStart", meggyToneStart.getToneExp().getLine(), meggyToneStart.getToneExp().getPos());
        }
    }

    @Override
    public void inMethodDecl(MethodDecl methodDecl) {
        this.mCurrentST.pushScope(methodDecl.getName());
    }

    @Override
    public void outMethodDecl(MethodDecl methodDecl) {
        this.mCurrentST.popScope();
        MethodSTE methodSTE = (MethodSTE)this.mCurrentST.lookup(methodDecl.getName());
        Type type = methodSTE.getSignature().getReturnType();
        Type type2 = this.mCurrentST.getExpType(methodDecl.getExp());
        if (type == Type.VOID && type2 != null) {
            throw new SemanticException("Invalid type returned from method " + methodDecl.getName(), methodDecl.getLine(), methodDecl.getPos());
        }
        if (type != type2 && type2 != null) {
            throw new SemanticException("Invalid type returned from method " + methodDecl.getName(), methodDecl.getLine(), methodDecl.getPos());
        }
    }

    @Override
    public void outMinusExp(MinusExp minusExp) {
        Type type = this.mCurrentST.getExpType(minusExp.getLExp());
        Type type2 = this.mCurrentST.getExpType(minusExp.getRExp());
        if (type != Type.INT && type != Type.BYTE || type2 != Type.INT && type2 != Type.BYTE) {
            throw new SemanticException("Operands to - operator must be INT or BYTE", minusExp.getLExp().getLine(), minusExp.getLExp().getPos());
        }
        this.mCurrentST.setExpType(minusExp, Type.INT);
    }

    @Override
    public void outMulExp(MulExp mulExp) {
        if (this.mCurrentST.getExpType(mulExp.getLExp()) != Type.BYTE) {
            throw new SemanticException("Invalid left operand type for operator *", mulExp.getLExp().getLine(), mulExp.getLExp().getPos());
        }
        if (this.mCurrentST.getExpType(mulExp.getRExp()) != Type.BYTE) {
            throw new SemanticException("Invalid right operand type for operator *", mulExp.getRExp().getLine(), mulExp.getRExp().getPos());
        }
        this.mCurrentST.setExpType(mulExp, Type.INT);
    }

    @Override
    public void outNewArrayExp(NewArrayExp newArrayExp) {
        if (this.mCurrentST.getExpType(newArrayExp.getExp()) != Type.INT && this.mCurrentST.getExpType(newArrayExp.getExp()) != Type.BYTE) {
            throw new SemanticException("Invalid operand type for new array operator", newArrayExp.getExp().getLine(), newArrayExp.getExp().getPos());
        }
        if (newArrayExp.getType() instanceof ColorType) {
            this.mCurrentST.setExpType(newArrayExp, Type.COLOR_ARRAY);
        } else if (newArrayExp.getType() instanceof IntType) {
            this.mCurrentST.setExpType(newArrayExp, Type.INT_ARRAY);
        } else {
            throw new SemanticException("Invalid array type for new array operator", newArrayExp.getExp().getLine(), newArrayExp.getExp().getPos());
        }
    }

    @Override
    public void outNewExp(NewExp newExp) {
        STE sTE = this.mCurrentST.lookup(newExp.getId());
        if (sTE == null) {
            throw new SemanticException("Undeclared class type in new operator", newExp.getLine(), newExp.getPos());
        }
        this.mCurrentST.setExpType(newExp, Type.getClassType(newExp.getId()));
    }

    @Override
    public void outNegExp(NegExp negExp) {
        if (this.mCurrentST.getExpType(negExp.getExp()) != Type.INT && this.mCurrentST.getExpType(negExp.getExp()) != Type.BYTE) {
            throw new SemanticException("Invalid operand type for operator UMINUS", negExp.getExp().getLine(), negExp.getExp().getPos());
        }
        this.mCurrentST.setExpType(negExp, Type.INT);
    }

    @Override
    public void outNotExp(NotExp notExp) {
        if (this.mCurrentST.getExpType(notExp.getExp()) != Type.BOOL) {
            throw new SemanticException("Invalid operand type for operator !", notExp.getExp().getLine(), notExp.getExp().getPos());
        }
        this.mCurrentST.setExpType(notExp, Type.BOOL);
    }

    @Override
    public void outProgram(Program program) {
    }

    @Override
    public void outPlusExp(PlusExp plusExp) {
        Type type = this.mCurrentST.getExpType(plusExp.getLExp());
        Type type2 = this.mCurrentST.getExpType(plusExp.getRExp());
        if (type != Type.INT && type != Type.BYTE || type2 != Type.INT && type2 != Type.BYTE) {
            throw new SemanticException("Operands to + operator must be INT or BYTE", plusExp.getLExp().getLine(), plusExp.getLExp().getPos());
        }
        this.mCurrentST.setExpType(plusExp, Type.INT);
    }

    @Override
    public void outThisExp(ThisLiteral thisLiteral) {
        if (this.mCurrentClass == null) {
            throw new InternalException("outThisExp: mCurrentClass==null");
        }
        this.mCurrentST.setExpType(thisLiteral, Type.getClassType(this.mCurrentClass.getName()));
    }

    @Override
    public void outToneExp(ToneLiteral toneLiteral) {
        this.mCurrentST.setExpType(toneLiteral, Type.TONE);
    }

    @Override
    public void outToneType(ToneType toneType) {
    }

    @Override
    public void inTopClassDecl(TopClassDecl topClassDecl) {
        this.mCurrentClass = (ClassSTE)this.mCurrentST.lookup(topClassDecl.getName());
        this.mCurrentST.pushScope(topClassDecl.getName());
    }

    @Override
    public void outTopClassDecl(TopClassDecl topClassDecl) {
        this.mCurrentST.popScope();
    }

    @Override
    public void outTrueExp(TrueLiteral trueLiteral) {
        this.mCurrentST.setExpType(trueLiteral, Type.BOOL);
    }

    @Override
    public void outVarDecl(VarDecl varDecl) {
        ClassSTE classSTE;
        VarSTE varSTE = (VarSTE)this.mCurrentST.lookup(varDecl.getName());
        if (varSTE.getType() == Type.VOID) {
            throw new SemanticException("Cannot declare a variable as type void", varDecl.getLine(), varDecl.getPos());
        }
        if (varSTE.getType().isReference() && (classSTE = (ClassSTE)this.mCurrentST.lookup(varSTE.getType().getClassName())) == null) {
            throw new SemanticException("Class " + varSTE.getType().getClassName() + " does not exist", varDecl.getLine(), varDecl.getPos());
        }
    }

    @Override
    public void outVoidType(VoidType voidType) {
    }

    @Override
    public void outWhileStatement(WhileStatement whileStatement) {
        if (this.mCurrentST.getExpType(whileStatement.getExp()) != Type.BOOL) {
            throw new SemanticException("Invalid condition type for while statement", whileStatement.getExp().getLine(), whileStatement.getExp().getPos());
        }
    }
}

