/*
 * Decompiled with CFR 0.152.
 */
package ast_visitors;

import ast.node.Node;
import ast.visitor.DepthFirstVisitor;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class CheckUsageVisitor
extends DepthFirstVisitor {
    private HashSet<String> mSeenNodes = new HashSet();
    static final Set<String> fullNodeSet = new HashSet<String>(Arrays.asList("AndExp", "ArrayAssignStatement", "ArrayExp", "AssignStatement", "BlockStatement", "BoolType", "ButtonLiteral", "ByteCast", "ByteType", "CallExp", "CallStatement", "ClassType", "ColorArrayType", "ColorLiteral", "ColorType", "EqualExp", "FalseLiteral", "Formal", "IdLiteral", "IfStatement", "IntArrayType", "IntLiteral", "IntType", "LengthExp", "LtExp", "MainClass", "MeggyCheckButton", "MeggyDelay", "MeggyGetPixel", "MeggySetAuxLEDs", "MeggySetPixel", "MeggyToneStart", "MethodDecl", "MinusExp", "MulExp", "NegExp", "NewArrayExp", "NewExp", "NotExp", "PlusExp", "Program", "ThisLiteral", "ToneLiteral", "ToneType", "TopClassDecl", "TrueLiteral", "VarDecl", "VoidType", "WhileStatement"));

    public void reportNumber() {
        System.out.print("Number of node types: ");
        System.out.println(this.mSeenNodes.size());
        System.out.print("Expected number of node types: ");
        System.out.println(fullNodeSet.size());
        System.out.println("Missing node types:");
        for (String string : fullNodeSet) {
            if (this.mSeenNodes.contains(string)) continue;
            System.out.println("\t" + string);
        }
    }

    @Override
    public void defaultOut(Node node) {
        this.mSeenNodes.add(this.getNodeName(node));
    }

    private String getNodeName(Node node) {
        String string = node.getClass().getName();
        String string2 = string.substring(string.lastIndexOf(46) + 1);
        return string2;
    }
}

