/*
 * Decompiled with CFR 0.152.
 */
package symtable;

import exceptions.InternalException;
import java.io.PrintStream;
import symtable.STE;
import symtable.Type;

public class VarSTE
extends STE {
    private Type mType;
    private boolean mIsMember;
    private boolean mIsParam;
    private String mBase = "INVALID";
    private int mOffset = 0;
    private int mReg = -1;

    public VarSTE(String string, Type type, boolean bl, boolean bl2) {
        this.mName = string;
        this.mType = type;
        this.mIsMember = bl;
        this.mIsParam = bl2;
    }

    public void setLocation(String string, int n) {
        this.mBase = string;
        this.mOffset = n;
    }

    public void setReg(Integer n) {
        this.mReg = n;
    }

    public boolean isMember() {
        return this.mIsMember;
    }

    public boolean isParam() {
        return this.mIsParam;
    }

    public boolean isLocal() {
        return !this.mIsParam && !this.mIsMember;
    }

    public Type getType() {
        return this.mType;
    }

    public String getBase() {
        if (this.mBase.equals("INVALID")) {
            throw new InternalException("Location for variable " + this.mName + " has not been set yet.");
        }
        return this.mBase;
    }

    public int getOffset() {
        return this.mOffset;
    }

    public int getReg() {
        return this.mReg;
    }

    @Override
    public int outputDot(PrintStream printStream, int n) {
        int n2 = n;
        String string = "\t" + n2 + " [label=\" <f0> VarSTE " + "| <f1> mName = " + this.mName + "| <f2> mType = " + this.mType.toString() + "| <f3> mBase = " + this.mBase + "| <f4> mOffset = " + this.mOffset + "\"];";
        printStream.println(string);
        return n++;
    }
}

