/*
 * Decompiled with CFR 0.152.
 */
import ast.node.Node;
import ast.visitor.Visitor;
import ast_visitors.AVRallocVars;
import ast_visitors.AVRgenVisitor;
import ast_visitors.AVRregAlloc;
import ast_visitors.BuildSymTable;
import ast_visitors.CheckTypes;
import ast_visitors.CheckUsageVisitor;
import ast_visitors.DotVisitor;
import ast_visitors.DotVisitorWithMap;
import exceptions.SemanticException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import mjparser.Yylex;
import mjparser.mj_ast;
import symtable.SymTable;

public class MJDriver {
    private static void usage() {
        System.err.println("MJ: Specify input file in program arguments");
    }

    public static void main(String[] stringArray) {
        if (stringArray.length < 1) {
            MJDriver.usage();
            System.exit(1);
        }
        String string = stringArray[stringArray.length - 1];
        try {
            PrintStream printStream;
            Object object;
            Object object2;
            Yylex yylex = new Yylex(new FileReader(string));
            mj_ast mj_ast2 = new mj_ast(yylex);
            int n = string.lastIndexOf(47);
            mj_ast2.programName = string.substring(n + 1);
            Node node = (Node)mj_ast2.parse().value;
            if (stringArray.length >= 2 && stringArray[stringArray.length - 2].equals("--checkusage")) {
                object2 = new CheckUsageVisitor();
                node.accept((Visitor)object2);
                ((CheckUsageVisitor)object2).reportNumber();
            }
            object2 = new PrintStream(new FileOutputStream(string + ".ast.dot"));
            node.accept(new DotVisitor(new PrintWriter((OutputStream)object2)));
            System.out.println("Printing AST to " + string + ".ast.dot");
            BuildSymTable buildSymTable = new BuildSymTable();
            node.accept(buildSymTable);
            SymTable symTable = buildSymTable.getSymTable();
            node.accept(new CheckTypes(symTable));
            if (stringArray.length >= 2 && stringArray[0].equals("--regalloc")) {
                object = new AVRregAlloc(symTable);
                node.accept((Visitor)object);
                printStream = new PrintStream(new FileOutputStream(string + ".ast.temp.dot"));
                node.accept(new DotVisitorWithMap(new PrintWriter(printStream), ((AVRregAlloc)object).getTempMap()));
                System.out.println("Printing AST to " + string + ".ast.temp.dot");
            } else {
                node.accept(new AVRallocVars(symTable));
            }
            object = new PrintStream(new FileOutputStream(string + ".ST.dot"));
            System.out.println("Printing symbol table to " + string + ".ST.dot");
            symTable.outputDot((PrintStream)object);
            printStream = new PrintStream(new FileOutputStream(string + ".s"));
            node.accept(new AVRgenVisitor(new PrintWriter(printStream), symTable));
            System.out.println("Printing Atmel assembly to " + string + ".s");
        }
        catch (SemanticException semanticException) {
            System.err.println(semanticException.getMessage());
            System.exit(1);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
    }
}

