/*
 * Decompiled with CFR 0.152.
 */
package symtable;

import exceptions.InternalException;
import java.util.HashMap;

public class Type {
    public static final Type COLOR_ARRAY = new Type();
    public static final Type INT_ARRAY = new Type();
    public static final Type BOOL = new Type();
    public static final Type INT = new Type();
    public static final Type BYTE = new Type();
    public static final Type COLOR = new Type();
    public static final Type TONE = new Type();
    public static final Type BUTTON = new Type();
    public static final Type VOID = new Type();
    private static final HashMap<String, Type> classTypes = new HashMap();
    private final String className;
    private int mClassInstanceSize = 0;

    private Type() {
        this.className = null;
    }

    private Type(String string) {
        if (string == null) {
            throw new InternalException("unexpected null argument");
        }
        this.className = string;
    }

    public static Type getClassType(String string) {
        if (string == null) {
            throw new InternalException("unexpected null argument");
        }
        Type type = classTypes.get(string);
        if (type == null) {
            type = new Type(string);
            classTypes.put(string, type);
        }
        return type;
    }

    public boolean isReference() {
        return this.className != null;
    }

    public String getClassName() {
        if (this.className == null) {
            throw new InternalException("non-reference type");
        }
        return this.className;
    }

    public String toString() {
        if (this == INT) {
            return "INT";
        }
        if (this == BOOL) {
            return "BOOL";
        }
        if (this == BYTE) {
            return "BYTE";
        }
        if (this == COLOR) {
            return "COLOR";
        }
        if (this == BUTTON) {
            return "BUTTON";
        }
        if (this == TONE) {
            return "TONE";
        }
        if (this == INT_ARRAY) {
            return "[INT]";
        }
        if (this == COLOR_ARRAY) {
            return "[COLOR]";
        }
        return "class_" + this.className + ";";
    }

    public int getAVRTypeSize() {
        if (this == INT) {
            return 2;
        }
        if (this == BOOL) {
            return 1;
        }
        if (this == BYTE) {
            return 1;
        }
        if (this == COLOR) {
            return 1;
        }
        if (this == BUTTON) {
            return 1;
        }
        if (this == TONE) {
            return 2;
        }
        if (this == INT_ARRAY) {
            return 2;
        }
        if (this == COLOR_ARRAY) {
            return 2;
        }
        if (this == VOID) {
            return 0;
        }
        return 2;
    }

    public void setClassInstanceSize(int n) {
        this.mClassInstanceSize = n;
    }

    public int getClassInstanceSize() {
        return this.mClassInstanceSize;
    }
}

