/*
 * Decompiled with CFR 0.152.
 */
package ast_visitors;

import ast.node.AndExp;
import ast.node.ArrayAssignStatement;
import ast.node.ArrayExp;
import ast.node.AssignStatement;
import ast.node.BlockStatement;
import ast.node.BoolType;
import ast.node.ButtonLiteral;
import ast.node.ByteCast;
import ast.node.ByteType;
import ast.node.CallExp;
import ast.node.CallStatement;
import ast.node.ClassType;
import ast.node.ColorArrayType;
import ast.node.ColorLiteral;
import ast.node.ColorType;
import ast.node.EqualExp;
import ast.node.FalseLiteral;
import ast.node.Formal;
import ast.node.IExp;
import ast.node.IdLiteral;
import ast.node.IfStatement;
import ast.node.IntArrayType;
import ast.node.IntLiteral;
import ast.node.IntType;
import ast.node.LengthExp;
import ast.node.LtExp;
import ast.node.MainClass;
import ast.node.MeggyCheckButton;
import ast.node.MeggyDelay;
import ast.node.MeggyGetPixel;
import ast.node.MeggySetAuxLEDs;
import ast.node.MeggySetPixel;
import ast.node.MeggyToneStart;
import ast.node.MethodDecl;
import ast.node.MinusExp;
import ast.node.MulExp;
import ast.node.NegExp;
import ast.node.NewArrayExp;
import ast.node.NewExp;
import ast.node.Node;
import ast.node.NotExp;
import ast.node.PlusExp;
import ast.node.Program;
import ast.node.ThisLiteral;
import ast.node.ToneLiteral;
import ast.node.ToneType;
import ast.node.TopClassDecl;
import ast.node.TrueLiteral;
import ast.node.VarDecl;
import ast.node.VoidType;
import ast.node.WhileStatement;
import ast.visitor.DepthFirstVisitor;
import exceptions.InternalException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import label.Label;
import symtable.ClassSTE;
import symtable.MethodSTE;
import symtable.Signature;
import symtable.SymTable;
import symtable.Type;
import symtable.VarSTE;

public class AVRgenVisitor
extends DepthFirstVisitor {
    private final PrintWriter out;
    private final SymTable mCurrentST;
    private ClassSTE mCurrentClass;
    private int class_offset = 0;
    private Object[] mUsedRegArray;

    public AVRgenVisitor(PrintWriter printWriter, SymTable symTable) {
        this.out = printWriter;
        this.mCurrentST = symTable;
        printWriter.println("    .file  \"main.java\"");
        try {
            InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream("avrH.rtl.s");
            this.out.println(this.convertStreamToString(inputStream));
            inputStream.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        printWriter.flush();
    }

    private RegPair getExpReg(Node node) {
        RegPair regPair = null;
        Integer n = this.mCurrentST.getExpReg(node);
        if (n != null) {
            int n2 = n + 1;
            regPair = new RegPair("r" + n, "r" + n2);
        }
        return regPair;
    }

    private RegPair getVarReg(VarSTE varSTE) {
        RegPair regPair = null;
        Integer n = varSTE.getReg();
        if (n > 0) {
            regPair = varSTE.getType().getAVRTypeSize() == 2 ? new RegPair("r" + n, "r" + (n + 1)) : new RegPair("r" + n, null);
        }
        return regPair;
    }

    private RegPair genLoadExp(Node node, int n) {
        RegPair regPair = this.getExpReg(node);
        if (regPair == null) {
            regPair = new RegPair("r" + n, "r" + (n + 1));
            if (this.mCurrentST.getExpType(node).getAVRTypeSize() == 2) {
                this.out.println("    # load a two byte expression off stack");
                this.out.println("    pop    " + regPair.lobitReg);
                this.out.println("    pop    " + regPair.hibitReg);
            } else {
                this.out.println("    # load a one byte expression off stack");
                this.out.println("    pop    " + regPair.lobitReg);
            }
        }
        return regPair;
    }

    private void genStoreExp(Node node, RegPair regPair) {
        RegPair regPair2 = this.getExpReg(node);
        if (regPair2 == null) {
            if (this.mCurrentST.getExpType(node).getAVRTypeSize() == 2) {
                this.out.println("    # push two byte expression onto stack");
                this.out.println("    push   " + regPair.hibitReg);
                this.out.println("    push   " + regPair.lobitReg);
            } else {
                this.out.println("    # push one byte expression onto stack");
                this.out.println("    push   " + regPair.lobitReg);
            }
        } else if (!regPair2.lobitReg.equals(regPair.lobitReg)) {
            this.genMoveReg(regPair2, regPair);
        }
    }

    private RegPair genLoadVar(VarSTE varSTE, int n) {
        RegPair regPair = this.getVarReg(varSTE);
        if (regPair == null) {
            regPair = new RegPair("r" + n, "r" + (n + 1));
            this.out.println();
            if (varSTE.getType().getAVRTypeSize() == 2) {
                this.out.println("    # load a two byte variable from base+offset");
                this.out.println("    ldd    " + regPair.hibitReg + ", " + varSTE.getBase() + " + " + (varSTE.getOffset() + 1));
                this.out.println("    ldd    " + regPair.lobitReg + ", " + varSTE.getBase() + " + " + varSTE.getOffset());
            } else {
                this.out.println("    # load a one byte variable from base+offset");
                this.out.println("    ldd    " + regPair.lobitReg + ", " + varSTE.getBase() + " + " + varSTE.getOffset());
            }
        } else {
            this.out.println("    # var " + varSTE.getName() + " is in " + regPair.lobitReg);
        }
        return regPair;
    }

    private void genStoreVar(VarSTE varSTE, RegPair regPair) {
        RegPair regPair2 = this.getVarReg(varSTE);
        if (regPair2 != null) {
            this.genMoveReg(regPair2, regPair);
        } else if (varSTE.getType().getAVRTypeSize() == 1) {
            this.out.println("    std    " + varSTE.getBase() + " + " + varSTE.getOffset() + ", " + regPair.lobitReg);
        } else if (varSTE.getType().getAVRTypeSize() == 2) {
            this.out.println("    std    " + varSTE.getBase() + " + " + (varSTE.getOffset() + 1) + ", " + regPair.hibitReg);
            this.out.println("    std    " + varSTE.getBase() + " + " + varSTE.getOffset() + ", " + regPair.lobitReg);
        }
    }

    private void genMoveReg(RegPair regPair, RegPair regPair2) {
        if (!regPair.lobitReg.equals(regPair2.lobitReg)) {
            this.out.println("    # move low byte src into dest reg");
            this.out.println("    mov    " + regPair.lobitReg + ", " + regPair2.lobitReg);
        }
        if (regPair.hibitReg != null && regPair2.hibitReg != null && !regPair.lobitReg.equals(regPair2.lobitReg)) {
            this.out.println("    # move hi byte src into dest reg");
            this.out.println("    mov    " + regPair.hibitReg + ", " + regPair2.hibitReg);
        }
    }

    @Override
    public void defaultOut(Node node) {
        System.err.println("Node not implemented in AVRgenVisitor, " + node.getClass());
    }

    @Override
    public void visitAndExp(AndExp andExp) {
        this.out.println();
        this.out.println("    #### short-circuited && operation");
        this.out.println("    # &&: left operand");
        if (andExp.getLExp() != null) {
            andExp.getLExp().accept(this);
        }
        Label label = new Label();
        Label label2 = new Label();
        this.out.println();
        this.out.println("    # &&: if left operand is false do not eval right");
        RegPair regPair = this.genLoadExp(andExp.getLExp(), 24);
        this.genStoreExp(andExp, regPair);
        this.out.println("    # compare left exp with zero");
        this.out.println("    ldi r25, 0");
        this.out.println("    cp    " + regPair.lobitReg + ", r25");
        this.out.println("    # Want this, breq " + label);
        this.out.println("    brne  " + label2);
        this.out.println("    jmp   " + label);
        this.out.println();
        this.out.println(label2 + ":");
        this.out.println("    # right operand");
        this.genLoadExp(andExp.getLExp(), 24);
        if (andExp.getRExp() != null) {
            andExp.getRExp().accept(this);
        }
        RegPair regPair2 = this.genLoadExp(andExp.getRExp(), 24);
        this.genStoreExp(andExp, regPair2);
        this.out.println();
        this.out.println(label + ":");
    }

    private void genArrayElemAddressArithmetic(Type type, Node node, Node node2) {
        this.out.println("    # calculate the array element address by first");
        this.out.println("    # loading index");
        RegPair regPair = this.genLoadExp(node2, 18);
        if (this.mCurrentST.getExpType(node2) == Type.BYTE) {
            this.promoteReg(regPair);
        }
        if (type == Type.INT_ARRAY) {
            this.out.println("    # add size in elems to self to multiply by 2");
            this.out.println("    # complements of Jason Mealler");
            this.out.println("    add    " + regPair.lobitReg + "," + regPair.lobitReg);
            this.out.println("    adc    " + regPair.hibitReg + "," + regPair.hibitReg);
        }
        this.out.println("    # put index*(elem size in bytes) into r31:r30");
        this.out.println("    mov    r31, " + regPair.hibitReg);
        this.out.println("    mov    r30, " + regPair.lobitReg);
        this.out.println("    # want result of addressing arithmetic ");
        this.out.println("    # to be in r31:r30 for access through Z");
        this.out.println("    # index over length");
        this.out.println("    ldi    r20, 2");
        this.out.println("    ldi    r21, 0");
        this.out.println("    add    r30, r20");
        this.out.println("    adc    r31, r21");
        this.out.println("    # loading array reference");
        RegPair regPair2 = this.genLoadExp(node, 22);
        this.out.println("    # add array reference to result of indexing arithmetic");
        this.out.println("    add    r30, " + regPair2.lobitReg);
        this.out.println("    adc    r31, " + regPair2.hibitReg);
    }

    @Override
    public void outArrayAssignStatement(ArrayAssignStatement arrayAssignStatement) {
        VarSTE varSTE = (VarSTE)this.mCurrentST.lookup(arrayAssignStatement.getIdLit().getLexeme());
        this.out.println();
        this.out.println("    ### ArrayAssignStatement");
        this.out.println("    # load rhs");
        RegPair regPair = this.genLoadExp(arrayAssignStatement.getExp(), 24);
        if (this.mCurrentST.getExpType(arrayAssignStatement.getExp()) == Type.BYTE && varSTE.getType() == Type.INT) {
            this.promoteReg(regPair);
        }
        this.genArrayElemAddressArithmetic(varSTE.getType(), arrayAssignStatement.getIdLit(), arrayAssignStatement.getIndex());
        this.out.println("    # store rhs into memory location for array element");
        if (varSTE.getType() == Type.COLOR_ARRAY) {
            this.out.println("    std    Z+0, " + regPair.lobitReg);
        } else if (varSTE.getType() == Type.INT_ARRAY) {
            this.out.println("    std    Z+0, " + regPair.lobitReg);
            this.out.println("    std    Z+1, " + regPair.hibitReg);
        } else {
            throw new InternalException("Unknown array type.");
        }
        this.out.flush();
    }

    @Override
    public void outArrayExp(ArrayExp arrayExp) {
        this.out.println();
        this.out.println("    ### ArrayExp");
        this.genArrayElemAddressArithmetic(this.mCurrentST.getExpType(arrayExp.getExp()), arrayExp.getExp(), arrayExp.getIndex());
        this.out.println("    # load array element and push onto stack");
        RegPair regPair = new RegPair("r24", "r25");
        if (this.mCurrentST.getExpType(arrayExp.getExp()) == Type.COLOR_ARRAY) {
            this.out.println("    ldd    " + regPair.lobitReg + ", Z+0");
        } else if (this.mCurrentST.getExpType(arrayExp.getExp()) == Type.INT_ARRAY) {
            this.out.println("    ldd    " + regPair.lobitReg + ", Z+0");
            this.out.println("    ldd    " + regPair.hibitReg + ", Z+1");
        } else {
            throw new InternalException("Unknown array type, " + this.mCurrentST.getExpType(arrayExp));
        }
        this.genStoreExp(arrayExp, regPair);
        this.out.flush();
    }

    @Override
    public void outAssignStatement(AssignStatement assignStatement) {
        VarSTE varSTE = (VarSTE)this.mCurrentST.lookup(assignStatement.getId());
        this.out.println();
        this.out.println("    ### AssignStatement");
        this.out.println("    # load rhs exp");
        RegPair regPair = this.genLoadExp(assignStatement.getExp(), 24);
        if (this.mCurrentST.getExpType(assignStatement.getExp()) == Type.BYTE && varSTE.getType() == Type.INT) {
            this.promoteReg(regPair);
        }
        if (varSTE.isMember()) {
            this.genLoadThis();
        }
        this.out.println("    # store rhs into var " + varSTE.getName());
        this.genStoreVar(varSTE, regPair);
        this.out.flush();
    }

    @Override
    public void outBlockStatement(BlockStatement blockStatement) {
    }

    @Override
    public void outButtonExp(ButtonLiteral buttonLiteral) {
    }

    @Override
    public void outBoolType(BoolType boolType) {
    }

    @Override
    public void outByteCast(ByteCast byteCast) {
        if (this.mCurrentST.getExpType(byteCast.getExp()) == Type.INT && (this.mCurrentST.getExpReg(byteCast.getExp()) == null || this.mCurrentST.getExpReg(byteCast.getExp()) != this.mCurrentST.getExpReg(byteCast))) {
            if (this.mCurrentST.getExpReg(byteCast) != null) {
                throw new InternalException("Expecting self to have no reg");
            }
            this.out.println();
            this.out.println("    # Casting int to byte by popping");
            this.out.println("    # 2 bytes off stack and only pushing low order bits");
            this.out.println("    # back on.  Low order bits are on top of stack.");
            this.out.println("    pop    r24");
            this.out.println("    pop    r25");
            this.out.println("    push   r24");
        }
    }

    @Override
    public void outByteType(ByteType byteType) {
    }

    @Override
    public void outColorArrayType(ColorArrayType colorArrayType) {
    }

    @Override
    public void outColorType(ColorType colorType) {
    }

    private Type genFunctionCall(IExp iExp, String string, LinkedList<IExp> linkedList) {
        Type type = this.mCurrentST.getExpType(iExp);
        ClassSTE classSTE = this.mCurrentST.lookupClass(type.getClassName());
        MethodSTE methodSTE = (MethodSTE)classSTE.getScope().lookup(string);
        Signature signature = methodSTE.getSignature();
        this.out.println();
        this.out.println("    #### function call");
        Object object = new ArrayList<IExp>(linkedList);
        this.out.println("    # put parameter values into appropriate registers");
        for (int i = ((ArrayList)object).size(); i > 0; --i) {
            IExp iExp2 = ((ArrayList)object).get(i - 1);
            RegPair regPair = this.genLoadExp(iExp2, 24 - 2 * i);
            Type type2 = this.mCurrentST.getExpType(iExp2);
            Type type3 = signature.formalType(i - 1);
            if (type2 == Type.BYTE && type3 == Type.INT) {
                this.promoteReg(regPair);
            }
            RegPair regPair2 = type3.getAVRTypeSize() == 2 ? new RegPair("r" + (24 - 2 * i), "r" + (24 - 2 * i + 1)) : new RegPair("r" + (24 - 2 * i), null);
            this.genMoveReg(regPair2, regPair);
        }
        this.out.println("    # receiver will be passed as first param");
        object = this.genLoadExp(iExp, 24);
        RegPair regPair = new RegPair("r24", "r25");
        this.genMoveReg(regPair, (RegPair)object);
        this.out.println();
        this.out.println("    call    " + methodSTE.getMunged());
        return methodSTE.getSignature().getReturnType();
    }

    @Override
    public void outCallExp(CallExp callExp) {
        this.genFunctionCall(callExp.getExp(), callExp.getId(), callExp.getArgs());
        this.out.println();
        this.out.println("    # handle return value");
        RegPair regPair = new RegPair("r24", "r25");
        this.genStoreExp(callExp, regPair);
        this.out.flush();
    }

    @Override
    public void outCallStatement(CallStatement callStatement) {
        this.genFunctionCall(callStatement.getExp(), callStatement.getId(), callStatement.getArgs());
    }

    @Override
    public void outClassType(ClassType classType) {
    }

    @Override
    public void outColorExp(ColorLiteral colorLiteral) {
        this.out.println();
        this.out.println("    # Color expression " + colorLiteral.getLexeme());
        this.out.println("    ldi    r22," + colorLiteral.getIntValue());
        RegPair regPair = new RegPair("r22", null);
        this.genStoreExp(colorLiteral, regPair);
    }

    @Override
    public void outEqualExp(EqualExp equalExp) {
        Label label = new Label();
        Label label2 = new Label();
        Label label3 = new Label();
        this.out.println();
        this.out.println("    # equality check expression");
        RegPair regPair = this.genLoadExp(equalExp.getRExp(), 18);
        RegPair regPair2 = this.genLoadExp(equalExp.getLExp(), 24);
        if (this.mCurrentST.getExpType(equalExp.getLExp()).getAVRTypeSize() == 1 && this.mCurrentST.getExpType(equalExp.getRExp()).getAVRTypeSize() == 1) {
            this.out.println("    cp    " + regPair2.lobitReg + ", " + regPair.lobitReg);
        } else {
            if (this.mCurrentST.getExpType(equalExp.getLExp()).getAVRTypeSize() == 1) {
                this.promoteReg(regPair2);
            }
            if (this.mCurrentST.getExpType(equalExp.getRExp()).getAVRTypeSize() == 1) {
                this.promoteReg(regPair);
            }
            this.out.println("    cp    " + regPair2.lobitReg + ", " + regPair.lobitReg);
            this.out.println("    cpc   " + regPair2.hibitReg + ", " + regPair.hibitReg);
        }
        this.out.println("    breq " + label2);
        this.out.println();
        this.out.println("    # result is false");
        this.out.println(label + ":");
        this.out.println("    ldi     r24, 0");
        this.out.println("    jmp      " + label3);
        this.out.println();
        this.out.println("    # result is true");
        this.out.println(label2 + ":");
        this.out.println("    ldi     r24, 1");
        this.out.println();
        this.out.println("    # store result of equal expression");
        this.out.println(label3 + ":");
        this.genStoreExp(equalExp, new RegPair("r24", null));
    }

    @Override
    public void outFalseExp(FalseLiteral falseLiteral) {
        this.out.println();
        this.out.println("    # False/0 expression");
        this.out.println("    ldi    r24,0");
        RegPair regPair = new RegPair("r24", null);
        this.genStoreExp(falseLiteral, regPair);
    }

    @Override
    public void outFormal(Formal formal) {
    }

    private void genLoadThis() {
        RegPair regPair = new RegPair("r30", "r31");
        this.out.println();
        this.out.println("    # loading the implicit \"this\"");
        VarSTE varSTE = (VarSTE)this.mCurrentST.lookup("this");
        RegPair regPair2 = this.genLoadVar(varSTE, 30);
        this.genMoveReg(regPair, regPair2);
    }

    @Override
    public void outIdLiteral(IdLiteral idLiteral) {
        VarSTE varSTE = (VarSTE)this.mCurrentST.lookup(idLiteral.getLexeme());
        this.out.println();
        this.out.println("    # IdExp");
        this.out.println("    # load value for variable " + idLiteral.getLexeme());
        if (varSTE.isMember()) {
            this.genLoadThis();
            this.out.println("    # variable is a member variable");
        } else {
            this.out.println("    # variable is a local or param variable");
        }
        RegPair regPair = this.genLoadVar(varSTE, 24);
        this.genStoreExp(idLiteral, regPair);
    }

    @Override
    public void visitIfStatement(IfStatement ifStatement) {
        this.out.println();
        this.out.println("    #### if statement");
        Label label = new Label();
        Label label2 = new Label();
        Label label3 = new Label();
        if (ifStatement.getExp() != null) {
            ifStatement.getExp().accept(this);
        }
        this.out.println();
        this.out.println("    # load condition and branch if false");
        RegPair regPair = this.genLoadExp(ifStatement.getExp(), 24);
        this.out.println("    #load zero into reg");
        this.out.println("    ldi    r25, 0");
        this.out.println();
        this.out.println("    #use cp to set SREG");
        this.out.println("    cp     " + regPair.lobitReg + ", r25");
        this.out.println("    #WANT breq " + label);
        this.out.println("    brne   " + label2);
        this.out.println("    jmp    " + label);
        this.out.println();
        this.out.println("    # then label for if");
        this.out.println(label2 + ":");
        if (ifStatement.getThenStatement() != null) {
            ifStatement.getThenStatement().accept(this);
        }
        this.out.println("    jmp    " + label3);
        this.out.println();
        this.out.println("    # else label for if");
        this.out.println(label + ":");
        if (ifStatement.getElseStatement() != null) {
            ifStatement.getElseStatement().accept(this);
        }
        this.out.println();
        this.out.println("    # done label for if");
        this.out.println(label3 + ":");
    }

    @Override
    public void outIntegerExp(IntLiteral intLiteral) {
        this.out.println();
        int n = intLiteral.getIntValue();
        this.out.println("    # Load constant int " + n);
        this.out.println("    ldi    r24,lo8(" + n + ")");
        this.out.println("    ldi    r25,hi8(" + n + ")");
        this.genStoreExp(intLiteral, new RegPair("r24", "r25"));
        this.out.flush();
    }

    @Override
    public void outIntType(IntType intType) {
    }

    @Override
    public void outIntArrayType(IntArrayType intArrayType) {
    }

    @Override
    public void outLengthExp(LengthExp lengthExp) {
        this.out.println();
        this.out.println("    # length of array");
        RegPair regPair = this.genLoadExp(lengthExp.getExp(), 30);
        this.genMoveReg(new RegPair("r30", "r31"), regPair);
        this.out.println("    ldd   r24, Z+0");
        this.out.println("    ldd   r25, Z+1");
        this.genStoreExp(lengthExp, new RegPair("r24", "r25"));
        this.out.flush();
    }

    @Override
    public void outLtExp(LtExp ltExp) {
        Label label = new Label();
        Label label2 = new Label();
        Label label3 = new Label();
        this.out.println();
        this.out.println("    # less than expression");
        RegPair regPair = this.genLoadExp(ltExp.getRExp(), 18);
        RegPair regPair2 = this.genLoadExp(ltExp.getLExp(), 24);
        if (this.mCurrentST.getExpType(ltExp.getLExp()).getAVRTypeSize() == 1 && this.mCurrentST.getExpType(ltExp.getRExp()).getAVRTypeSize() == 1) {
            this.out.println("    cp    " + regPair2.lobitReg + ", " + regPair.lobitReg);
        } else {
            if (this.mCurrentST.getExpType(ltExp.getLExp()).getAVRTypeSize() == 1) {
                this.promoteReg(regPair2);
            }
            if (this.mCurrentST.getExpType(ltExp.getRExp()).getAVRTypeSize() == 1) {
                this.promoteReg(regPair);
            }
            this.out.println("    cp    " + regPair2.lobitReg + ", " + regPair.lobitReg);
            this.out.println("    cpc   " + regPair2.hibitReg + ", " + regPair.hibitReg);
        }
        this.out.println("    brlt " + label2);
        this.out.println();
        this.out.println("    # load false");
        this.out.println(label + ":");
        this.out.println("    ldi     r24, 0");
        this.out.println("    jmp      " + label3);
        this.out.println();
        this.out.println("    # load true");
        this.out.println(label2 + ":");
        this.out.println("    ldi    r24, 1");
        this.out.println();
        this.out.println("    # push result of less than");
        this.out.println(label3 + ":");
        this.genStoreExp(ltExp, new RegPair("r24", null));
    }

    @Override
    public void inMainClass(MainClass mainClass) {
    }

    @Override
    public void outMainClass(MainClass mainClass) {
        try {
            InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream("avrF.rtl.s");
            this.out.println(this.convertStreamToString(inputStream));
            inputStream.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.out.flush();
    }

    @Override
    public void outMeggyCheckButton(MeggyCheckButton meggyCheckButton) {
        this.out.println();
        this.out.println("    ### MeggyCheckButton");
        this.out.println("    call    _Z16CheckButtonsDownv");
        ButtonLiteral buttonLiteral = (ButtonLiteral)meggyCheckButton.getExp();
        String string = buttonLiteral.getLexeme();
        if (string.equals("Meggy.Button.B")) {
            this.out.println("    lds    r24, Button_B");
        } else if (string.equals("Meggy.Button.A")) {
            this.out.println("    lds    r24, Button_A");
        } else if (string.equals("Meggy.Button.Up")) {
            this.out.println("    lds    r24, Button_Up");
        } else if (string.equals("Meggy.Button.Down")) {
            this.out.println("    lds    r24, Button_Down");
        } else if (string.equals("Meggy.Button.Left")) {
            this.out.println("    lds    r24, Button_Left");
        } else if (string.equals("Meggy.Button.Right")) {
            this.out.println("    lds    r24, Button_Right");
        } else {
            throw new InternalException("Fatal Error: unknown Button " + string + ". This should have been caught during lexing.");
        }
        Label label = new Label();
        Label label2 = new Label();
        Label label3 = new Label();
        this.out.println("    # if button value is zero, push 0 else push 1");
        this.out.println("    tst    r24");
        this.out.println("    breq   " + label);
        this.out.println(label2 + ":");
        this.out.println("    ldi    r24, 1");
        this.out.println("    jmp    " + label3);
        this.out.println(label + ":");
        this.out.println(label3 + ":");
        this.genStoreExp(meggyCheckButton, new RegPair("r24", null));
    }

    @Override
    public void outMeggyDelay(MeggyDelay meggyDelay) {
        this.out.println();
        this.out.println("    ### Meggy.delay() call");
        this.out.println("    # load delay parameter");
        RegPair regPair = this.genLoadExp(meggyDelay.getExp(), 24);
        this.genMoveReg(new RegPair("r24", "r25"), regPair);
        this.out.println("    call   _Z8delay_msj");
    }

    @Override
    public void outMeggyGetPixel(MeggyGetPixel meggyGetPixel) {
        this.out.println();
        this.out.println("    ### Meggy.getPixel(x,y) call");
        RegPair regPair = this.genLoadExp(meggyGetPixel.getYExp(), 22);
        this.genMoveReg(new RegPair("r22", null), regPair);
        regPair = this.genLoadExp(meggyGetPixel.getXExp(), 24);
        this.genMoveReg(new RegPair("r24", null), regPair);
        this.out.println("    call   _Z6ReadPxhh");
        this.genStoreExp(meggyGetPixel, new RegPair("r24", null));
    }

    @Override
    public void outMeggySetAuxLEDs(MeggySetAuxLEDs meggySetAuxLEDs) {
        this.out.println();
        this.out.println("    ### Meggy.setAuxLEDs(num) call");
        RegPair regPair = this.genLoadExp(meggySetAuxLEDs.getExp(), 24);
        this.genMoveReg(new RegPair("r24", "r25"), regPair);
        this.out.println("    call   _Z10SetAuxLEDsh");
    }

    @Override
    public void outMeggySetPixel(MeggySetPixel meggySetPixel) {
        this.out.println();
        this.out.println("    ### Meggy.setPixel(x,y,color) call");
        RegPair regPair = this.genLoadExp(meggySetPixel.getColor(), 20);
        this.genMoveReg(new RegPair("r20", null), regPair);
        regPair = this.genLoadExp(meggySetPixel.getYExp(), 22);
        this.genMoveReg(new RegPair("r22", null), regPair);
        regPair = this.genLoadExp(meggySetPixel.getXExp(), 24);
        this.genMoveReg(new RegPair("r24", null), regPair);
        this.out.println("    call   _Z6DrawPxhhh");
        this.out.println("    call   _Z12DisplaySlatev");
    }

    @Override
    public void outMeggyToneStart(MeggyToneStart meggyToneStart) {
        this.out.println();
        this.out.println("    ### Meggy.toneStart(tone, time_ms) call");
        RegPair regPair = this.genLoadExp(meggyToneStart.getDurationExp(), 22);
        this.genMoveReg(new RegPair("r22", "r23"), regPair);
        regPair = this.genLoadExp(meggyToneStart.getToneExp(), 24);
        this.genMoveReg(new RegPair("r24", "r25"), regPair);
        this.out.println("    call   _Z10Tone_Startjj");
    }

    @Override
    public void inMethodDecl(MethodDecl methodDecl) {
        Serializable serializable;
        int n;
        String string = methodDecl.getName();
        MethodSTE methodSTE = (MethodSTE)this.mCurrentST.lookup(string);
        this.mCurrentST.pushScope(string);
        string = methodSTE.getMunged();
        this.out.println();
        this.out.println("    .text");
        this.out.println(".global " + string);
        this.out.println("    .type  " + string + ", @function");
        this.out.println(string + ":");
        this.out.println("    push   r29");
        this.out.println("    push   r28");
        HashSet<Integer> hashSet = methodSTE.getUsedReg();
        this.mUsedRegArray = hashSet.toArray();
        for (n = 0; n < this.mUsedRegArray.length; ++n) {
            serializable = (Integer)this.mUsedRegArray[n];
            this.out.println("    push   r" + ((Integer)serializable + 1));
            this.out.println("    push   r" + serializable);
        }
        this.out.println("    # make space for locals and params");
        this.out.println("    ldi    r30, 0");
        for (n = 0; n < methodSTE.getVarNumBytes(); ++n) {
            this.out.println("    push   r30");
        }
        this.out.println();
        this.out.println("    # Copy stack pointer to frame pointer");
        this.out.println("    in     r28,__SP_L__");
        this.out.println("    in     r29,__SP_H__");
        n = 24;
        serializable = methodSTE.getParamList();
        Iterator iterator = serializable.iterator();
        this.out.println();
        this.out.println("    # save off parameters");
        while (iterator.hasNext()) {
            VarSTE varSTE = (VarSTE)iterator.next();
            this.genStoreVar(varSTE, new RegPair("r" + n, "r" + (n + 1)));
            n -= 2;
        }
        this.out.println("/* done with function " + string + " prologue */");
        this.out.println();
        this.out.flush();
    }

    @Override
    public void outMethodDecl(MethodDecl methodDecl) {
        int n;
        this.mCurrentST.popScope();
        String string = methodDecl.getName();
        MethodSTE methodSTE = (MethodSTE)this.mCurrentST.lookup(string);
        this.out.println();
        this.out.println("/* epilogue start for " + methodSTE.getMunged() + " */");
        if (methodDecl.getExp() != null) {
            this.out.println("    # handle return value");
            RegPair regPair = new RegPair("r24", "r25");
            this.genMoveReg(regPair, this.genLoadExp(methodDecl.getExp(), 24));
            if (this.mCurrentST.getExpType(methodDecl.getExp()).getAVRTypeSize() == 1) {
                this.promoteReg(regPair);
            }
        } else {
            this.out.println("    # no return value");
        }
        this.out.println("    # pop space off stack for parameters and locals");
        for (n = 0; n < methodSTE.getVarNumBytes(); ++n) {
            this.out.println("    pop    r30");
        }
        for (n = this.mUsedRegArray.length - 1; n >= 0; --n) {
            Integer n2 = (Integer)this.mUsedRegArray[n];
            this.out.println("    pop   r" + n2);
            this.out.println("    pop   r" + (n2 + 1));
        }
        this.out.println("    # restoring the frame pointer");
        this.out.println("    pop    r28");
        this.out.println("    pop    r29");
        this.out.println("    ret");
        this.out.println("    .size " + methodSTE.getMunged() + ", .-" + methodSTE.getMunged());
        this.out.println();
        this.out.flush();
    }

    @Override
    public void outMinusExp(MinusExp minusExp) {
        RegPair regPair = this.genLoadExp(minusExp.getRExp(), 18);
        RegPair regPair2 = this.genLoadExp(minusExp.getLExp(), 24);
        if (this.mCurrentST.getExpType(minusExp.getLExp()) == Type.BYTE) {
            this.promoteReg(regPair2);
        }
        if (this.mCurrentST.getExpType(minusExp.getRExp()) == Type.BYTE) {
            this.promoteReg(regPair);
        }
        this.out.println();
        this.out.println("    # Do INT sub operation");
        this.out.println("    sub    " + regPair2.lobitReg + ", " + regPair.lobitReg);
        this.out.println("    sbc    " + regPair2.hibitReg + ", " + regPair.hibitReg);
        this.out.println("    # push hi order byte first");
        this.out.flush();
        this.genStoreExp(minusExp, regPair2);
    }

    @Override
    public void outMulExp(MulExp mulExp) {
        this.out.println();
        this.out.println("    # MulExp");
        RegPair regPair = this.genLoadExp(mulExp.getRExp(), 18);
        RegPair regPair2 = this.genLoadExp(mulExp.getLExp(), 22);
        RegPair regPair3 = new RegPair("r24", null);
        RegPair regPair4 = new RegPair("r26", null);
        this.genMoveReg(regPair3, regPair);
        this.genMoveReg(regPair4, regPair2);
        this.out.println();
        this.out.println("    # Do mul operation of two input bytes");
        this.out.println("    muls   " + regPair3.lobitReg + ", " + regPair4.lobitReg);
        this.genStoreExp(mulExp, new RegPair("r0", "r1"));
        this.out.println("    # clear r0 and r1, thanks Brendan!");
        this.out.println("    eor    r0,r0");
        this.out.println("    eor    r1,r1");
        this.out.flush();
    }

    public void promoteReg(RegPair regPair) {
        Label label = new Label();
        Label label2 = new Label();
        this.out.println("    # promoting a byte to an int");
        this.out.println("    tst     " + regPair.lobitReg);
        this.out.println("    brlt     " + label);
        this.out.println("    ldi    " + regPair.hibitReg + ", 0");
        this.out.println("    jmp    " + label2);
        this.out.println(label + ":");
        this.out.println("    ldi    " + regPair.hibitReg + ", hi8(-1)");
        this.out.println(label2 + ":");
        this.out.flush();
    }

    @Override
    public void outNewArrayExp(NewArrayExp newArrayExp) {
        this.out.println();
        this.out.println("    ### NewArrayExp, allocating a new array");
        this.out.println("    # loading array size in elements");
        RegPair regPair = this.genLoadExp(newArrayExp.getExp(), 26);
        if (this.mCurrentST.getExpType(newArrayExp.getExp()) == Type.BYTE) {
            this.promoteReg(regPair);
        }
        this.out.println("    # since num elems might be in caller-saved registers");
        this.out.println("    # need to push num elems onto the stack around call to malloc");
        this.out.println("    # if had three-address code reg alloc could work around this");
        this.out.println("    push   " + regPair.hibitReg);
        this.out.println("    push   " + regPair.lobitReg);
        if (this.mCurrentST.getExpType(newArrayExp) == Type.INT_ARRAY) {
            this.out.println("    # add size in elems to self to multiply by 2");
            this.out.println("    # complements of Jason Mealler");
            this.out.println("    add    " + regPair.lobitReg + "," + regPair.lobitReg);
            this.out.println("    adc    " + regPair.hibitReg + "," + regPair.hibitReg);
        }
        this.out.println("    # need bytes for elems + 2 in bytes");
        this.out.println("    ldi    r24, 2");
        this.out.println("    ldi    r25, 0");
        this.out.println("    add    r24," + regPair.lobitReg);
        this.out.println("    adc    r25," + regPair.hibitReg);
        this.out.println("    # call malloc, it expects r25:r24 as input");
        this.out.println("    call   malloc");
        this.out.println("    # set .length field to number of elements");
        this.out.println("    mov    r31, r25");
        this.out.println("    mov    r30, r24");
        this.out.println("    pop    " + regPair.lobitReg);
        this.out.println("    pop    " + regPair.hibitReg);
        this.out.println("    std    Z+0," + regPair.lobitReg);
        this.out.println("    std    Z+1," + regPair.hibitReg);
        this.out.println("    # store object address");
        this.genStoreExp(newArrayExp, new RegPair("r30", "r31"));
        this.out.flush();
    }

    @Override
    public void outNewExp(NewExp newExp) {
        int n = Type.getClassType(newExp.getId()).getClassInstanceSize();
        this.out.println();
        this.out.println("    # NewExp");
        this.out.println("    ldi    r24, lo8(" + n + ")");
        this.out.println("    ldi    r25, hi8(" + n + ")");
        this.out.println("    # allocating object of size " + n + " on heap");
        this.out.println("    call    malloc");
        this.out.println("    # push object address");
        this.genStoreExp(newExp, new RegPair("r24", "r25"));
        this.out.flush();
    }

    @Override
    public void outNegExp(NegExp negExp) {
        if (this.mCurrentST.getExpType(negExp.getExp()) == Type.INT) {
            this.out.println();
            this.out.println("    # neg int");
            RegPair regPair = this.genLoadExp(negExp.getExp(), 24);
            RegPair regPair2 = new RegPair("r22", "r23");
            this.out.println("    ldi     " + regPair2.lobitReg + ", 0");
            this.out.println("    ldi     " + regPair2.hibitReg + ", 0");
            this.out.println("    sub     " + regPair2.lobitReg + ", " + regPair.lobitReg);
            this.out.println("    sbc     " + regPair2.hibitReg + ", " + regPair.hibitReg);
            this.genStoreExp(negExp, regPair2);
        } else if (this.mCurrentST.getExpType(negExp.getExp()) == Type.BYTE) {
            this.out.println();
            this.out.println("    # neg byte");
            RegPair regPair = this.genLoadExp(negExp.getExp(), 24);
            RegPair regPair3 = new RegPair("r22", "r23");
            this.promoteReg(regPair);
            this.out.println("    ldi    " + regPair3.lobitReg + ", 0");
            this.out.println("    ldi    " + regPair3.hibitReg + ", 0");
            this.out.println("    sub     " + regPair3.lobitReg + ", " + regPair.lobitReg);
            this.out.println("    sbc     " + regPair3.hibitReg + ", " + regPair.hibitReg);
            this.genStoreExp(negExp, regPair3);
        } else {
            throw new InternalException("Fatal Error: invalid type for Neg . This should have been caught during Type Checking.");
        }
    }

    @Override
    public void outNotExp(NotExp notExp) {
        this.out.println();
        this.out.println("    # not operation");
        RegPair regPair = this.genLoadExp(notExp.getExp(), 24);
        this.out.println("    ldi     r22, 1");
        this.out.println("    eor     " + regPair.lobitReg + ",r22");
        this.genStoreExp(notExp, regPair);
    }

    @Override
    public void outPlusExp(PlusExp plusExp) {
        RegPair regPair = this.genLoadExp(plusExp.getRExp(), 18);
        RegPair regPair2 = this.genLoadExp(plusExp.getLExp(), 24);
        if (this.mCurrentST.getExpType(plusExp.getLExp()) == Type.BYTE) {
            this.promoteReg(regPair2);
        }
        if (this.mCurrentST.getExpType(plusExp.getRExp()) == Type.BYTE) {
            this.promoteReg(regPair);
        }
        this.out.println();
        this.out.println("    # Do add operation");
        this.out.println("    add    " + regPair2.lobitReg + ", " + regPair.lobitReg);
        this.out.println("    adc    " + regPair2.hibitReg + ", " + regPair.hibitReg);
        this.out.flush();
        this.genStoreExp(plusExp, regPair2);
    }

    @Override
    public void outProgram(Program program) {
        this.out.flush();
    }

    @Override
    public void outThisExp(ThisLiteral thisLiteral) {
        this.out.println();
        if (this.mCurrentClass == null) {
            throw new InternalException("outThisExp: mCurrentClass==null");
        }
        this.genLoadThis();
        RegPair regPair = new RegPair("r30", "r31");
        this.genStoreExp(thisLiteral, regPair);
        this.out.flush();
    }

    @Override
    public void outToneExp(ToneLiteral toneLiteral) {
        String string = toneLiteral.getLexeme();
        int n = toneLiteral.getIntValue();
        this.out.println();
        this.out.println("    # Push " + string + " onto the stack.");
        this.out.println("    ldi    r25, hi8(" + n + ")");
        this.out.println("    ldi    r24, lo8(" + n + ")");
        RegPair regPair = new RegPair("r24", "r25");
        this.genStoreExp(toneLiteral, regPair);
    }

    @Override
    public void outToneType(ToneType toneType) {
    }

    @Override
    public void inTopClassDecl(TopClassDecl topClassDecl) {
        this.mCurrentClass = (ClassSTE)this.mCurrentST.lookup(topClassDecl.getName());
        this.mCurrentST.pushScope(topClassDecl.getName());
    }

    @Override
    public void outTopClassDecl(TopClassDecl topClassDecl) {
        this.mCurrentST.popScope();
        Type type = Type.getClassType(topClassDecl.getName());
        type.setClassInstanceSize(this.class_offset);
        this.class_offset = 0;
    }

    @Override
    public void outTrueExp(TrueLiteral trueLiteral) {
        this.out.println();
        this.out.println("    # True/1 expression");
        this.out.println("    ldi    r22, 1");
        RegPair regPair = new RegPair("r22", null);
        this.genStoreExp(trueLiteral, regPair);
    }

    @Override
    public void outVoidType(VoidType voidType) {
    }

    @Override
    public void outVarDecl(VarDecl varDecl) {
    }

    @Override
    public void visitWhileStatement(WhileStatement whileStatement) {
        Label label = new Label();
        Label label2 = new Label();
        Label label3 = new Label();
        this.out.println();
        this.out.println("    #### while statement");
        this.out.println(label + ":");
        if (whileStatement.getExp() != null) {
            whileStatement.getExp().accept(this);
        }
        this.out.println();
        this.out.println("    # if not(condition)");
        RegPair regPair = this.genLoadExp(whileStatement.getExp(), 24);
        this.out.println("    ldi    r25,0");
        this.out.println("    cp     " + regPair.lobitReg + ", r25");
        this.out.println("    # WANT breq " + label3);
        this.out.println("    brne   " + label2);
        this.out.println("    jmp    " + label3);
        this.out.println();
        this.out.println("    # while loop body");
        this.out.println(label2 + ":");
        if (whileStatement.getStatement() != null) {
            whileStatement.getStatement().accept(this);
        }
        this.out.println();
        this.out.println("    # jump to while test");
        this.out.println("    jmp    " + label);
        this.out.println();
        this.out.println("    # end of while");
        this.out.println(label3 + ":");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String convertStreamToString(InputStream inputStream) {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        StringBuilder stringBuilder = new StringBuilder();
        String string = null;
        try {
            while ((string = bufferedReader.readLine()) != null) {
                stringBuilder.append(string + "\n");
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return stringBuilder.toString();
    }

    private class RegPair {
        public String lobitReg;
        public String hibitReg;

        public RegPair(String string, String string2) {
            this.lobitReg = string;
            this.hibitReg = string2;
        }
    }
}

