/*********************************************************/
#include	<std.h>
#include	<rt11.h>
#include	<mmmhdr.h>

/*********************************************************/
/* external functions from supprt      *******************/
FILE	getifile(),getofile();
int	link(),initnode();

/*********************************************************/
/* external functions from mmmcli      *******************/
int	illcom(),quit(),ambcom();

/*********************************************************/
/* external functions from diolib      *******************/
long	getpos();
int	dread(),dwrite(),dlseek();
FILE	dclose();

/*********************************************************/
/* external functions from genlib      *******************/
TEXTPTR	getstr();
int	srchtab(),lsttab();

/*********************************************************/
/* entry points        ***********************************/
int	edtext(),disptx();

/*********************************************************/
/* This is the Text editor */

/* command table */
#define	MAXCOM  5
static TEXTPTR	comtab[MAXCOM] =
	{ "QUIT","INPUT","DISPLAY","?","ADDFILE"};

/* function address table */
static	PFI	functab[] = 
	{ &quit,&input,&show,&lsttcoms,&addfile,
	&illcom,&ambcom };
static	int	comquit = 0;

/*********************************************************/
/* external globals */
TEXT	errtyp[] ;	/* all from mmmcli */
TEXT	linbuf[] ;
TEXT	filenam[];
TEXT	opnerr[];
FILE	fd;
TREEPTR top,mtop;

/*********************************************************/
/* command interpreter for text editor. Sorts table on entry
   then calls command handler for each user command */

edtext()
{
int	command ;

sorttab(comtab,functab,MAXCOM);
comquit = srchtab(comtab,MAXCOM,"QUIT");

if ( top && (top->alg != 3) ) {
	putstr(STDERR,errtyp,NULL);
	return;
	}		/* probably is a page containing image */

putstr(STDOUT,"welcome to the text editor...\n",NULL);
do	{
	getstr(">",linbuf);
	command = srchtab(comtab,MAXCOM,linbuf);
	INDCALL(functab[command]);
	}
while (command != comquit );

} 	/* of main */



/*********************************************************/
/* list all commands */
lsttcoms()
{
lsttab(comtab,MAXCOM);
}

/*********************************************************/
/* if there is no top ( new page ) then create one and
   link it to mtop */
textop()
{

if ( !top) {
	if ( (top = getnode() ) == NULL) return;
	initnode(top);
	link(mtop,top);
	top->alg = 3;
	}
}

/*********************************************************/
/* add contents of text file to current page . File name
   is prompted for . Entire file is entered as one paragraph (?)
   Segment contains pointer to text file */

addfile()
{
TREEPTR	node;

textop();
if ( (fd = getifile(filenam,"TXT")) < 0) return;
if ( !(node = getnode() ) ) return;
initnode(node);
link(top,node);		/* this is another para of present page */
cpystr(node->filnam,filenam,NULL);
node->segxsiz=fndflen(fd);  /* find length of file */
dclose(fd);

}

/*********************************************************/
/* enters text typed on keyboard. Text is stored in an 
   output file (prompted for ). Each para. is signaled by user
   by typing <CR>.p<CR> ; end of text is signaled by <CR>.e<CR> .
   each para. is stored as separate segment with pointers to file */
input()

{
int	n;
TREEPTR	node;
TEXT	*s;

textop();
if ( (fd = getofile(filenam,"TXT")) < 0) return;
putstr(STDOUT,"o.k. type on, use .p to begin new para,",
	" .e  to end text\n",NULL);

for (n =getlin(linbuf,80); !cmpbuf(linbuf,".e\n",3) ; ){
	if ( (node = getnode() )  == NULL) return;
	initnode(node);
	node -> filptr = getpos(fd);
	link(top,node);
	cpystr(node->filnam,filenam,NULL);
	for( ; (!cmpbuf(linbuf,".p\n",3)) && (!cmpbuf(linbuf,".e\n",3)) ;
		 n = getlin(linbuf,80) ){
		node->segxsiz += n;
		dwrite(fd,linbuf,n);
		}
	if (cmpbuf(linbuf,".p\n",3) ) {
		putstr(STDOUT,"\n",NULL);
		 n = getlin(linbuf,80);
		}
	}
dclose(fd);
}
	
/*********************************************************/
/* display contents of current page */
show()

{
disptx(top);
}

/******************************************************/
/* display contents of text node pointed to by parameter
   top */
disptx(top)
TREEPTR	top;
{
int	n;
TREEPTR	node;

for (node = top->lptr; node ; node = node->rptr){
	if((fd = dopen(node->filnam,0,1)) < 0 ) {
		putstr(STDERR,opnerr,NULL);
		return;
		}

	dlseek(fd,node->filptr,0);
	for(n = node->segxsiz;n > 0; ){
		if (n >= 80) linbuf[dread(fd,linbuf,80)] = NULL;
		else	linbuf[dread(fd,linbuf,n)] = NULL;
		n -= 80;
		putstr(STDOUT,linbuf,NULL);
		}
	putstr(STDOUT,"\n",NULL);
	dclose(fd);
	}
}
                                                                                                                                                                                                                                                                                                                         