#include <stdio.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netdb.h>
#include <netinet/in.h>
#include <sys/time.h>
#include <potpourri.h>

#include "ncs.h"

unsigned char Arrived[ARRAYLEN]; 	/* Bit[i] == 1 means packet i arrived */
/* Total = Good + Duplicate + OutOfSequence*/
int Good;
int Duplicate;
int OutOfSequence;
int Random;	/* Different uniquefier */

int VerboseFlag;
int HighestSeqNo;
int ThisUnique;

struct sockaddr_in PSAddr;		/* server address */
struct sockaddr_in PCAddr;		/* client address */
short PSPort = SERVERPORT;		/* My Internet port number */
int PSock;	/* socket */
struct Packet *PBuff;

main(argc, argv)
    int argc;
    char *argv[];
    {
    register int i;
    struct timeval t1, t2;
    
    for (i = 1; i < argc; i++)
	{
	if (strcmp(argv[i], "-p") == 0 && ++i < argc)
	    {
	    PSPort = atoi(argv[i]);
	    continue;
	    }
	if (strcmp(argv[i], "-v") == 0)
	    {
	    VerboseFlag++;
	    continue;
	    }
	BadArgs();
	}

    PBuff = (struct Packet *)malloc(MAXLENGTH);

    while(1)
	{
	InitGlobals();
	InitNet();
	WaitStart();
	gettimeofday(&t1, 0);
	RecvPackets();
	gettimeofday(&t2, 0);
	PrintStats((t2.tv_sec-t1.tv_sec)*1000 + (t2.tv_usec-t1.tv_usec)/1000);
	}

    }


InitNet()
    {
    /* Allocate client socket */
    if ((PSock = socket(AF_INET, SOCK_DGRAM, IPPROTO_UDP)) < 0)
	{
	perror("PSock");
	exit(-1);
	}

    /* set massive buffer size for this socket */
#ifdef SO_GREEDY
    if (setsockopt(PSock, SOL_SOCKET, SO_GREEDY, 0, 0) != 0 && VerboseFlag)
	perror("WARNING: SO_GREEDY");
#else
    if (VerboseFlag)
	fprintf(stderr, "WARNING: SO_GREEDY undefined\n");
#endif

    /*	Now bind to server port. */
    PSAddr.sin_addr.s_addr = INADDR_ANY;
    PSAddr.sin_port = htons(PSPort);
    if (bind (PSock, &PSAddr, sizeof(PSAddr)) != 0)
	{
	perror("PSock");
	exit(-1);
	}
    }


WaitStart()
    {
    int plen,y;
    unsigned int x;

    do
	{
	plen = sizeof(PCAddr);
	if (recvfrom(PSock, PBuff, MAXLENGTH, 0, &PCAddr, &plen) < 0)
	    {
	    perror("PSock");
	    exit(-1);
	    }
	y = ntohl(PBuff->Uniquefier);
	if (y != ThisUnique && PBuff->SeqNo == 0) break;
	if (VerboseFlag && y != ThisUnique)printf("?");
	}
    while (1);
    
    HighestSeqNo = 0;
    ThisUnique = y;
    Good = 1;
    SETBIT(Arrived, 0);
    if (VerboseFlag)PrintInetAddress("#");
    }

RecvPackets()
    {
    register int u, sn;
    int plen;

    plen = sizeof(PCAddr);
    while(1)
	{
	if (recvfrom(PSock, PBuff, MAXLENGTH, 0, &PCAddr, &plen) < 0)
	    {
	    perror("PSock");
	    exit(-1);
	    }
	u = ntohl(PBuff->Uniquefier);
	sn = ntohl(PBuff->SeqNo);

	if (u != ThisUnique || sn >= MAXPACKETS) 
	    {
	    if (VerboseFlag) printf("?");
	    Random++;
	    continue;
	    }
	
	if (sn == STOP) break;

	if (TESTBIT(Arrived, sn)) Duplicate++;
	else
	    {
	    if (VerboseFlag) {printf("#"); fflush(stdout);}
	    if (sn < HighestSeqNo) OutOfSequence++;
	    else
		{
		Good++;
		HighestSeqNo = sn;
		}
	    SETBIT(Arrived, sn);
	    }
	}
    Good++;	/* for STOP packet */
    }




InitGlobals()
    {
    if (PSock) close(PSock);	/* throws away extra STOP packets */
    Good = Duplicate = OutOfSequence = Random = HighestSeqNo = 0;	/* But not Uniquefier */
    bzero(Arrived, ARRAYLEN);
    }

BadArgs()
    {
    printf("Usage: ns [-p serverport] [-v]\n");
    exit(-1);
    }
    

PrintStats(t)
    int t;
    {
    printf("\n%d total packets received in %d milliseconds\n", Good+Duplicate+OutOfSequence+Random, t);
    printf("\tGood %d    Duplicate %d    OutOfSequence %d    Random %d\n\n",
    	Good, Duplicate, OutOfSequence, Random);
    }



PrintInetAddress(s)
    char *s;
    {
    unsigned int x;
    x = (unsigned int) ntohl(PCAddr.sin_addr.s_addr);
    printf("%d.%d.%d.%d: %s", (x & 0xff000000) >> 24, (x & 0x00ff0000) >> 16, (x & 0x0000ff00) >> 8, 
	    (x & 0x000000ff), s);
    fflush(stdout);
    }
