function [TR,E] = hmm_ML(seqs,labels,NofStates,NofEmission)

    TR = zeros(NofStates);      E = zeros(NofStates,NofEmission);
    
    for seq_ind = 1:length(seqs)
        seq = seqs{seq_ind};        label = labels{seq_ind};
        
        for i = 2:length(seq)
            emission_ind = seq(i);
            transition_ind_1 = label(i-1);    transition_ind_2 = label(i);
            
            TR(transition_ind_1,transition_ind_2) = TR(transition_ind_1,transition_ind_2)+ 1;
            E(transition_ind_2,emission_ind) = E(transition_ind_2,emission_ind)+ 1;
        end
        
    end
    TR = matrixNorm(TR);
    E = matrixNorm(E);
    
end