% Datasets and code for "A New Algorithm to Train Hidden MarkovModels for Biological Sequences with PartialLabels"
% Jiefu Li, Jung-Youn Lee, and Li Liao

%% what is in here:
% \HMMPartialLabel_Functions: 
%      include implementations of both our method and other (compared) method.
% \ExperimentsResultsInManuscript:
%      include results saved as .mat for the experiments in the manuscript.
% \ExperimentsInManuscript:
%      include .m files to generate results of above.
% \tool : contains functions necessary to repeat the whole experiments
% \data : contains transmembrane protein data and label.

%% How to use:
% 0. Add pathes of folders: HMMPartialLabel_Functions, tool, and data. 
% 1. Experiemnts using synthetic 
% To run synthetic experiemnts, use: 
%   run: \ExperimentsInManuscript\HMMPL_DecodingExpScript_definedCM.m
%   it save .mat files automatically.
% To view the GRAPHIC results:
%   load the .mat file, then, run\ExperimentsInManuscript\ ShowResults_Decoding.m
% To view the NUMERIC results:
%   load the .mat file, then, check variable: Result_all_Acc_mean, each row indicate different methods, column indicates different easy level. 
%   Result_all_Acc_mean(1,:)Other method
%   Result_all_Acc_mean(3,:)cBW + model selection
%   Result_all_Acc_mean(4,:)cBW alone
%   Result_all_Acc_mean(5,:)ground truth model
%   Note: Result_all_Acc_mean(2,:) is also our method but not shown in manuscript
% If one want to run experiemnts with fully initial guess.
%   Open HMMPL_Decoding_CM.m and uncomment line 17

% 2. Experiemnts using transmembrane data 
% To run transmembrane data  experiemnts, use: 
%   run: \ExperimentsInManuscript\TM_PartialLabel_DecodningAccuracy.m
% GRAPHIC results shows automatically:
% NUMERIC results:
%   check variable: Result_all_Acc_mean, each row indicate different methods, column indicates different easy level. 
%   Result_all_Acc_mean(1,:)Other method
%   Result_all_Acc_mean(3,:)cBW + model selection
%   Result_all_Acc_mean(4,:)cBW alone
%   Result_all_Acc_mean(5,:)ground truth model
%   Note: Result_all_Acc_mean(2,:) is also our method but not shown in manuscript
% If one want to run experiemnts with fully initial guess.
%   Open TM_PartialLabel_DecodningAccuracy.m and uncomment line 8







