function [guessTR,guessE,logliks] = HMMPL_Other(seqs,labels,guessTR,guessE)
    
tol = 1e-6;

maxiter = 500;

[numStates, checkTr] = size(guessTR);
if checkTr ~= numStates
    error(message('BadTransitions'));
end

[checkE, numEmissions] = size(guessE);
if checkE ~= numStates
    error(message('Mismatch of guessTR and guessE'));
end

numSeqs = numel(seqs);

% initialize TR and E counts.
TR = zeros(size(guessTR));
E = zeros(numStates,numEmissions);

converged = false;
loglik = 1; % loglik is the log likelihood of all sequences given the TR and E
logliks = zeros(1,maxiter);
for iteration = 1:maxiter
    oldLL = loglik;
    loglik = 0;
    oldGuessE = guessE;
    oldGuessTR = guessTR;
    for count = 1:numSeqs

        seq = seqs{count};
        label = labels{count};
        seqLength = length(seq);

            
        % get the scaled forward and backward probabilities
        [~,logPseq,fs,bs,scale] = hmmdecode(seq,guessTR,guessE);
        loglik = loglik + logPseq;
        logf = log(fs);
        logb = log(bs);
        logs = log(scale);
        logGE = log(guessE);
        logGTR = log(guessTR);
        pStates = fs.*bs;

        % f and b start at 0 so offset seq by one
        seq = [0 seq];
        label = [0 label];

        for k = 1:numStates
            [LabelState] = find(label == k);
            otherK = 1:numStates;                 otherK = otherK(otherK~=k);
            pStates(k,LabelState) = 0;            pStates(otherK,LabelState) = -inf;
        end
            
        for k = 1:numStates
%                 denom = sum(exp(pStates(k,1:end)));
            denom = 1;
            for l = 1:numStates
                for i = 1:seqLength
                    if label(i) == 0
                        % What gamma_a really is:
                        % exp( logf(k,i) + logb(k,i) -  logPseq + sum (logs(1:i)) + sum(logs(i+1:end)) );
                        gamma_a = exp( logf(k,i) + logb(k,i) );
                    else
                        if label(i) == k
                            gamma_a = 1;
                        else
                            gamma_a = 0;
                        end
                    end
                    if label(i+1) == 0
                        % What gamma_b really is:
                        % exp( logGTR(k,l) + logGE(l,seq(i+1)) + logb(l,i+1) + sum(logs(i+2:end)) - logb(k,i) - sum(logs(i+1:end))  )
                        % = exp( logGTR(k,l) + logGE(l,seq(i+1)) + logb(l,i+1) - logb(k,i) - logs(i+1))
                        gamma_b = exp( logGTR(k,l) + logGE(l,seq(i+1)) + logb(l,i+1) - logb(k,i) )./scale(i+1);
                    else
                        if label(i+1) == l
                            gamma_b = 1;
                        else
                            gamma_b = 0;
                        end
                    end
                    TR(k,l) = TR(k,l) + gamma_a*gamma_b/denom;
                end
            end
        end


        for k = 1:numStates
            for i = 1:numEmissions
                pos = find(seq == i);
                E(k,i) = E(k,i) + sum(exp(pStates(k,pos)));
            end
        end
  
    end
    totalEmissions = sum(E,2);
    totalTransitions = sum(TR,2);
    
    % avoid divide by zero warnings
    guessE = E./(repmat(totalEmissions,1,numEmissions));
    guessTR  = TR./(repmat(totalTransitions,1,numStates));
    % if any rows have zero transitions then assume that there are no
    % transitions out of the state.
    if any(totalTransitions == 0)
        noTransitionRows = find(totalTransitions == 0);
        guessTR(noTransitionRows,:) = 0;
        guessTR(sub2ind(size(guessTR),noTransitionRows,noTransitionRows)) = 1;
    end
    % clean up any remaining Nans
    guessTR(isnan(guessTR)) = 0;
    guessE(isnan(guessE)) = 0;
    
    % Check convergence.
    logliks(iteration) = loglik;
    if (abs(loglik-oldLL)/(1+abs(oldLL))) < tol
        if norm(guessTR - oldGuessTR,inf)/numStates < tol
            if norm(guessE - oldGuessE,inf)/numEmissions < tol
                 converged = true;
                break
            end
        end
    end
    TR = zeros(size(guessTR));
    E = zeros(numStates,numEmissions); 
end
if ~converged
    warning(message('stats:hmmtrain:NoConvergence', num2str( tol ), maxiter));
end
logliks(logliks ==0) = [];
