function [pStates,pSeq, f, b, s] = HMMDecode_PartialLabel(seq,lbl,TR,E)
    [numOfStates,~] = size(E);
    seq = [0,seq];      lbl = [0,lbl];
    seqLen = length(seq);
    
    f = zeros(numOfStates, seqLen);       f(:,1) = 1/numOfStates;
    s = zeros(1,seqLen);                  s(1) = 1;
    
    % compute forward matrix
    for count = 2:seqLen
        % all has label.
        if lbl(count - 1) ~= 0 && lbl(count) ~= 0
            temp = E(lbl(count),seq(count)) .* (sum(f(lbl(count-1),count-1) .* TR(lbl(count-1),lbl(count))));
            f(lbl(count),count) = temp;
        end
        % count - 1 has lable, count has no label.
        if lbl(count - 1) ~= 0 && lbl(count) == 0
            for state = 1:numOfStates
                f(state,count) = E(state,seq(count)) .* (sum(f(lbl(count-1),count-1) .*TR(lbl(count-1),state)));
            end
        end
        % count - 1 has no lable, count has label.
        if lbl(count - 1) == 0 && lbl(count) ~= 0
            f(lbl(count),count) = E(lbl(count),seq(count)) .* (sum(f(:,count-1) .*TR(:,lbl(count))));
        end
        % all has no label.
        if lbl(count - 1) ==0 && lbl(count) ==0
            for state = 1:numOfStates
                f(state,count) = E(state,seq(count)) .* (sum(f(:,count-1) .*TR(:,state)));
            end        
        end
        s(count) = sum(f(:,count));       f(:,count) = f(:,count)./s(count);
    end
    
    b = zeros(numOfStates, seqLen);     b(:,end) = 1;
    % compute backward matrix
    for count = seqLen -1: -1 : 1
        % count has label, count+1 has lable.
        if lbl(count + 1) ~= 0 && lbl(count) ~= 0
            temp = sum( TR( lbl(count),lbl(count+1))'.* b(lbl(count+1),count+1) .* E(lbl(count+1),seq(count+1)));
            b(lbl(count),count) = (1/s(count+1))*temp;
        end
        % count has no label, count+1 has lable.
        if lbl(count + 1) ~= 0 && lbl(count) == 0
            for state = 1:numOfStates
              b(state,count) = (1/s(count+1)) * sum( TR(state,lbl(count+1))'.* b(lbl(count+1),count+1) .* E(lbl(count+1),seq(count+1))); 
            end 
        end
        % count has label, count+1 has no lable.
        if lbl(count + 1) == 0 && lbl(count) ~= 0
            b(lbl(count),count) = (1/s(count+1)) * sum( TR(lbl(count),:)'.* b(:,count+1) .* E(:,seq(count+1))); 
        end
        % count has no label, count+1 has no lable.        
        if lbl(count + 1) == 0 && lbl(count) ==0
            for state = 1:numOfStates
              b(state,count) = (1/s(count+1)) * sum( TR(state,:)'.* b(:,count+1) .* E(:,seq(count+1))); 
            end 
        end
    end
    
    
    pSeq = sum(log(s));
    pStates = f.*b;

    % get rid of the column that we stuck in to deal with the f0 and b0 
    pStates(:,1) = [];
end