function [bestT1,bestE1,bestT2,bestE2,guessTR,guessE,logliks] = HMMBW_PartialLabel_EarlyStop(seqs,labels,guessTR,guessE)


tol = 1e-6;
maxiter = 500;

[numStates, checkTr] = size(guessTR);
if checkTr ~= numStates
    error(message('BadTransitions'));
end

[checkE, numEmissions] = size(guessE);
if checkE ~= numStates
    error(message('Mismatch of guessTR and guessE'));
end

numSeqs = numel(seqs);

TR = zeros(size(guessTR));
E = zeros(numStates,numEmissions); 

converged = false;
loglik = 1; % loglik is the log likelihood of all sequences given the TR and E
logliks = zeros(1,maxiter);

BestdecodingScore1 = 0;     decodingScore1 = 0;
BestdecodingScore2 = 0;     decodingScore2 = 0;

for iteration = 1:maxiter
    if decodingScore1 >= BestdecodingScore1
        bestT1 = guessTR;
        bestE1 = guessE;
        BestdecodingScore1 = decodingScore1;
    end
    
    if decodingScore2 > BestdecodingScore2
        bestT2 = guessTR;
        bestE2 = guessE;
        BestdecodingScore2 = decodingScore2;
    end

    oldLL = loglik;
    loglik = 0;
    oldGuessE = guessE;
    oldGuessTR = guessTR;
    
    decodingScore1 = 0;         decodingScore2 = 0;

    for count = 1:numSeqs
        seq = seqs{count};      label = labels{count};
        seqLength = length(seq);
                    
        % get the scaled forward and backward probabilities
        [~,logPseq,fs,bs,scale] = HMMDecode_PartialLabel(seq,label,guessTR,guessE);

        loglik = loglik + logPseq;
        logf = log(fs);
        logb = log(bs);
        logGE = log(guessE);
        logGTR = log(guessTR);
        % f and b start at 0 so offset seq by one
        seq = [0 seq];
        label = [0 label];
            
        try
            estimate_label = hmmviterbi(seq(2:end),guessTR,guessE);
        catch
            estimate_label = zeros(size(seq(2:end)));
        end
            
        estimate_label = [0 estimate_label];            
        for k = 1:numStates 
            [LabelState] = find(label == k);
            [estimate_LabelState] = find(estimate_label == k);
            decodingScore1 = decodingScore1 + length(intersect(LabelState,estimate_LabelState));
        end
        decodingScore2 = decodingScore1;

        for k = 1:numStates
            for l = 1:numStates
                for i = 1:seqLength
                    TR(k,l) = TR(k,l) + (exp( logf(k,i) + logGTR(k,l) + logGE(l,seq(i+1)) + logb(l,i+1))./scale(i+1));
                end
            end
        end
            
            
        for k = 1:numStates
            for i = 1:numEmissions
                pos = find(seq == i);
                E(k,i) = E(k,i) + sum(exp(logf(k,pos)+logb(k,pos)));
            end
        end

    end
    
    totalEmissions = sum(E,2);
    totalTransitions = sum(TR,2);
    
    % avoid divide by zero warnings
    guessE = E./(repmat(totalEmissions,1,numEmissions));
    guessTR  = TR./(repmat(totalTransitions,1,numStates));
    % if any rows have zero transitions then assume that there are no
    % transitions out of the state.
    if any(totalTransitions == 0)
        noTransitionRows = find(totalTransitions == 0);
        guessTR(noTransitionRows,:) = 0;
        guessTR(sub2ind(size(guessTR),noTransitionRows,noTransitionRows)) = 1;
    end
    % clean up any remaining Nans
    guessTR(isnan(guessTR)) = 0;
    guessE(isnan(guessE)) = 0;
    

    logliks(iteration) = loglik;
    if (abs(loglik-oldLL)/(1+abs(oldLL))) < tol
        if norm(guessTR - oldGuessTR,inf)/numStates < tol
            if norm(guessE - oldGuessE,inf)/numEmissions < tol
                converged = true;
                break
            end
        end
    end
    TR = zeros(size(guessTR));
    E = zeros(numStates,numEmissions); 
end
if ~converged
    warning(message('stats:hmmtrain:NoConvergence', num2str( tol ), maxiter));
end
logliks(logliks ==0) = [];
