function HMMPL_Decoding_CM(N,SymboLen,SeqLen,NofTrain,NofTest,maxIter,r_space,CM)

Result_all_Acc = cell(5,length(r_space));

for q = 1:maxIter
rng(q);
q

E_GT = rand(N,SymboLen);           E_GT = matrixNorm(E_GT);
T_GT = rand(N,N).*CM;              T_GT = matrixNorm(T_GT);

% Initial guess for all.
E_guess = rand(N,SymboLen);        E_guess = matrixNorm(E_guess);
T_guess = rand(N,N);

% uncomment if want correct transition guess.
% T_guess = T_guess.*CM;

T_guess = matrixNorm(T_guess);

Seq_Train = cell(1,NofTrain);       Lbl_Train = cell(1,NofTrain);     
for i = 1:NofTrain
    [seq_train,states_train] = hmmgenerate(SeqLen,T_GT,E_GT);
    Seq_Train{i} = seq_train;       Lbl_Train{i} = states_train;
end

Seq_Test = cell(1,NofTest);         Lbl_Test = cell(1,NofTest);     
for i = 1:NofTest
    [seq_test,states_test] = hmmgenerate(SeqLen,T_GT,E_GT);
    Seq_Test{i} = seq_test;         Lbl_Test{i} = states_test;
end


for rind = 1:length(r_space) 
    
    rind
    
    r = r_space(rind);
    Lbl_Train_temp = Lbl_Train;
    if r~= 0    
        for i = 1:length(Lbl_Train)
            ind = randperm(length(Lbl_Train_temp{i}));   ind = ind(1:round(r*length(ind)));
            Lbl_Train_temp{i}(ind) = 0;
        end
    end
    
    %% Other Method.
    [TR_other,E_other] = HMMPL_Other(Seq_Train,Lbl_Train_temp,T_guess,E_guess);
    myacc = 0;
    for j = 1:length(Seq_Test)
        try
            lbl_other = hmmviterbi(Seq_Test{j},TR_other,E_other);
        catch
            E_other = E_other + ones(size(E_other))*0.00001;           E_other = matrixNorm(E_other);
            lbl_other = hmmviterbi(Seq_Test{j},TR_other,E_other);
        end
        lbl_other = lbl_other - Lbl_Test{j};    ind = lbl_other(lbl_other == 0);    
        myacc = myacc + length(ind);
    end
    Result_all_Acc{1,rind} = [Result_all_Acc{1,rind}, myacc/(SeqLen*NofTest)];

    %%  our method alone.
    [TR_our1,E_our1,TR_our2,E_our2,TR_our3,E_our3] = HMMBW_PartialLabel_EarlyStop(Seq_Train,Lbl_Train_temp,T_guess,E_guess);
    myacc = 0;
    for j = 1:length(Seq_Test)
        try
             lbl_our = hmmviterbi(Seq_Test{j},TR_our1,E_our1);
        catch            
            TR_our1 = TR_our1 + ones(size(TR_our1))*0.00001;        TR_our1 = matrixNorm(TR_our1);
            E_our1 = E_our1 + ones(size(E_our1))*0.00001;           E_our1 = matrixNorm(E_our1);
            lbl_our = hmmviterbi(Seq_Test{j},TR_our1,E_our1);
        end
        lbl_our = lbl_our - Lbl_Test{j};    ind = lbl_our(lbl_our == 0);    
        myacc = myacc + length(ind);
    end
    Result_all_Acc{2,rind} = [Result_all_Acc{2,rind}, myacc/(SeqLen*NofTest)];

    myacc = 0;
    for j = 1:length(Seq_Test)
        try
            lbl_our = hmmviterbi(Seq_Test{j},TR_our2,E_our2);
        catch
            TR_our2 = TR_our2 + ones(size(TR_our2))*0.00001;        TR_our2 = matrixNorm(TR_our2);
            E_our2 = E_our2 + ones(size(E_our2))*0.00001;           E_our2 = matrixNorm(E_our2);
            lbl_our = hmmviterbi(Seq_Test{j},TR_our2,E_our2);
        end
        lbl_our = lbl_our - Lbl_Test{j};    ind = lbl_our(lbl_our == 0);    
        myacc = myacc + length(ind);
    end
    Result_all_Acc{3,rind} = [Result_all_Acc{3,rind}, myacc/(SeqLen*NofTest)];

    myacc = 0;
    for j = 1:length(Seq_Test)
        try
            lbl_our = hmmviterbi(Seq_Test{j},TR_our3,E_our3);
        catch
            TR_our3 = TR_our3 + ones(size(TR_our3))*0.00001;        TR_our3 = matrixNorm(TR_our3);
            E_our3 = E_our3 + ones(size(E_our3))*0.00001;           E_our3 = matrixNorm(E_our3);
            lbl_our = hmmviterbi(Seq_Test{j},TR_our3,E_our3);
        end
        lbl_our = lbl_our - Lbl_Test{j};    ind = lbl_our(lbl_our == 0);    
        myacc = myacc + length(ind);
    end
    Result_all_Acc{4,rind} = [Result_all_Acc{4,rind}, myacc/(SeqLen*NofTest)];
    
    %% With GT model.
    myacc = 0;
    for j = 1:length(Seq_Test)
        lbl_gt = hmmviterbi(Seq_Test{j},T_GT,E_GT);
        lbl_gt = lbl_gt - Lbl_Test{j};    ind = lbl_gt(lbl_gt == 0);    
        myacc = myacc + length(ind);
    end
    Result_all_Acc{5,rind} = [Result_all_Acc{5,rind}, myacc/(SeqLen*NofTest)];
    
end
    
end

Result_all_Acc_mean = zeros(5,length(r_space));
Result_all_Acc_pvalue = ones(3,length(r_space));
for i = 1:length(r_space)
    for j = 1:5
        Result_all_Acc_mean(j,i) = mean(Result_all_Acc{j,i} );  
    end
    
    cmp_Acc = Result_all_Acc{1,i};
    for j = 2:4
        x = Result_all_Acc{j,i};
        [~,p] = ttest(x,cmp_Acc);
        Result_all_Acc_pvalue(j-1,i) = p;        
    end
end

improvements = zeros(1,3);
cmp_mean_Acc = Result_all_Acc_mean(1,:);
for j = 2:4
   improve = mean((Result_all_Acc_mean(j,:) - cmp_mean_Acc)./cmp_mean_Acc);
   improve = improve*100;
   improvements(j-1) = improve;
end

% filename = ['HMMPLDecoding_CorrectCM',num2str(N),'_',num2str(SymboLen),'_',num2str( round(SeqLen*NofTrain/10) ),'.mat'];
filename = ['HMMPLDecoding_FullyGuess',num2str(N),'_',num2str(SymboLen),'_',num2str( round(SeqLen*NofTrain/10) ),'.mat'];

save(filename);

end