import os
import shutil
import tensorflow as tf
from ae.utils.flags_ppi import FLAGS, home_out
import ae.autoencoder_ppi as autoencoder
from ae.utils.start_tensorboard_ppi import start
from ae.utils.data_ppi import read_data_sets
from ae.utils.data_ppi import simulation_data_sets

_data_dir = FLAGS.data_dir
_summary_dir = FLAGS.summary_dir
_chkpt_dir = FLAGS.chkpt_dir


def _check_and_clean_dir(d):
  if os.path.exists(d):
    shutil.rmtree(d)
  os.mkdir(d)


def main():
  home = home_out('')
  if not os.path.exists(home):
    os.makedirs(home)
  if not os.path.exists(_data_dir):
    os.mkdir(_data_dir)

  _check_and_clean_dir(_summary_dir)
  _check_and_clean_dir(_chkpt_dir)

  os.mkdir(os.path.join(_chkpt_dir, '1'))
  os.mkdir(os.path.join(_chkpt_dir, '2'))
  os.mkdir(os.path.join(_chkpt_dir, '3'))
  #os.mkdir(os.path.join(_chkpt_dir, '4'))
  os.mkdir(os.path.join(_chkpt_dir, 'fine_tuning'))

  start()
  #data, pretrain_data = read_data_sets()
  data, pretrain_data = simulation_data_sets()
  #ae = autoencoder.main_unsupervised(pretrain_data)
  #vars_to_init = ae.get_variables_to_init(ae.num_hidden_layers + 1)
  #ae.session.run(tf.initialize_variables(vars_to_init))
  #saver = tf.train.Saver(ae.variables)
  #saver.save(ae.session,"./pretrain_model_ppiprediction_rand.ckpt")

  ae = autoencoder.supervised_training(data)
  autoencoder.final_output(ae, data, node_feature_file = './encoded_matrix_025rand_yeast_r1.csv')
  vars_to_init = ae.get_variables_to_init(ae.num_hidden_layers + 1)
  saver = tf.train.Saver(ae.variables)
  saver.save(ae.session,"./supervised_model_ppiprediction_025rand_yeast_r1.ckpt")
  #autoencoder.decoder(ae, data, 3, node_feature_file = './featurefile_ppi_rand.txt')

if __name__ == '__main__':
    main()
