/*
 * sig_chld: sample program using fork() and SIGCHLD
 */

#include <sys/types.h>
#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include <sys/stat.h>
#include <sys/wait.h>
#include <fcntl.h>
#include <signal.h>
#include <string.h>

extern char **environ;

pid_t pid;

void sig_handler(int sig)
{
  pid_t child;
  int   status;
  
  printf("parent caught signal [%d]\n", sig);
  child = waitpid(pid, &status, 0);

  if ( WIFEXITED(status) )
    printf("child [%d] terminates NORMALLY with status (%d)(%d)\n",
        child, status, WEXITSTATUS(status));
  else
  if ( WIFSIGNALED(status) )
    printf("child [%d] terminates by SIGNAL with status (%d)(%d)\n",
        child, status, WTERMSIG(status));
}

main(int argc, char **argv)
{
  int i;
  char *arg[] = { "./sleep-15", 0 }; 
  
  signal(SIGCHLD, sig_handler);

  pid = fork();
  if (pid == 0) {   /* child */
    printf("I am child...\n");
    execve(arg[0], arg, environ);
  }
  else {            /* parent */
    for (i = 0; i < 20; i++) {
      printf("parent ... child(%d)\n", pid);
      sleep(1);
    }
  }
}
