package com.funwithlocalservices;

import android.app.AlarmManager;
import android.app.PendingIntent;
import android.app.Service;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Binder;
import android.os.IBinder;
import android.util.Log;

public class MyService extends Service {
	int val = 0;
	@Override
	public IBinder onBind(Intent arg0) {
		// TODO Auto-generated method stub
		return binder;
	}

	@Override
	public void onCreate() {
		super.onCreate();
		Log.d("MyService","Created");
	}

	@Override
	public void onDestroy() {
		super.onDestroy();
		unregisterReceiver(receiver);
		Log.d("MyService","Destroyed");
	}

	private final Binder binder = new LocalBinder();
	public class LocalBinder extends Binder {
		MyService getService() {
			Log.d("MyService","localbinder");
			return MyService.this;
		}
	}

	public int getCount()
	{		
		return val++;
	}
	public BroadcastReceiver receiver=new BroadcastReceiver() {
		public void onReceive(Context context, Intent intent) {
			Log.d("MyService","Received TimesUp message");
		}
	};

	public void startAlarm()
	{
		registerReceiver(receiver, new IntentFilter("com.FunWithServices.MyService.TIMESUP")); 
		Intent intent = new Intent(this, OneShotAlarmReceiver.class); 
		PendingIntent pendingIntent = PendingIntent.getBroadcast(this, 0, intent, PendingIntent.FLAG_ONE_SHOT); 
		AlarmManager alarmManager = (AlarmManager) getSystemService(Context.ALARM_SERVICE);
		alarmManager.set(AlarmManager.RTC_WAKEUP, System.currentTimeMillis() + (5 * 1000), pendingIntent);
		Log.d("MyService","Alarm is set");
	}


}
