package com.funwithlocalservices;

import android.app.Activity;
import android.content.ComponentName;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.IBinder;
import android.util.Log;
import android.view.View;
import android.widget.Button;

public class FunWithLocalServices extends Activity {
	private MyService myService = null;

    /** Called when the activity is first created. */
    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.main);
        
        Log.d("FunWithLocalServices","Starting Service");
        startService(new Intent(this, MyService.class));
        bindService(new Intent(this, MyService.class), connectionToMyService, BIND_AUTO_CREATE);


        Button button = (Button)findViewById(R.id.Button01);
        button.setOnClickListener(new View.OnClickListener() {
            public void onClick(View v) {
            	Log.d("FunWithLocalServices","val="+myService.getCount() ); }
        });

        
        
    }
    
    @Override
    public void onDestroy() {
    	super.onDestroy();
    	unbindService(connectionToMyService);
    }
    
    private ServiceConnection connectionToMyService = new ServiceConnection() {
       
		@Override
		public void onServiceConnected(ComponentName arg0, IBinder arg1) {
			myService = ((MyService.LocalBinder)arg1).getService();    
			
		}
		@Override
		public void onServiceDisconnected(ComponentName arg0) {
			// TODO Auto-generated method stub
			  myService = null;
		}
        };

        
}