function [group_approx,group_components,approx] = mptkGaborBookToComponents(book,dict)
n_blocks=numel(book.atom);
group_approx=cell(n_blocks,1);
group_components=[];
n=book.numSamples;
approx=zeros(n,1);
for ii=1:n_blocks
    atoms=book.atom(ii).params;
    [~,comp_indices,freq_index]=unique(atoms.freq);
    Ff=approx*0;
    for jj=1:numel(comp_indices)
        idx=freq_index==jj;
        %unpack atom info for this component
        natoms=sum(idx);
        a=atoms.amp(idx);
        f=atoms.freq(idx);
        L=atoms.len(idx);
        phi=atoms.phase(idx);
        pos=atoms.pos(idx);
        % form a new, single component book
        index_array=cat(1,1:natoms,ones(1,natoms),1:natoms,ones(1,natoms),zeros(1,natoms));
        nz=zeros(natoms,1);
        no=ones(natoms,1);
        atom_struct=struct('type','gabor','params',struct('amp',a,'chirp',nz,...
            'freq',f,'len',L,'phase',phi,'pos',pos,'windowoption',nz,'windowtype',9*no));
        one_comp_book=struct('format','0.1','numAtoms',natoms,'numChans',1,...
            'numSamples',n,'sampleRate',1,'index',index_array,'atom',atom_struct);
        comp=mprecons(one_comp_book,dict);% call to MPTK 
        group_components=cat(1,group_components,{comp});
        Ff=Ff+comp;
    end
    group_approx{ii}=Ff;
    approx=approx+Ff;
end
