function [grouped_atoms,grouped_waveforms] = mptkGaborBookToAtomsWaves(book,dict,phase_round)
n_blocks=numel(book.atom);
grouped_atoms=cell(n_blocks,1);
grouped_waveforms=cell(n_blocks,1);
for ii=1:numel(book.atom)% number of blocks included
    atoms=book.atom(ii).params;
    if phase_round==1
        approx_phase=round(atoms.phase/pi*4);
    else
        approx_phase=0*atoms.phase/pi;
    end
    [~,ia,freq_index]=unique([atoms.freq,approx_phase],'rows');
    len=atoms.len(1);
    grouped_atoms{ii}=[atoms.pos+1,freq_index,atoms.amp.*exp(1i*atoms.phase)];
    waves=zeros(len,numel(ia));
    for jj=1:numel(ia)
        f=atoms.freq(ia(jj));
        L=atoms.len(ia(jj));
        phi=atoms.phase(ia(jj));
        atom_struct=struct('type','gabor','params',struct('amp',1,'chirp',0,'freq',f,'len',L,...
            'phase',phi,'pos',0,'windowoption',0,'windowtype',9));
        fake_book=struct('format','0.1','numAtoms',1,'numChans',1,...
            'numSamples',L,'sampleRate',1,'index',[1 1 1 1 0]',...
            'atom',atom_struct);
        wave=mprecons(fake_book,dict);% call to MPTK
        wave_norm=norm(wave);
        waves(:,jj)=wave/exp(1i*phi)/wave_norm;
        grouped_atoms{ii}(freq_index==jj,3)=grouped_atoms{ii}(freq_index==jj,3)*wave_norm;
    end
    grouped_waveforms{ii}=waves;
end
