%Compares and tests the different invariance types for shiftInvariantKmeans
addpath clustering

rng(777)
Nsig=200;

%%
% First example, three different frequencies, waveforms appear with both
% polarities (6 waveforms in total)

X=bsxfun(@times,hamming(Nsig),cos(bsxfun(@times,2*pi*(0:Nsig-1)'*.025,[.5,1,2])));
X=cat(2,X,-X);
[label,V] = shiftInvariantKmeans(X,10);
[label,V2] = shiftInvariantKmeans(X,10,'abs');
[label,V3] = shiftInvariantKmeans(X,10,'hilbert');

figure(1),clf
set(gcf,'position',get(gcf,'position').*[ 1 1 0 0]+[0 0 680 680])
subplot(3,1,1)
plot(bsxfun(@plus,X/2,1:size(X,2)))
set(gca,'xgrid','on')
title('Original waveforms')

subplot(3,1,2:3)
plot(bsxfun(@plus,3*V,1:size(V,2))),hold all
m=size(V,2);
plot(2+m+bsxfun(@plus,3*V2,1:size(V2,2)))
m2=size(V2,2);
plot(4+m+m2+bsxfun(@plus,3*V3,1:size(V3,2)))

title('Centroid waveforms')
set(gca,'xgrid','on')
set(gca,'ytick',[1 3+m 5+m+m2],'yticklabel',{'Shift-invariant','Shift,sign-invariant','Phase-invariant'})
%% Second example, same waveform different phases
X=bsxfun(@times,hamming(Nsig),cos(bsxfun(@plus,2*pi*(0:Nsig-1)'*.1,linspace(-1,1,20)*pi)));
[label,V] = shiftInvariantKmeans(X,10);
[label,V2] = shiftInvariantKmeans(X,10,'abs');
[label,V3] = shiftInvariantKmeans(X,10,'hilbert');

figure(2),clf
set(gcf,'position',get(gcf,'position').*[ 1 1 0 0]+[0 0 560 560])
subplot(1,2,1)
plot(bsxfun(@plus,X/3,1:size(X,2)))
set(gca,'xgrid','on')
title('Original waveforms')

subplot(1,2,2)
plot(bsxfun(@plus,V,1:size(V,2))),hold all
m=size(V,2);
plot(2+m+bsxfun(@plus,V2,1:size(V2,2)))
m2=size(V2,2);
plot(4+m+m2+bsxfun(@plus,V3,1:size(V3,2)))
set(gca,'xgrid','on')

title('Centroid waveforms')
set(gca,'ytick',[1 3+m 5+m+m2],'yticklabel',{'Shift-invariant','Shift,sign-invariant','Phase-invariant'})
