function  getData(dataset)
switch lower(dataset)
    case '20news'
        out_dir='../data/20newsgroups/';
        out_file='20news.mat';
        if ~exist([out_dir,out_file],'file')
            url='http://qwone.com/~jason/20Newsgroups/20news-bydate-matlab.tgz';
            fout=websave([out_dir,'20news.tgz'],url);
            untar(fout,out_dir);
            a_dir=[out_dir,'20news-bydate/matlab/'];
            X=[];
            Y=[];
            for ii=1:2
                if ii==1
                    load([a_dir,'test.label'])
                    y=test;
                    load([a_dir,'test.data'])
                    x=test;
                else
                    load([a_dir,'train.label'])
                    y=train;
                    load([a_dir,'train.data'])
                    x=train;
                end
                IJS=x;
                s=sparse(IJS(:,1),IJS(:,2),IJS(:,3),numel(y),max(size(X,2),max(IJS(:,2))));
                if ii==1
                    Y=y;
                    X=s;
                else
                    Y=cat(1,Y,y);
                    X=cat(1,X,s);
                end
            end
            save([out_dir,out_file],'X','Y')
        end
    case 'coil20'
        out_dir='../data/coil-20-proc/';
        out_file='coil20.mat';
        if ~exist([out_dir,out_file],'file')
            url='http://www.cs.columbia.edu/CAVE/databases/SLAM_coil-20_coil-100/coil-20/coil-20-proc.zip';
            fout=websave([out_dir,'coil-20-proc.zip'],url);
            unzip(fout,out_dir);
            stuff=dir([out_dir,'coil-20-proc']);
            fig_count=0;
            for ii= 1:size(stuff,1)
                fig_found=strfind(stuff(ii).name,'.png');
                if ~isempty(fig_found)
                    fig_count=fig_count+1;
                end
            end
            ndim=128;
            images=zeros(fig_count,ndim^2);
            fig_label=zeros(fig_count,2);
            fig_counter=0;
            for ii= 1:size(stuff,1)
                fig_found=strfind(stuff(ii).name,'.png');
                if ~isempty(fig_found)
                    img=imread([out_dir,'coil-20-proc/',stuff(ii).name],'png');
                    fig_counter=fig_counter+1;
                    images(fig_counter,:)=img(:);
                    A=sscanf(stuff(ii).name,'obj%i__%i.png');
                    fig_label(fig_counter,:)=A;
                end
            end
            [~,idx]=sort(fig_label(:,1));
            images=images(idx,:);
            fig_label=fig_label(idx,:);
            save([out_dir,out_file],'images','fig_label')
        end
    case 'mnist'
        out_dir='../data/mnist/';
        out_file='mnist_test.mat';
        if ~exist([out_dir,out_file],'file')
            url='http://yann.lecun.com/exdb/mnist/t10k-images-idx3-ubyte.gz';
            fout=websave([out_dir,'t10k-images-idx3-ubyte.gz'],url);
            gunzip(fout,out_dir)
            url='http://yann.lecun.com/exdb/mnist/t10k-labels-idx1-ubyte.gz';
            fout=websave([out_dir,'t10k-labels-idx1-ubyte.gz'],url);
            gunzip(fout,out_dir)
            % download helper functions
            url='http://ufldl.stanford.edu/wiki/resources/mnistHelper.zip';
            fout=websave([out_dir,'mnistHelper.zip'],url);
            unzip(fout,out_dir);
            addpath(out_dir)
            test_X = loadMNISTImages('t10k-images-idx3-ubyte').';
            test_labels = loadMNISTLabels('t10k-labels-idx1-ubyte')+1;
            rmpath(out_dir)
            [test_labels,idx]=sort(test_labels);
            test_X=test_X(idx,:);
            save([out_dir,out_file],'test_X','test_labels')
        end
    case 'orl'
        out_dir='../data/orl_faces/';
        out_file='orl.mat';
        if ~exist([out_dir,out_file],'file')
            url='http://www.cl.cam.ac.uk/Research/DTG/attarchive/pub/data/att_faces.zip';
            fout=websave([out_dir,'att_faces.zip'],url);
            unzip(fout,out_dir);
            images=zeros(10,40,92*112);
            fig_label=zeros(40*10,1);
            fig_counter=1;
            for subject_ii=1:40
                for photo_ii=1:10
                    img=imread(sprintf('%ss%i/%i.pgm',out_dir,subject_ii,photo_ii),'pgm');
                    images(photo_ii,subject_ii,:)=img(:);
                    fig_label(fig_counter)=subject_ii;
                    fig_counter=fig_counter+1;
                end
            end
            ndim=112;
            save([out_dir,out_file],'images','fig_label','ndim');
        end
    case 'uci'
        out_dir='../data/uci/';
        out_files={
            'datasets-uci-wisconsin_breast_cancer_wbdc',...
            'sonar_uci',...
            'datasets-uci-ionosphere',...
            'datasets-uci-parkinson',...
            'datasets-uci-iris',...
            'datasets-uci-glass',...
            'datasets-uci-ecoli'};
        for ii=1:numel(out_files)
            out_file=out_files{ii};
            if ~exist([out_dir,out_file,'.mat'],'file')
                switch out_file
                    case 'datasets-uci-wisconsin_breast_cancer_wbdc'
                        url='https://archive.ics.uci.edu/ml/machine-learning-databases/breast-cancer-wisconsin/wdbc.data';
                        fname=websave([out_dir,'wdbc.data'],url);
                        fid=fopen(fname,'r');        
                        str=repmat('%f,',1,30);
                        C=textscan(fid,['%u,%c,',str(1:end-1)]);
                        fclose(fid);
                        all_labels=1*(C{2}=='M')+1;
                        pX=cell2mat(C(3:end));
                    case 'sonar_uci'
                        url='http://archive.ics.uci.edu/ml/machine-learning-databases/undocumented/connectionist-bench/sonar/sonar.all-data';                        
                        fname=websave([out_dir,'sonar.all-data'],url);
                        fid=fopen(fname,'r');                        
                        C=textscan(fid,[repmat('%f,',1,60),'%c']);
                        fclose(fid);
                        all_labels=1*(C{end}=='M')+1;
                        pX=cell2mat(C(1:end-1));
                   case 'datasets-uci-ionosphere'
                        url='https://archive.ics.uci.edu/ml/machine-learning-databases/ionosphere/ionosphere.data';                        
                        fname=websave([out_dir,'ionosphere.data'],url);
                        fid=fopen(fname,'r');                        
                        C=textscan(fid,[repmat('%f,',1,34),'%c']);
                        fclose(fid);
                        all_labels=1*(C{end}=='g')+1;
                        pX=cell2mat(C([1 3:end-1])); % the second column is constant!
                    case 'datasets-uci-parkinson'
                        url='https://archive.ics.uci.edu/ml/machine-learning-databases/parkinsons/parkinsons.data';
                        fname=websave([out_dir,'parkinsons.data'],url);
                        fid=fopen(fname,'r');   
                        str=repmat('%f,',1,23);
                        C=textscan(fid,['%*[^,],',str(1:end-1)],'Headerlines',1);                        
                        fclose(fid);
                        pX=cell2mat(C([1:end-7,end-5:end]));
                        all_labels=C{end-6};
                    case 'datasets-uci-iris'
                        url='https://archive.ics.uci.edu/ml/machine-learning-databases/iris/iris.data';
                        fname=websave([out_dir,'iris.data'],url);
                        fid=fopen(fname,'r');   
                        C=textscan(fid,[repmat('%f,',1,4),'%s']);                        
                        fclose(fid);
                        pX=cell2mat(C(1:end-1));
                        [~,~,all_labels]=unique(C{end});         
                    case 'datasets-uci-glass'
                        url='https://archive.ics.uci.edu/ml/machine-learning-databases/glass/glass.data';
                        fname=websave([out_dir,'glass.data'],url);
                        fid=fopen(fname,'r');   
                        str=repmat('%f,',1,11);
                        C=textscan(fid,str(1:end-1));                        
                        fclose(fid);
                        pX=cell2mat(C(2:end-1));
                        all_labels=C{end};
                    case 'datasets-uci-ecoli'
                        url='https://archive.ics.uci.edu/ml/machine-learning-databases/ecoli/ecoli.data';
                        fname=websave([out_dir,'ecoli.data'],url);
                        fid=fopen(fname,'r');   
                        C=textscan(fid,['%s ',repmat('%f ',1,7),'%s']);                        
                        fclose(fid);
                        pX=cell2mat(C(2:end-1));
                        [~,~,all_labels]=unique(C{end});                                 
                    otherwise 
                        error('not implemented yet')
                end                                
                save([out_dir,out_file,'.mat'],'pX','all_labels');
            end
        end
        
    case 'umist'
        out_dir='../data/umist/';
        out_file='umist_cropped.mat';
        if ~exist([out_dir,out_file],'file')
            url='http://www.cs.nyu.edu/~roweis/data/umist_cropped.mat';
            websave([out_dir,out_file],url);
        end
    case 'usps'
        out_dir='../data/usps/';
        out_file='usps.mat';
        if ~exist([out_dir,out_file],'file')
            url='http://web.stanford.edu/~hastie/ElemStatLearn/datasets/zip.train.gz';
            fout=websave([out_dir,'zip.train.gz'],url);
            gunzip(fout,out_dir)
            
            url='http://web.stanford.edu/~hastie/ElemStatLearn/datasets/zip.test.gz';
            fout=websave([out_dir,'zip.test.gz'],url);
            gunzip(fout,out_dir)
            
            x=importdata([out_dir,'zip.train']);
            y=importdata([out_dir,'zip.test']);
            x=cat(1,x,y);
            Y=x(:,1);
            images=x(:,2:end);
            [Y,resort]=sort(Y);
            images=images(resort,:);
            ndim=16;
            save([out_dir,out_file],'Y','images','ndim')
        end
        
end
end