function [x,l,X,L ] = generate_2D_cluster_data_set(n,data_name,data_std,class_balanced )

if nargin<4
    class_balanced=1;
end

if nargin<3
    data_std=.25;
end
    
if nargin<2
data_name='blobs';
end



if ischar(data_name(1))
 STRS = get_cluster_sets();
end

M=inf(30,75);
for row=1:30
str=STRS{row};
str(str=='=')='0';
str(str==' ')=0;
[~,col,val]=find(str);
M(row,col)=val-'0';
M(row,M(row,:)==0)=nan;
end
B=isnan(M);

Lc=1+cumsum(B,1);
Lr=1+cumsum(B,2);
Lc(:,Lc(end,:)==size(B,1)+1)=0;
Lr(Lr(:,end)==size(B,2),:)=0;


if ischar(data_name(1))
switch data_name
    case 'wedges'%6
        id=[2 3];
    case 'boxes'%5
        id=[2 2];
    case 'rings'%4
        id=[2 1];
    case 'moons'%1
        id=[1 1];
    case 'spirals'%3
        id=[1 3];
    case {'blobs','cluster','gaussian'};%2
        id=[1 2];
end
else
    [i,j]=ind2sub([3 2],data_name-1);
    id=[j,i];
end

sel_mask= ismember(Lc,id(:,1)) & ismember(Lr,id(:,2));


[y,x,v]=find(~isinf(M) & sel_mask);
L=M(sub2ind(size(M),y,x));
[~,~,L]=unique(L);
xorigin=find(any(sel_mask),1,'first');
yorigin=find(any(sel_mask,2),1,'last');
X=cat(2,x-xorigin,yorigin-y);

K=max(L);
x=[];
l=[];
if class_balanced==1
    c=randi(K,n,1);
    for ii=1:K
        Nl=sum(L==ii);
        Nd=sum(c==ii);
        X_ii=X(L==ii,:);
        x=cat(1,x,X_ii(randi(Nl,Nd,1),:));
        l=cat(1,l,ii*ones(Nd,1));
    end
else
    ii=randi(size(X,1),n,1);
    [l,sort_idx]=sort(L(ii));
    x=X(ii(sort_idx),:);
end
x=x+data_std*randn(n,2);
end
function STRS = get_cluster_sets()
STRS={
'                           =                          =                   '
'     1111111               =               2          =   222             '
'   111111111               =    1          2          =  22     1111111   '
'  1111                     =               2          =  2    111     111 '
' 1111                      =                     444  = 22   11         11'
' 1111   2222               =                   444444 = 2   11    22     1'
' 111    222222             =                 44444444 = 2   11     22    1'
' 111       2222            =                44444444  = 22   11     22   1'
' 1111        222           =    33         44444444   =  2    11    22   1'
'   1111111   222           =   3333       44444444    =  22        22   11'
'     11111   222           =   3333       4444444     =   22     222   11 '
'             222           =    33         4444       =    2222222    11  '
'            2222           =                          =              11   '
'       2222222             =                          =  11        111    '
'      222222               =                          =    111111111      '
'=========================================================================='
'        1111111111         = 444    1111111111111111  =     11111111111   '
'     1111        11        = 444    1              1  =       111111111   '
'    1111          11       = 444    1              1  =         1111111   '
'   1111    2222     11     = 444    1   222222222  1  =  222       1111   '
'   11    222   22    11    = 444    1   222222222  1  =    222       11   '
'  11    22      22    11   =        1              1  =      222         3'
'  11    2   33   22   11   =        1              1  =        222      33'
'  11    2   333   2   11   =        1              1  =      222      3333'
'  11    2   33    2   11   =        1              1  =    222      333333'
'  11    22      222   11   = 555    1   333333333  1  =  222      3333 333'
'   11    22222222     11   = 555    1   333333333  1  =         33333  333'
'    11               111   =        1              1  =       33333    333'
'     111            111    =        1              1  =     33333      333'
'       11111111111111      = 666    1111111111111111  =   3333333333333333'};
end

