info_func={@matrix_info_fro;%1
    @matrix_info_cosine;%2
    @matrix_info_hsic;%3
    @matrix_info_cka;%4
    @matrix_info_chernoff;%5
    @quantum_hellinger_info;%6
    @bures_lb_matrix_info;%7
    @bures_super_lb_matrix_info;%8
    @matrix_info_lawley;%9
    @matrix_info_bartlett;%10
    };
func_names={
    'Euclidean',...
    'Cosine',...
    'HSIC',...
    'CKA',...
    'Chernoff',...
    'QH',...
    'Bures',...
    'Sub-Bures',...
    'Lawley',...
    'Bartlett'};

bures_index=7; %plot only this measure
n=5;
% cover the possible graphs with 10 edges
[X1,X2,X3,X4,X5,X6,X7,X8,X9,X0]=ndgrid([ 0 1]');
XX=[X1(:),X2(:),X3(:),X4(:),X5(:),X6(:),X7(:),X8(:),X9(:),X0(:)];

% index the edges within each graph
x=find(tril(ones(n),-1));
[I,J]=ind2sub([n n],x);
idx=cat(1,x,sub2ind([n n],J,I));

% storage
dbar=zeros(numel(X1),1);
info_val=zeros(numel(X1),numel(info_func));
eigen_val=zeros(numel(X1),n+1);

G=zeros(n);
tic
for ii=1:numel(X1)
    G(idx)=repmat(XX(ii,:),1,2);
    
    d=sum(G);
    d12=min(1,sqrt(1./d));
    L=diag(d)-G;
    nL=eye(n)-bsxfun(@times,bsxfun(@times,G,d12),d12');
    
    eigen_val(ii,1:n)=sort(eig(nL));
    eigen_val(ii,n+1)=norm(mean(nL));
    dbar(ii)=mean(d);
    
    for jj=1:numel(func_names)
        info_val(ii,jj)=info_func{jj}(nL);
    end
end
toc

%%
%find possibly unique graphs by their spectrum and norm of the degree vector
[~,ii]=unique(round(1e6*eigen_val),'rows');
XX=XX(ii,:);
info_val=info_val(ii,:);
dbar=dbar(ii,:);

%% divide the graphs by their edge counts
unique_edge_counts=unique(dbar(:)*n/2);
% use the Bures-based informativeness
[~,vv]=sort(info_val(:,bures_index),'descend');


%%
fontsize=14;
figure(9),clf
set(gcf,'position',get(gcf,'position').*[1 1 0 0] + [0 0 560   175])
K=3;
labels=upper('abcdefghijklmnop');

for kk=1:K
    graph_ii=vv(kk)';
    G(idx)=repmat(XX(graph_ii,:),1,2);
    pperm=symrcm(G);
    G=G(pperm,pperm);
    
    [I,J]=find(tril(G,-1));
    
    
    tt=linspace(0,2*pi,1+size(G,1)).';
    xy=[cos(tt(1:end-1)),sin(tt(1:end-1))];
    h=subplot(2,2*K,kk+K);
    
    for ii=1:numel(I)
        plot(xy([I(ii);J(ii)],1),xy([I(ii);J(ii)],2),'-k','linewidth',4)
        hold all;
    end
    for ii=1:size(G,1)
        plot(xy(ii,1),xy(ii,2),'ko','markersize',8,'markerfacecolor',[.75 .75 .75])
    end
    
    set(gca,'DataAspectRatio',[1 1 1])
    xlabel(labels(kk))
    set(gca,'fontsize',fontsize)
    set(gca,'visible','off')
    set(gca,'xlim',[-2 2],'ylim',[-2 2])
    text(0,2.2,labels(kk),'horiz','center','fontsize',fontsize,'fontweight','normal')
    text(0,-8,sprintf('%.3f',info_val(kk,7)),'horiz','center','fontsize',fontsize,'fontweight','normal')
    
    
    h=subplot(2,2*K,kk+K+2*K);
    if kk==1 || kk==3
        G=G(n:-1:1,n:-1:1);
    end
    [I,J]=find(tril(G,-1));
    d=sum(G);
    d12=sqrt(1./d);
    I=I.';
    J=J.';
    nL=sparse([I,J,1:n],[J,I,1:n],[repmat(-d12(I).*d12(J),1,2),ones(1,n)],n,n);
    
    mat2patch(nL);
    axis square
    caxis([-1 1])
    colormap(flipud(gray))
    set(gca,'visible','off')
    set(h,'position',get(h,'position')+[0 .1 0 0 ])
end
subplot(2,2*K,[(1:K) (1:K)+2*K])
plot(dbar*n/2,info_val(:,7),'xk','markersize',8,'linewidth',1.5)
ylabel('Informativeness')
xlabel('Number of edges')
set(gca,'xlim',[-0.1 10.1],'ylim',[-0.01 0.16])
set(gca,'xtick',0:2*n)
set(gca,'position',[   0.1300    0.2200    0.3714    0.75])
for kk=1:K
    text(dbar(vv(kk))*n/2,info_val(vv(kk),7)-.015,labels(kk),'horiz','center','fontsize',fontsize,'fontweight','normal')
end
set(gca,'fontsize',13)
set(gca,'xgrid','on','ygrid','on')

set(gcf,'paperpositionmode','auto')
saveas(gcf,'../results/Figure_9_small_graph_example','epsc2')


%% Find the subset of trees for n=5
%hint there are only 3
G=zeros(n);
tree_idx=find(dbar*n/2 == n-1); %trees have n-1 edges, but so do some disconnected graphs
for ii=1:numel(tree_idx)
    G(idx)=repmat(XX(tree_idx(ii),:),1,2);
    d=sum(G);
    L=diag(d)-G;
    if    max(eigs(L,2,'SA')) <1/n^2 % not connected, so not a tree
        tree_idx(ii)=0;
    end
end
tree_idx(tree_idx==0)=[];
fprintf('Informativeness for the three trees with n=5\n')
fprintf('%.3f, ',info_val(tree_idx,bures_index).')
fprintf('\n')
%% Calculate the informativeness for the trees with n=6
n=6;
trees={ [1 2; 2 3 ; 3 4; 4 5; 5 6]; % path
    [1 6; 2 6; 3 6; 4 6; 5 6]; % star
    [1 2; 3 2; 4 2; 5 2; 5 6]; % sword
    [1 3; 2 3; 3 4; 4 5; 6 4]; % horse
    [1 2; 2 3; 2 4; 4 5; 5 6]; % tall Y
    [1 2; 2 3; 3 4; 3 5; 5 6]}; % fat Y
    
    
tic
info_val2=zeros(numel(trees),numel(info_func));

idx12=find(tril(ones(n),-1));
XX2=zeros(numel(trees),numel(idx12));
[I,J]=ind2sub([n n],idx12);
idx2=cat(1,idx12,sub2ind([n n],J,I));

for ii=1:numel(trees)
    G=sparse(trees{ii}(:,1),trees{ii}(:,2),1,n,n);
    G2=G+G.';
        XX2(ii,:)=G2(idx12);
        d=sum(G2);
        d12=min(1,sqrt(1./d));
        L=diag(d)-G2;
        nL=eye(n)-bsxfun(@times,bsxfun(@times,G2,d12),d12');
        for jj=1:numel(func_names)
            info_val2(ii,jj)=info_func{jj}(nL);
        end
end
toc


%% plot the trees by their informativeness

figure(10),clf
set(gcf,'position',get(gcf,'position').*[1 1 0 0] + [0 0 560   1.8*95])
[tree_info,vv]=sort(info_val2(:,bures_index),1,'descend');
G=zeros(n);
K=6;
for kk=1:K
    graph_ii=vv(kk)';
    G(idx2)=repmat(XX2(graph_ii,:),1,2);
    pperm=symrcm(G);
    G=G(pperm,pperm);
    
    [I,J]=find(tril(G,-1));
    tt=linspace(0,2*pi,1+size(G,1)).';
    xy=[cos(tt(1:end-1)),sin(tt(1:end-1))];
    h=subplot(2,K,kk);
    
    for ii=1:numel(I)
        plot(xy([I(ii);J(ii)],1),xy([I(ii);J(ii)],2),'-k','linewidth',4)
        hold all;
    end
    for ii=1:size(G,1)
        plot(xy(ii,1),xy(ii,2),'ko','markersize',8,'markerfacecolor',[.75 .75 .75])
    end
    set(gca,'DataAspectRatio',[1 1 1])
    set(gca,'xlim',[-1.5 1.5],'ylim',[-1.5 1.5])
    xlabel(labels(kk))
    set(gca,'fontsize',fontsize)
    set(gca,'visible','off')
    text(-0,-5.5,sprintf('%.3f',tree_info(kk)),'horiz','center','fontsize',fontsize,'fontweight','normal')
    h=subplot(2,K,kk+K);
    if kk==6
        [~,pperm]=sort(sum(G,2));
        G=G(pperm,pperm);
    end
    mm=(1:n)*sum(G,2)/sum(sum(G,2));
    if mm>=3
        G=G(n:-1:1,n:-1:1);
    end
    [I,J]=find(tril(G,-1));
    d=sum(G);
    d12=sqrt(1./d);
    I=I.';
    J=J.';
    nL=sparse([I,J,1:n],[J,I,1:n],[repmat(-d12(I).*d12(J),1,2),ones(1,n)],n,n);
    set(h,'position',get(h,'position')+[0 .15 0 0 ])
    
    mat2patch(nL);
    axis square
    caxis([-1 1])
    colormap(flipud(gray))
    set(gca,'visible','off')
end

set(gcf,'paperpositionmode','auto')
saveas(gcf,'../results/Figure_10_tree_example','epsc2')

