rng(880);
info_func={
    @bures_lb_matrix_info;
    ...@matrix_info_fro;
    ...    @matrix_info_cosine;
    ...    @matrix_info_hsic;
    ...    @matrix_info_cka;
    ...    @matrix_info_chernoff;
    ...    @quantum_hellinger_info;
    ...    @bures_super_lb_matrix_info;
    };
func_names={
    'Bures'...
    ...,'Euclidean',...
    ...'Cosine',...
    ...'HSIC',...
    ...'CKA',...
    ...'Chernoff',...
    ...'QH',...
    ...'Sub-Bures'
    };


sigma=[.001*sqrt(10) .01 .01*sqrt(10) .1 .1*sqrt(10) 1 1*sqrt(10) 10 10*sqrt(10) 100];
info_val=nan(numel(sigma),numel(info_func));

entropy_val=nan(numel(sigma),1);
entropy_func=@(p) -p(:)'*log2((p(:)==0)+p(:));

vonN=@(x) -x(x>0)'*log2(x(x>0));

dim=1;
d_sep=4;
fdis=@(N1,N2) cat(1,randn(round(N1/2),dim),randn(N1-round(N1/2),dim),...
    bsxfun(@plus,d_sep,randn(round(N2/2),dim)),bsxfun(@plus,d_sep,randn(N2-round(N2/2),dim)));

corr_mat=cell(numel(sigma),1);
corr_mat_sorted=corr_mat;

n=16;
n1=round(n/2);
n2=n-n1;

l=[ones(1,n1),zeros(1,n2)];
L=bsxfun(@eq,l,l.');
mu=mean(L);
Lc=bsxfun(@minus,bsxfun(@minus,L,mu),mu')+mean(mu);
Lc=(Lc+Lc')/2;

A=fdis(n1,n2);
D2= squareform(pdist(A)).^2;

for ii=1:numel(sigma)
    K=exp(-1/2*D2/sigma(ii).^2);
    K=(K+K')/2;
    mu=mean(K);
    Kc=bsxfun(@minus,bsxfun(@minus,K,mu),mu')+mean(mu);
    Kc=(Kc+Kc')/2;
    for jj=1:numel(info_func)
        info_val(ii,jj)= info_func{jj}(K);
    end
    % calculate
    entropy_val(ii)=entropy_func(max(0,eig(K))/trace(K));
    % Correlation matrix
    corr_mat{ii}=K;
    % Form the graph Laplacian to get Fiedler vector for reordering the
    % correlation matrix
    L=diag(sum(corr_mat{ii},2))-corr_mat{ii};
    [U,~]=eigs(L,2,'SA');
    [~,idx]=min(sum(abs(U),1));
    [~,idx]=sort(U(:,idx));
    corr_mat_sorted{ii}=corr_mat{ii}(idx,idx);
end

%%
figure(7),clf
set(gcf,'position',get(gcf,'position').*[1 1 0 0]+[0 0   800   285])

val=info_val(:,1);
% Plot the entropy
subplot(3,numel(sigma),(1:numel(sigma))+2*numel(sigma))

h2=plot(1:numel(sigma),entropy_val);
my_gray=[.5 .25 .25];
set(h2,'linewidth',2,'linestyle',':','marker','x','color',my_gray,'markersize',10)
set(gca,'xtick',1:numel(sigma),'xgrid','on','xlim',[.55 numel(sigma)+.35])
set(gca,'fontsize',13)
legend('Entropy (bits) ','location','southwest')
set(gca,'xticklabel',[])

xticklabel={ cell(1,numel(sigma)),cell(1,numel(sigma))};
for ii=1:numel(sigma)
    
    xticklabel{1}{ii}=sprintf('%.2f',val(ii));
    xticklabel{2}{ii}=sprintf('%.2f',entropy_val(ii));
    
    subplot(3,numel(sigma),ii+numel(sigma))
    set(gca,'position',get(gca,'position')+[0.005 0.075 0 0])
    
    mat2patch(corr_mat{ii});
    
    colormap(flipud(gray))
    caxis([-1 1])
    axis square
    set(gca,'visible','off')
end

subplot(3,numel(sigma),1:numel(sigma))
h1=plot(1:numel(sigma),val);
set(h1,'linewidth',2,'linestyle',':','marker','x','color','k','markersize',10)
set(gca,'xtick',1:numel(sigma),'xgrid','on','xlim',[.55 numel(sigma)+.35])
set(gca,'fontsize',13)
set(gca,'ylim',[-0.03 0.3])
legend('Informativeness ','location','northwest')
set(gca,'XAxisLocation','bottom','xticklabel',[])
abs_offset=max(val)/4;
for ii=1:numel(sigma)
    offset=abs_offset;
    if val(ii)>max(val)/2
        offset=-abs_offset;
    end
    text(ii,val(ii)+offset,xticklabel{1}{ii},'hor','center','fontsize',13);
end
subplot(3,numel(sigma),(1:numel(sigma))+2*numel(sigma))

sigma_tick=arrayfun(@(x) num2str(x),sigma,'uni',0);
sigma_tick(1:2:end)={''};
set(gca,'XAxisLocation','bottom','xticklabel',sigma_tick)
set(gca,'ylim',[-0.4 4.4])
val=entropy_val;
abs_offset=max(val)/4;
for ii=1:numel(sigma)
    offset=abs_offset;
    if val(ii)>max(val)/2
        offset=-abs_offset;
    end
    text(ii,val(ii)+offset,xticklabel{2}{ii},'hor','center','fontsize',13,'color',my_gray);
end
xlabel('Gaussian bandwidth')
set(gca,'position',get(gca,'position')+[0 0.15 0 0])

set(gcf,'paperpositionmode','auto')
saveas(gcf,'../results/Figure_7_kernelsize_bandwidth.eps','epsc2')

