% make the set of 3-by-3 correlation matrices 
xx=linspace(-1,1,60);
[xi,yi,zi] = meshgrid(xx,xx,xx);
XX=[xi(:),yi(:),zi(:)];

idx=[2 3 6  4 7 8];
rho=1*eye(3);

plot_idx=zeros(numel(xi),1);
tol=1e-12;
for ii=1:numel(xi)
    rho(idx)=repmat(XX(ii,:),1,2);
    p=eig(rho);
    plot_idx(ii)=min(p);
end

%%
sub_fig_name={'a_elliptope_wireframe','b_info_side','c_info_front'};
for fig_ii=1:3
    figure(400+fig_ii),clf,
    p = patch(isosurface(xi,yi,zi,reshape(plot_idx,size(xi)),0));
    
    switch fig_ii
        case 1
            isonormals(xi,yi,zi,reshape(plot_idx,size(xi)), p)
            set(p,'FaceColor','y','facealpha',0.5,'EdgeColor','none');
            hold all
            camlight
            lighting phong
            av=[1 -1 -1; -1 1 -1; -1 -1 1; 1 -1 -1 ; 1 1 1 ; -1 -1 1 ; 1 1 1 ; -1 1 -1 ];
            plot3(av(:,1),av(:,2),av(:,3),'-k','linewidth',3,'color','b');
            
        case {2,3}
            x2=get(p,'vertices');
            dist=zeros(size(x2,1),1);
            for ii=1:size(x2,1)
                rho(idx)=repmat(x2(ii,:),1,2);
                dist(ii)=bures_lb_matrix_info(rho);%lower bound
            end
            
            set(p,'CData',dist);
            set(p,'FaceColor','interp','facealpha',1,'EdgeColor','none','edgealpha',.5);
            hold all
            colormap(flipud(parula))
    end
    
    colorbar('location','northoutside')
    set(gca,'fontsize',20)
    
    % mark the identity matrix (I)
    h=plot3(0,0,0,'g+');
    set(h,'markersize',20,'linewidth',4);

    hold all
    % mark the constant matrix (J)    
    h=plot3(1,1,1,'gs');
    set(h,'markersize',10,'linewidth',4);
    % mark the centering matrix (H)
    h=plot3(-1/2,-1/2,-1/2,'gx');
    set(h,'markersize',15,'linewidth',4);
    % plot the line between H and J
    av=[1 -.5]';
    plot3(av,av,av,'-g','linewidth',3);
    
    % mark the three cut matrices
    h=plot3(-1,-1,1,'k^');
    set(h,'markersize',10,'linewidth',4);
    h=plot3(-1,1,-1,'k<');
    set(h,'markersize',10,'linewidth',4);
    h=plot3(1,-1,-1,'k>');
    set(h,'markersize',10,'linewidth',4);
    
    %ensure the plot is square
    axis square
    axis equal
    switch fig_ii
        case 1
            campos([   10.3075  -13.3523    4.1895])
        case 2
            campos([   10.3075  -13.3523    4.1895])
        case 3
            campos([  12.7326   12.6629   10.4413])
    end
    camup([0 0 1])
    set(gca,'fontsize',20)
    set(gca,'ytick',[-1 0 1],'ztick',[-1 0 1],'ytick', [-1 0 1])
    set(gca,'visible','off')
    
    set(gcf,'position',get(gcf,'position').*[1 1 0 0]+[0 0   361   354])    
    set(gcf,'paperpositionmode','auto')
    saveas(gcf,['../results/Figure_4',sub_fig_name{fig_ii}],'epsc2')
end



